---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Speedtest1（Worker版）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/speedtest1-worker.html` 行1-374
- E-02: `ext/wasm/speedtest1-worker.js` 行1-130
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行11
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行42-46

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトル"speedtest1.wasm Worker" | E-01 行9, 12 | ○ |
| C-02 | メインスレッド版へのリンク表示 | E-01 行13 | ○ |
| C-03 | フラグ選択リスト（複数選択可）存在 | E-01 行32-33 | ○ |
| C-04 | Runボタン存在 | E-01 行54 | ○ |
| C-05 | Reset Flagsボタン存在 | E-01 行52 | ○ |
| C-06 | Clear outputボタン存在 | E-01 行53 | ○ |
| C-07 | Reverse log orderチェックボックス存在 | E-01 行60 | ○ |
| C-08 | speedtest1リンク存在 | E-01 行40-41 | ○ |
| C-09 | speedtest1-kvvfsリンク存在 | E-01 行46-47 | ○ |
| C-10 | new Worker("speedtest1-worker.js?sqlite3.dir=jswasm")でWorker作成 | E-01 行172-176 | ○ |
| C-11 | mPost()でWorkerにメッセージ送信 | E-01 行178-180 | ○ |
| C-12 | フラグオブジェクトでフラグ名と説明を管理 | E-01 行215-264 | ○ |
| C-13 | W.onmessageでWorkerメッセージ受信 | E-01 行346-370 | ○ |
| C-14 | 'ready'メッセージでUI表示 | E-01 行349-352 | ○ |
| C-15 | 'run-start'/'run-end'で実行状態管理 | E-01 行355-362 | ○ |
| C-16 | Worker側でonmessageで'run'メッセージ処理 | E-02 行95-106 | ○ |
| C-17 | runSpeedtest()でベンチマーク実行 | E-02 行52-93 | ○ |
| C-18 | opfs-sahpoolをrealSahNameに変換 | E-02 行50, 60-63 | ○ |
| C-19 | installOpfsSAHPoolVfs()でSAHPool初期化 | E-02 行66-79 | ○ |
| C-20 | wasm.xCall('wasm_main', ...)でspeedtest1実行 | E-02 行81-82 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] フラグ選択UIの動作を確認
- [ ] Worker通信のメッセージ形式を確認
- [ ] VFS切り替え（特にopfs-sahpool）の動作を確認
- [ ] メインスレッド版との機能差分を確認
