---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-Speedtest1（WASMFS版）画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **COOP/COEPヘッダー要件**：画面遷移図からの推測であり、実際のサーバー設定は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/speedtest1-wasmfs.html` - メインHTMLファイル
- E-02: `ext/wasm/speedtest1-wasmfs.mjs` - Workerスクリプト
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.11）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はWASMFS/OPFS永続ストレージを使用する | E-02 行11-30, 行42 | ○ |
| C-02 | Workerスレッドで実行される | E-01 行39-42 | ○ |
| C-03 | ES6モジュールとしてWorkerを起動 | E-01 行40-41 `{type: 'module'}` | ○ |
| C-04 | URLパラメータからフラグを取得 | E-02 行49-63 | ○ |
| C-05 | デフォルトフラグは--singlethread, --nomutex等 | E-02 行56-61 | ○ |
| C-06 | speedtest1-worker.htmlへのリンクがある | E-01 行13 | ○ |
| C-07 | 開発者ツールで速度低下する警告がある | E-01 行14-17 | ○ |
| C-08 | 機能No.1 SQLiteライブラリ初期化が関連 | E-04 行47 | ○ |
| C-09 | 機能No.43 OS抽象化層（VFS）が関連 | E-04 行48 | ○ |
| C-10 | wasm_mainを呼び出してベンチマーク実行 | E-02 行79-80 | ○ |
| C-11 | --big-transactionsフラグが使用される | E-02 行68 | ○ |
| C-12 | テスト用DBファイルは実行後削除される | E-02 行73, 78, 82 | ○ |
| C-13 | OPFS非対応時はエラーメッセージ表示 | E-02 行44-46 | ○ |
| C-14 | postMessageでメインスレッドに通信 | E-02 行2-4 | ○ |
| C-15 | log/logErrの2種類のメッセージタイプ | E-01 行45-48 | ○ |
| C-16 | sqlite3__wasm_init_wasmfsでOPFS初期化 | E-02 行19-20 | ○ |
| C-17 | 画面カテゴリはベンチマーク | E-03 行12 | ○ |
| C-18 | COOP/COEPヘッダーが必要 | E-05 行149-150（推測） | △ |

## 4) 不足情報（Unknown / Missing）
- COOP/COEPヘッダー要件はサーバー設定に依存するため、画面遷移図の備考から推測
  - 候補：サーバー設定ファイル / HTTPDドキュメント / althttpdソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほぼすべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] WASMFS対応ビルドが実際に必要かサーバー設定と合わせて確認
- [ ] URLパラメータのフラグ指定が実際に機能するか動作確認
- [ ] 開発者ツール警告の文言が現行と一致するか確認
