---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-Tester1（メインスレッド版）画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/tester1.c-pp.html` - メインHTMLテンプレート
- E-02: `ext/wasm/tester1.c-pp.js` - テストフレームワークとテストケース
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.12）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UIスレッドで実行される | E-02 行61, 98-99 "Running in the UI thread." | ○ |
| C-02 | sqlite3.jsとtester1.jsをロード | E-01 行40-42 | ○ |
| C-03 | TestUtilフレームワークでテスト実行 | E-02 行175-253 TestUtilオブジェクト | ○ |
| C-04 | テストグループを順次実行 | E-02 行268-300+ TestGroup.run() | ○ |
| C-05 | 成功/失敗をタイトルと色で表示 | E-02 行132-142 reportFinalTestStatus() | ○ |
| C-06 | チェックボックスでログ順序を逆転 | E-01 行29-31, E-02 行111-121 | ○ |
| C-07 | localStorageに設定保存 | E-02 行115-116 localStorage.setItem | ○ |
| C-08 | 32-bit/64-bit両版へのリンクあり | E-01 行14-26 | ○ |
| C-09 | Worker版へのリンクあり | E-01 行19-20 | ○ |
| C-10 | ESM版へのリンクあり | E-01 行21-26 | ○ |
| C-11 | 機能No.1 SQLiteライブラリ初期化が関連 | E-04 行49 | ○ |
| C-12 | 機能No.2 データベース接続管理が関連 | E-04 行50 | ○ |
| C-13 | 機能No.3 バージョン情報取得が関連 | E-04 行51 | ○ |
| C-14 | 機能No.6 SELECT文処理が関連 | E-04 行52 | ○ |
| C-15 | 機能No.7 INSERT文処理が関連 | E-04 行53 | ○ |
| C-16 | 機能No.28 組み込みSQL関数が関連 | E-04 行54 | ○ |
| C-17 | c-ppでES6モジュール版と通常版を生成 | E-02 行34-45 コメント | ○ |
| C-18 | assert/mustThrow/mustThrowMatchingがアサーション関数 | E-02 行193-238 | ○ |
| C-19 | tests-pass/tests-failクラスで色分け | E-02 行134-135 | ○ |
| C-20 | hasOpfs()でOPFSテスト有無を制御 | E-02 行69-75 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] tester1.c-pp.htmlがc-ppで正しく処理されるか確認
- [ ] 32-bit/64-bitの切り替えが実際に機能するか確認
- [ ] localStorageのキー名が他のページと競合しないか確認
