---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-Tester1（Worker版）画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/tester1-worker.c-pp.html` - メインHTMLテンプレート
- E-02: `ext/wasm/tester1.c-pp.js` - テストフレームワーク
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.13）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Workerスレッドで実行される | E-01 行71, E-02 行63, 122-130 | ○ |
| C-02 | ?esmパラメータでESMモード切替 | E-01 行57-67 urlParams.has('esm') | ○ |
| C-03 | ESM時は{type:"module"}で起動 | E-01 行63 | ○ |
| C-04 | ESM非対応警告を表示 | E-01 行61-62 | ○ |
| C-05 | 通常版はtester1.js?sqlite3.dir=jswasm | E-01 行69 | ○ |
| C-06 | log/error/test-resultメッセージタイプ | E-01 行73-89, E-02 行125-128, 139 | ○ |
| C-07 | test-resultでpass/failを判定 | E-01 行80-88 | ○ |
| C-08 | tests-pass/tests-failクラスで色分け | E-01 行81-82 | ○ |
| C-09 | titleプレフィックスを更新 | E-01 行84-87 | ○ |
| C-10 | チェックボックスでログ順序逆転 | E-01 行46-56 | ○ |
| C-11 | localStorageに設定保存 | E-01 行50 | ○ |
| C-12 | 各バリエーションへのリンクあり | E-01 行15-27 | ○ |
| C-13 | 機能No.1 SQLiteライブラリ初期化が関連 | E-04 行55 | ○ |
| C-14 | 機能No.2 データベース接続管理が関連 | E-04 行56 | ○ |
| C-15 | 機能No.42 ミューテックスが関連 | E-04 行57 | ○ |
| C-16 | Worker内でpostMessage使用 | E-02 行125-128 | ○ |
| C-17 | 未知メッセージタイプは"Unhandled message"出力 | E-01 行91 | ○ |
| C-18 | 32-bit/64-bit版は別ファイル | E-01 行59, 69 baseName変数 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ESMモジュールWorkerが主要ブラウザで動作するか確認
- [ ] Worker起動失敗時のエラーハンドリングが適切か確認
- [ ] 64-bit版ファイルが実際に存在するか確認
