---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-SQLTester画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/SQLTester/index.html` - メインHTMLファイル
- E-02: `ext/wasm/SQLTester/SQLTester.run.mjs` - テスト実行Workerスクリプト
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.18）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQLTesterテストスクリプトを実行 | E-01 行25-26 説明文 | ○ |
| C-02 | WorkerはES6モジュールとして起動 | E-01 行40-42 {type:'module'} | ○ |
| C-03 | 3秒タイムアウトで警告表示 | E-01 行100-104 setTimeout 3000ms | ○ |
| C-04 | is-ready受信でテスト自動実行 | E-01 行114-116 | ○ |
| C-05 | Run testsボタンで再実行可能 | E-01 行34, 行84-89 | ○ |
| C-06 | tests-endでボタン再有効化 | E-01 行109-112 removeAttribute | ○ |
| C-07 | metricsからnTestを除いて表示 | E-01 行110 delete payload.nTest | ○ |
| C-08 | stdout/tests-end/is-readyメッセージ処理 | E-01 行106-120 switch文 | ○ |
| C-09 | ログ逆順チェックボックスがデフォルトチェック | E-01 行31 checked属性 | ○ |
| C-10 | wPost関数でWorkerにメッセージ送信 | E-01 行43 | ○ |
| C-11 | test-list.mjsからテストスクリプト取得 | E-02 行16 import allTests | ○ |
| C-12 | SQLTesterクラスを使用 | E-02 行101-104 | ○ |
| C-13 | TestScriptクラスでスクリプト定義 | E-02 行37, 119 | ○ |
| C-14 | 機能No.1 SQLiteライブラリ初期化が関連 | E-04 行69 | ○ |
| C-15 | 機能No.5 SQLパーサー/トークナイザーが関連 | E-04 行70 | ○ |
| C-16 | 機能No.6 SELECT文処理が関連 | E-04 行71 | ○ |
| C-17 | 機能No.7 INSERT文処理が関連 | E-04 行72 | ○ |
| C-18 | sqt.runTests()でテスト実行 | E-02 行123 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] test-list.mjsが存在しテストスクリプトが正しく定義されているか確認
- [ ] SQLTester.mjsが存在しクラスが正しく動作するか確認
- [ ] テスト再実行（Run testsボタン）が正しく動作するか確認
