---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-モジュールシンボル一覧画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/module-symbols.html` - メインHTMLファイル（インラインスクリプト含む）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.19）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIシンボル一覧を動的生成 | E-01 行77-83 説明文, 行435-502 renderIt | ○ |
| C-02 | モジュールロードしてイントロスペクション | E-01 行80-82 "generated dynamically by loading" | ○ |
| C-03 | UIスレッドで実行 | E-01 行91-95 "runs in the main UI thread" | ○ |
| C-04 | Worker専用機能は非表示 | E-01 行91-95 注意事項 | ○ |
| C-05 | apiLinksで関数にドキュメントリンク付与 | E-01 行202-382 apiLinks定義 | ○ |
| C-06 | www:とwasm:プレフィックス変換 | E-01 行374-381 apiLinks.xform | ○ |
| C-07 | self.sqlite3にグローバル設定 | E-01 行436-437 | ○ |
| C-08 | SQLITE_定数をlist-constantsに表示 | E-01 行467-468, 478 | ○ |
| C-09 | sqlite3_関数をlist-functionsに表示 | E-01 行469-476, 479 | ○ |
| C-10 | func-wasmクラスでWASMバッジ | E-01 行61-70 CSS, 行413-416 | ○ |
| C-11 | scriptInfo/StructBinderを除外 | E-01 行446-450 excludeNamespace | ○ |
| C-12 | myModule.setStatusでロード進捗表示 | E-01 行517-536 | ○ |
| C-13 | compileOptionUsed()でコンパイルオプション取得 | E-01 行498-501 | ○ |
| C-14 | fossil-docタグでドキュメント切り出し | E-01 行16-22, 540 コメント | ○ |
| C-15 | 機能No.1 SQLiteライブラリ初期化が関連 | E-03 行73 | ○ |
| C-16 | 機能No.3 バージョン情報取得が関連 | E-03 行74 | ○ |
| C-17 | 機能No.4 スレッドセーフティが関連 | E-03 行75 | ○ |
| C-18 | sqlite3.wasm.pstackとptrの一覧表示 | E-01 行491-496 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] apiLinksのドキュメントURLが有効か確認
- [ ] Worker専用機能が正しく除外されているか確認
- [ ] 新しく追加された関数がapiLinksに含まれているか確認
