---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-WASM配布用インデックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/index-dist.html` 行1-116
- E-02: `ext/wasm/index.html` 行1-185（比較参照用）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行3
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行4

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは"sqlite3 WASM Demo Page Index" | E-01 行7 | ○ |
| C-02 | ヘッダーに"sqlite3 WASM demo pages"が表示される | E-01 行35 | ○ |
| C-03 | althttpd -enable-sab -page index.htmlで起動 | E-01 行40 | ○ |
| C-04 | HTTPサーバー経由でのアクセスが必要 | E-01 行44-46 | ○ |
| C-05 | OPFS関連ページはCOOP/COEPヘッダーが必要 | E-01 行47-60 | ○ |
| C-06 | Core testsとHigher-level appsのカテゴリ分け | E-01 行64-104 | ○ |
| C-07 | リンクのtarget属性が動的に設定される | E-01 行110-113 | ○ |
| C-08 | e.target = e.hrefでtarget設定 | E-01 行112 | ○ |
| C-09 | index.htmlとは異なるtarget設定方式 | E-01 行112, E-02 行181 | ○ |
| C-10 | 32-bit/64-bit版の切り替えリンクがない | E-01 行64-104 | ○ |
| C-11 | speedtest1関連のリンクがない | E-01 行64-104 | ○ |
| C-12 | 関連機能としてSQLiteライブラリ初期化がある | E-04 行4 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] index-dist.htmlの実際のリンク一覧と設計書の記載が一致しているか確認
- [ ] index.htmlとの差分が正しく記載されているか確認
- [ ] 配布版として適切なリンクのみが含まれているか確認
