---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：21-Lemon パーサージェネレータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **ドキュメント最終更新日**：2016年2月16日という日付はドキュメント内の記載に基づくが、ファイル自体の更新日は確認していない
  2. **parse.yファイルの存在**：SQLiteのSQL文法定義ファイルとして記載したが、実際のパス確認は未実施
  3. **外部URL有効性**：外部リンク（sqlite.org）の有効性は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `doc/lemon.html` - Lemonパーサージェネレータのドキュメントファイル（1,297行）
- E-02: `tool/lemon.c` - Lemonパーサージェネレータの実装ソースコード（6,075行）
- E-03: `tool/lempar.c` - パーサーテンプレートファイル
- E-04: `test/lemon-test01.y` - Lemonのテストケースファイル（80行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.21の定義）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行78）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LemonはLALR(1)パーサージェネレータである | E-01（行9） | ○ |
| C-02 | Lemonはyacc/bisonの代替として機能する | E-01（行10-11） | ○ |
| C-03 | 生成されるパーサーはリエントラントでスレッドセーフ | E-01（行15-16） | ○ |
| C-04 | ドキュメントパスは`doc/lemon.html` | E-05（行22、画面一覧） | ○ |
| C-05 | 関連機能はSQLパーサー/トークナイザー（機能No.5） | E-06（行78） | ○ |
| C-06 | セクション構成は7章構成（Introduction〜Copyright） | E-01（行28-54、目次） | ○ |
| C-07 | コマンドラインオプションは-b,-c,-d,-D,-E,-g,-l,-m,-p,-q,-r,-s,-T,-x | E-01（行132-169） | ○ |
| C-08 | パーサーインターフェースはParseAlloc, ParseFree, Parse, ParseTrace | E-01（行349-354） | ○ |
| C-09 | 特別ディレクティブは%code, %destructor等28種類 | E-01（行677-710） | ○ |
| C-10 | lemon.cは約6,075行のCソースコード | E-02（wc -l結果） | ○ |
| C-11 | lempar.cはテンプレートファイルとして%%マーカーを使用 | E-03（行26,30,93） | ○ |
| C-12 | struct symbolは文法記号の定義構造体 | E-02（行330-358） | ○ |
| C-13 | struct ruleは文法規則の定義構造体 | E-02（行359-392） | ○ |
| C-14 | struct configはパーサー状態の設定構造体 | E-02（行393以降） | ○ |
| C-15 | テストファイルlemon-test01.yは%token_prefix等を使用 | E-04（行10-30） | ○ |
| C-16 | Lemonの著作権はパブリックドメイン | E-01（行1288-1290） | ○ |
| C-17 | 外部リンク先にsqlite.orgが含まれる | E-01（行850,1276-1282） | ○ |
| C-18 | HTMLはシンプルなタグ構成でCSSを使用していない | E-01（全体構造確認） | ○ |
| C-19 | yaccとの違いとして「トークナイザがパーサーを呼ぶ」 | E-01（行374-376） | ○ |
| C-20 | Lemonはグローバル変数を使用しない | E-01（行376-377） | ○ |
| C-21 | 複数のパーサーを同時実行可能 | E-01（行378-379） | ○ |
| C-22 | Lemonのビルドは単一コマンド`cc -o lemon lemon.c`で可能 | E-01（行403-406） | ○ |
| C-23 | MemChunk構造体はメモリ管理に使用される | E-02（行65-70） | ○ |
| C-24 | ドキュメント最終更新は2016年2月16日 | E-01（行386）のテキスト記載 | ○ |
| C-25 | parse.yはSQLiteのSQL文法定義ファイル | **根拠なし**（推測） | △ |

## 4) 不足情報（Unknown / Missing）
- C-25「parse.yはSQLiteのSQL文法定義ファイル」について
  - lemon.html内にはSQLiteでLemonが使用されている旨の記載はあるが（行1273-1276）、parse.yファイルの具体的なパスは本ドキュメント調査範囲外
  - 候補：`src/parse.y` / `ext/fts5/fts5parse.y` / その他

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面種別・表示内容
  - 静的HTMLドキュメントであり、動的な処理やデータベース操作がないため、機能的なリスクは低い
- **0: 低リスク** - セキュリティ
  - 認証・認可が不要な公開ドキュメント
- **1: 中リスク** - 外部リンク
  - 外部サイト（sqlite.org）へのリンクが含まれる。リンク切れの可能性あり
- **0: 低リスク** - 著作権・ライセンス
  - パブリックドメインとして明示されている

## 6) レビュアーチェックリスト（最小）
- [ ] lemon.htmlファイルが実際に存在し、記載されたセクション構成と一致するか
- [ ] コマンドラインオプション一覧が最新のlemon.cの実装と一致するか
- [ ] 特別ディレクティブ一覧の網羅性を確認（漏れがないか）
- [ ] 外部リンク（sqlite.org）が有効か
- [ ] parse.yファイルの実際のパスを確認し、存在を検証
- [ ] lempar.cの%%マーカー位置が記載と一致するか
- [ ] 画面機能マッピングの機能No.5「SQLパーサー/トークナイザー」との関連が適切か
