---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-基本デモ（UIスレッド版）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/demo-123.html` 行1-24
- E-02: `ext/wasm/demo-123.js` 行1-291
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行4
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行5-12

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルは"Hello, sqlite3" | E-01 行7 | ○ |
| C-02 | h1要素に"1-2-sqlite3 demo"表示 | E-01 行20 | ○ |
| C-03 | jswasm/sqlite3.jsを読み込む | E-01 行21 | ○ |
| C-04 | demo-123.jsを読み込む | E-01 行22 | ○ |
| C-05 | globalThis.window===globalThisでUIスレッド判定 | E-02 行23 | ○ |
| C-06 | UIスレッド時はDOM要素を直接追加 | E-02 行25-30 | ○ |
| C-07 | Workerスレッド時はpostMessage使用 | E-02 行32-38 | ○ |
| C-08 | sqlite3InitModule()でWASM初期化 | E-02 行275 | ○ |
| C-09 | new oo.DB("/mydb.sqlite3",'ct')でDB作成 | E-02 行48 | ○ |
| C-10 | CREATE TABLE IF NOT EXISTS t(a,b)実行 | E-02 行60, 63 | ○ |
| C-11 | パラメータインデックスでバインド | E-02 行76-77 | ○ |
| C-12 | パラメータ名でバインド | E-02 行81-82 | ○ |
| C-13 | Prepared Statementでバインド/実行 | E-02 行87-104 | ○ |
| C-14 | rowMode 'array'でSELECT | E-02 行107-113 | ○ |
| C-15 | rowMode 'object'でSELECT | E-02 行115-122 | ○ |
| C-16 | db.createFunction()でUDF作成 | E-02 行161-166 | ○ |
| C-17 | UDFの引数不正時に例外発生 | E-02 行180-186 | ○ |
| C-18 | db.transaction()でトランザクション制御 | E-02 行188-201 | ○ |
| C-19 | db.savepoint()でセーブポイント制御 | E-02 行203-226 | ○ |
| C-20 | db.close()でDB切断 | E-02 行228 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] demo-123.jsの各処理ステップが設計書の記載と一致しているか確認
- [ ] UIスレッド/Workerスレッド判定ロジックの正確性を確認
- [ ] 画面機能マッピングとの整合性を確認
