---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-基本デモ（Worker版）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/demo-123-worker.html` 行1-44
- E-02: `ext/wasm/demo-123.js` 行1-291
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行5
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行13-16

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルは"Hello, sqlite3" | E-01 行7 | ○ |
| C-02 | h1要素に"1-2-sqlite3 worker demo"表示 | E-01 行20 | ○ |
| C-03 | new Worker("demo-123.js?sqlite3.dir=jswasm")でWorker作成 | E-01 行28-31 | ○ |
| C-04 | sqlite3.dir URLパラメータでWASMパス指定 | E-01 行29-31, E-02 行269-272 | ○ |
| C-05 | w.onmessageでWorkerメッセージ受信 | E-01 行33-40 | ○ |
| C-06 | data.type === 'log'でログメッセージ判定 | E-01 行34-36 | ○ |
| C-07 | logHtml()でDOM要素を追加 | E-01 行22-27 | ○ |
| C-08 | 未対応メッセージはerrorとして表示 | E-01 行37-39 | ○ |
| C-09 | Worker内でglobalThis.window !== globalThisで判定 | E-02 行31 | ○ |
| C-10 | Worker時はpostMessage()で親に通知 | E-02 行33-38 | ○ |
| C-11 | Worker時はimportScripts()でsqlite3.jsロード | E-02 行273 | ○ |
| C-12 | URLパラメータからsqlite3.dirを取得 | E-02 行269-272 | ○ |
| C-13 | メッセージ形式は{type, payload: {cssClass, args}} | E-02 行34-37 | ○ |
| C-14 | demo-123.jsはUIスレッドとWorker両対応 | E-02 行23, 31 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Worker起動パラメータ（sqlite3.dir）の正確性を確認
- [ ] メッセージハンドリングの網羅性を確認
- [ ] UIスレッド版との比較説明の正確性を確認
