---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-JSStorageデモ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/demo-jsstorage.html` 行1-49
- E-02: `ext/wasm/demo-jsstorage.js` 行1-115
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行6
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行17-21

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルバーに"sqlite3-kvvfs.js tests"表示 | E-01 行12 | ○ |
| C-02 | Clear logボタンが存在 | E-01 行30 | ○ |
| C-03 | Clear storageボタンが存在 | E-01 行31 | ○ |
| C-04 | (Re)init dbボタンが存在 | E-01 行32 | ○ |
| C-05 | Select db rowsボタンが存在 | E-01 行33 | ○ |
| C-06 | Approx. storage sizeボタンが存在 | E-01 行34 | ○ |
| C-07 | sqlite3InitModule()でWASM初期化 | E-02 行111 | ○ |
| C-08 | capi.sqlite3_vfs_find('kvvfs')でVFS確認 | E-02 行50 | ○ |
| C-09 | new oo.JsStorageDb(dbStorage)でDB作成 | E-02 行57 | ○ |
| C-10 | dbStorageはデフォルトで'local' | E-02 行55 | ○ |
| C-11 | Clear storageでdb.clearStorage()実行 | E-02 行61 | ○ |
| C-12 | (Re)init dbでDROP/CREATE/INSERT実行 | E-02 行70-77 | ○ |
| C-13 | performance.now()ベースの値をINSERT | E-02 行74-76 | ○ |
| C-14 | Select db rowsでSELECT * FROM t実行 | E-02 行89-93 | ○ |
| C-15 | rowMode: 0で結果取得 | E-02 行91 | ○ |
| C-16 | Approx. storage sizeでdb.storageSize()実行 | E-02 行99 | ○ |
| C-17 | kvvfs非対応時にエラー表示 | E-02 行51-52 | ○ |
| C-18 | 前回データ存在時のメッセージ表示 | E-02 行106-107 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] kvvfs VFSの存在確認ロジックの正確性を確認
- [ ] 各ボタンのイベントハンドラが正しく設定されているか確認
- [ ] localStorage/sessionStorageの切り替え方法を確認
