---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Worker1APIデモ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/demo-worker1.html` 行1-34
- E-02: `ext/wasm/demo-worker1.js` 行1-349
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行7
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行22-24

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルバーに"sqlite3-worker1.js tests"表示 | E-01 行13 | ○ |
| C-02 | 説明文"Most stuff on this page happens in the dev console."表示 | E-01 行28 | ○ |
| C-03 | new Worker("jswasm/sqlite3-worker1.js")でWorker作成 | E-02 行22 | ○ |
| C-04 | DbStateオブジェクトでDB ID管理 | E-02 行23-25 | ○ |
| C-05 | MsgHandlerQueueでコールバック管理 | E-02 行54-64 | ○ |
| C-06 | messageIdでリクエスト/レスポンス追跡 | E-02 行85, 96 | ○ |
| C-07 | 'worker1-ready'受信でrunTests()実行 | E-02 行322-327 | ○ |
| C-08 | 'open'メッセージでDB接続確立 | E-02 行288-299 | ○ |
| C-09 | filename:'testing2.sqlite3'でDB作成 | E-02 行289 | ○ |
| C-10 | 'exec'メッセージでSQL実行 | E-02 行155-167 | ○ |
| C-11 | CREATE TABLE t(a,b)実行 | E-02 行156-157 | ○ |
| C-12 | resultRows、columnNamesオプション使用 | E-02 行160-161 | ○ |
| C-13 | 'export'メッセージでDB取得 | E-02 行235-242 | ○ |
| C-14 | 'close'メッセージでDB切断 | E-02 行244-251 | ○ |
| C-15 | unlink:trueでファイル削除 | E-02 行244 | ○ |
| C-16 | SW.onerrorでエラーハンドリング | E-02 行39-41 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Worker1 APIのメッセージ形式が正しく記載されているか確認
- [ ] MsgHandlerQueueの動作原理を確認
- [ ] テストシーケンスの順序が正確か確認
