---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Worker1Promiserデモ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/demo-worker1-promiser.c-pp.html` 行1-42
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行8
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行25-26

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルバーに"worker-promise tests"表示 | E-01 行16 | ○ |
| C-02 | 説明文"Most stuff on this page happens in the dev console."表示 | E-01 行31 | ○ |
| C-03 | C preprocessorディレクティブ（#if/#endif）使用 | E-01 行9-13, 35-40 | ○ |
| C-04 | ESM版とconventional版の条件分岐あり | E-01 行9-13, 35-40 | ○ |
| C-05 | conventional版でsqlite3-worker1-promiser.js読み込み | E-01 行38 | ○ |
| C-06 | conventional版でdemo-worker1-promiser.js読み込み | E-01 行39 | ○ |
| C-07 | ESM版でdemo-worker1-promiser.mjs読み込み（type="module"） | E-01 行36 | ○ |
| C-08 | 初期化スピナーが存在 | E-01 行18-26 | ○ |
| C-09 | プログレスバーが存在 | E-01 行29 | ○ |
| C-10 | SqliteTestUtil.js読み込み | E-01 行34 | ○ |
| C-11 | Promiser APIでのモジュール初期化が主機能 | E-03 行25 | ○ |
| C-12 | Promise経由でのDB接続管理が主機能 | E-03 行26 | ○ |

## 4) 不足情報（Unknown / Missing）
- demo-worker1-promiser.jsの実装詳細（ファイルが存在しなかった）
  - 候補: demo-worker1-promiser.mjs / ビルド後生成ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な主張はソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] C preprocessorテンプレートのビルド結果を確認
- [ ] ESM版とconventional版の動作差分を確認
- [ ] Promiser APIの実際の使用例を確認
