---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-SQLite3Fiddle

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/fiddle/index.c-pp.html` 行1-405
- E-02: `ext/wasm/fiddle/fiddle.js` 行1-895
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行9
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行27-37

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトル"SQLite3 Fiddle" | E-01 行6, 233 | ○ |
| C-02 | "Powered by SQLite3"リンク表示 | E-01 行235-236 | ○ |
| C-03 | SQL入力テキストエリア存在 | E-01 行268-278 | ○ |
| C-04 | 出力テキストエリア（readonly）存在 | E-01 行289-290 | ○ |
| C-05 | Runボタン存在 | E-01 行263 | ○ |
| C-06 | Clear Inputボタン存在 | E-01 行264 | ○ |
| C-07 | Clear Outputボタン存在 | E-01 行282 | ○ |
| C-08 | Load DBボタン存在 | E-01 行356-358 | ○ |
| C-09 | Download DBボタン存在 | E-01 行360 | ○ |
| C-10 | Reset DBボタン存在 | E-01 行363 | ○ |
| C-11 | Examplesセレクト存在 | E-01 行266 | ○ |
| C-12 | Side-by-sideチェックボックス存在 | E-01 行369-376 | ○ |
| C-13 | Swap in/outチェックボックス存在 | E-01 行377-384 | ○ |
| C-14 | Auto-scroll outputチェックボックス存在 | E-01 行385-390 | ○ |
| C-15 | Auto-clear outputチェックボックス存在 | E-01 行391-395 | ○ |
| C-16 | About画面が存在 | E-01 行295-350 | ○ |
| C-17 | new Worker('fiddle-worker.js')でWorker作成 | E-02 行329 | ○ |
| C-18 | SF.wMsg()でWorkerにメッセージ送信 | E-02 行293-296 | ○ |
| C-19 | SF.addMsgHandler()でハンドラ登録 | E-02 行265-274 | ○ |
| C-20 | storageモジュールでlocalStorage/sessionStorage管理 | E-02 行22-191 | ○ |
| C-21 | ctrl-enter/shift-enterでSQL実行可能 | E-02 行584-590 | ○ |
| C-22 | FileReaderでDBインポート | E-02 行753-782 | ○ |
| C-23 | BlobとURL.createObjectURL()でDBエクスポート | E-02 行735-748 | ○ |
| C-24 | window.confirm()でDBリセット確認 | E-02 行302-304 | ○ |
| C-25 | URLパラメータ?sqlで初期SQL指定可能 | E-02 行890 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 全ボタンのイベントハンドラが正しく設定されているか確認
- [ ] Worker通信のメッセージ形式を確認
- [ ] 設定の永続化（localStorage）が正しく動作するか確認
- [ ] サンプルSQLの一覧が正確か確認
