---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Speedtest1（メインスレッド版）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ext/wasm/speedtest1.html` 行1-182
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行10
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行38-41

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトル"speedtest1.wasm" | E-01 行9, 12 | ○ |
| C-02 | Worker版へのリンク表示 | E-01 行13 | ○ |
| C-03 | UIブロック警告表示 | E-01 行28-29 | ○ |
| C-04 | Dev tools警告表示 | E-01 行31-34 | ○ |
| C-05 | 出力バッファリング説明表示 | E-01 行35-36 | ○ |
| C-06 | SqliteTestUtil.js読み込み | E-01 行38 | ○ |
| C-07 | jswasm/speedtest1.js読み込み | E-01 行39 | ○ |
| C-08 | wasmfsDir()でOPFSディレクトリ初期化 | E-01 行46-66 | ○ |
| C-09 | logListにログをバッファリング | E-01 行77-86 | ○ |
| C-10 | sqlite3InitModule()でWASM初期化 | E-01 行177-178 | ○ |
| C-11 | URLパラメータからflagsを取得 | E-01 行105-107 | ○ |
| C-12 | URLパラメータからvfsを取得 | E-01 行111-118 | ○ |
| C-13 | kvvfs使用時にsize=5を強制 | E-01 行120-128 | ○ |
| C-14 | kvvfs使用時にfilename='transient' | E-01 行125 | ○ |
| C-15 | --singlethread, --nomemstat, --big-transactionsフラグ追加 | E-01 行141-149 | ○ |
| C-16 | wasm.xCall('wasm_main', ...)でspeedtest1実行 | E-01 行161-162 | ○ |
| C-17 | setTimeout内で実行（50ms遅延） | E-01 行160 | ○ |
| C-18 | 不明なVFS指定時にエラー表示 | E-01 行114-116 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] URLパラメータの処理が正確か確認
- [ ] kvvfs使用時の特別処理が正しいか確認
- [ ] ログバッファリングと出力タイミングを確認
