---
generated_at: 2026-01-21 12:00:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 該当なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/notify.c` - sqlite3_unlock_notify APIの実装ファイル
- E-02: `src/sqlite.h.in` - 公開APIの定義とドキュメント（行9690-9801）
- E-03: `src/sqliteInt.h` - 内部構造体定義（行1788-1804、SQLITE_ENABLE_UNLOCK_NOTIFY関連）
- E-04: `test/notify1.test` - unlock_notify機能のテストファイル
- E-05: `src/test_thread.c` - unlock_notify使用例（行411-477）
- E-06: `src/tclsqlite.c` - Tcl拡張でのunlock_notify実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_unlock_notify：共有キャッシュモードでSQLITE_LOCKEDエラー発生時の通知機能 | E-01, E-02 | ○ |
| C-02 | SQLITE_ENABLE_UNLOCK_NOTIFYコンパイルオプションが必要 | E-01 (行19-20), E-03 (行1788) | ○ |
| C-03 | デッドロック検出機能あり | E-01 (行176-178), E-02 (行9756-9777) | ○ |
| C-04 | sqlite3ConnectionBlocked：ブロッキング接続情報を記録する内部関数 | E-01 (行201-208) | ○ |
| C-05 | sqlite3ConnectionUnlocked：トランザクション終了時にコールバック呼び出し | E-01 (行229-322) | ○ |
| C-06 | sqlite3ConnectionClosed：接続クローズ時のクリーンアップ | E-01 (行328-334) | ○ |
| C-07 | コールバックはsqlite3_step()またはsqlite3_close()から呼び出される | E-02 (行9708-9709) | ○ |
| C-08 | notify.cで通知機能が実装されている | E-01 (ファイル全体) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張はソースコードから直接確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての通知機能はソースコードに明確に実装されており、APIドキュメントも充実している。

## 6) レビュアーチェックリスト（最小）
- [ ] 通知一覧に記載された4つの通知機能がすべてnotify.cに存在することを確認
- [ ] SQLITE_ENABLE_UNLOCK_NOTIFYが必須条件であることを確認
- [ ] 内部関数（sqlite3ConnectionBlocked等）を公開APIと区別して認識
