---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-sqlite3_unlock_notify.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **レート制限**: 明示的な制限に関するドキュメントなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/notify.c` - unlock-notify機能のメイン実装ファイル（336行）
- E-02: `src/sqlite.h.in` - 公開APIドキュメント（9700-9801行目）
- E-03: `src/sqliteInt.h` - sqlite3構造体定義（1790-1803行目）、関数プロトタイプ（5788-5796行目）
- E-04: `src/btree.c` - sqlite3ConnectionBlocked()呼び出し（354, 371, 3648行目）
- E-05: `src/vdbeaux.c` - sqlite3ConnectionUnlocked()呼び出し（3504-3508行目）
- E-06: `src/main.c` - sqlite3ConnectionClosed()呼び出し（1409行目）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQLITE_ENABLE_UNLOCK_NOTIFYコンパイルオプションが必要 | E-01 (20行目: `#ifdef SQLITE_ENABLE_UNLOCK_NOTIFY`) | ○ |
| C-02 | 共有キャッシュモードでSQLITE_LOCKEDエラー発生時にコールバックを登録 | E-02 (9700-9705行目) | ○ |
| C-03 | デッドロック検出機能あり | E-01 (176-178行目), E-02 (9766-9777行目) | ○ |
| C-04 | コールバックはsqlite3_step()またはsqlite3_close()から呼び出される | E-02 (9708-9709行目) | ○ |
| C-05 | xNotify==NULLで既存コールバックがキャンセルされる | E-01 (161-166行目), E-02 (9725-9729行目) | ○ |
| C-06 | pBlockingConnection==0の場合、即座にコールバック呼び出し | E-01 (167-172行目), E-02 (9711-9715行目) | ○ |
| C-07 | 同一コールバック関数を持つ接続のコンテキストポインタは配列化 | E-01 (252-254行目), E-02 (9749-9754行目) | ○ |
| C-08 | コールバック内からsqlite3_xxx APIを呼ぶとクラッシュやデッドロック | E-02 (9731-9733行目) | ○ |
| C-09 | SQLITE_MUTEX_STATIC_MAINミューテックスで内部データ構造を保護 | E-01 (31-32, 113-114行目) | ○ |
| C-10 | sqlite3構造体にpBlockingConnection, pUnlockConnectionなどのメンバーがある | E-03 (1799-1803行目) | ○ |
| C-11 | sqlite3BlockedListがブロックされた接続のリンクリスト先頭 | E-01 (40行目) | ○ |
| C-12 | addToBlockedList()は同一xUnlockNotifyを持つエントリをグループ化 | E-01 (98-108行目) | ○ |
| C-13 | checkListProperties()はデバッグ用アサーション | E-01 (43-77行目) | ○ |
| C-14 | sqlite3ConnectionUnlocked()はトランザクション終了時に呼び出される | E-05 (3504-3508行目) | ○ |
| C-15 | sqlite3ConnectionBlocked()はbtree.cから呼び出される | E-04 (354, 371, 3648行目) | ○ |
| C-16 | sqlite3ConnectionClosed()はmain.cのsqlite3_close()から呼び出される | E-06 (1409行目) | ○ |
| C-17 | DROP TABLE/DROP INDEX時のSQLITE_LOCKEDは特殊ケース | E-02 (9781-9795行目) | ○ |
| C-18 | 拡張エラーコードSQLITE_LOCKED_SHAREDCACHEで区別可能 | E-02 (9792-9795行目) | ○ |
| C-19 | メモリ不足時は既存配列でコールバックを先に呼び出し | E-01 (269-296行目) | ○ |
| C-20 | aStatic配列は16要素の固定サイズ | E-01 (235行目: `void *aStatic[16]`) | ○ |
| C-21 | デッドロック検出は循環参照をチェック | E-01 (176行目), E-02 (9773-9777行目) | ○ |
| C-22 | コールバック関数のシグネチャはvoid(*)(void**, int) | E-02 (9798-9799行目), E-01 (150行目) | ○ |
| C-23 | 送信方式は同期 | E-01 (全体), E-02 (9708-9709行目) | ○ |
| C-24 | リトライ機能はなし | E-01 (全体) - リトライ処理なし | ○ |
| C-25 | レート制限なし | **根拠なし** - 明示的記載なし | △ |

## 4) 不足情報（Unknown / Missing）
- **レート制限に関する情報**: ソースコードおよびドキュメントにレート制限に関する明示的な記載がないため、「なし」と判断した
  - 候補：SQLiteドキュメント / テストケース / 追加コメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の説明はソースコードと一致
- 0: 低リスク - APIドキュメントと整合
- 1: 中リスク - レート制限の記載は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] コールバック呼び出しのタイミングがsqlite3_step()/sqlite3_close()で正しいか確認
- [ ] デッドロック検出ロジックの理解が正確か確認
- [ ] マルチスレッド環境での動作に関する記載が十分か確認
- [ ] DROP TABLE/DROP INDEX の特殊ケースの説明が十分か確認
