---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-sqlite3ConnectionBlocked.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/notify.c` - sqlite3ConnectionBlocked()実装（201-208行目）
- E-02: `src/sqliteInt.h` - sqlite3構造体定義（1790-1803行目）、関数プロトタイプ（5788-5795行目）
- E-03: `src/btree.c` - 呼び出し元コード（354, 371, 3648行目）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3ConnectionBlocked()はnotify.cで実装されている | E-01 (201-208行目) | ○ |
| C-02 | sqlite3_unlock_notify()の基盤機能である | E-01 (25-28行目のコメント) | ○ |
| C-03 | 関数シグネチャはvoid sqlite3ConnectionBlocked(sqlite3 *db, sqlite3 *pBlocker) | E-02 (5789行目) | ○ |
| C-04 | STATIC_MAINミューテックスを使用 | E-01 (202, 207行目のenterMutex/leaveMutex呼び出し) | ○ |
| C-05 | 初めてブロックされる場合のみリストに追加 | E-01 (203-205行目) | ○ |
| C-06 | pBlockingConnectionに引数pBlockerを設定 | E-01 (206行目) | ○ |
| C-07 | btree.c:354行目から呼び出される | E-03 (354行目) | ○ |
| C-08 | btree.c:371行目から呼び出される | E-03 (371行目) | ○ |
| C-09 | btree.c:3648行目から呼び出される | E-03 (3648行目) | ○ |
| C-10 | SQLITE_ENABLE_UNLOCK_NOTIFY未定義時は空マクロに展開 | E-02 (5793行目) | ○ |
| C-11 | pUnlockConnectionの状態を判定に使用 | E-01 (203行目) | ○ |
| C-12 | addToBlockedList()を呼び出す | E-01 (204行目) | ○ |
| C-13 | enterMutex()でミューテックス取得 | E-01 (202行目) | ○ |
| C-14 | leaveMutex()でミューテックス解放 | E-01 (207行目) | ○ |
| C-15 | 戻り値はvoid（エラーを返さない） | E-02 (5789行目) | ○ |
| C-16 | BTS_EXCLUSIVEフラグとの競合で呼び出される | E-03 (353-355行目) | ○ |
| C-17 | テーブルロック競合で呼び出される | E-03 (370-371行目) | ○ |
| C-18 | トランザクション開始時のブロックで呼び出される | E-03 (3647-3648行目) | ○ |
| C-19 | SQLITE_LOCKED_SHAREDCACHEエラーの前に呼び出される | E-03 (355, 3649行目) | ○ |
| C-20 | sqlite3BlockedListを更新する | E-01 (204行目のaddToBlockedList呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 関数の実装はソースコードで直接確認可能
- 0: 低リスク - 呼び出し元はgrepで網羅的に確認済み
- 0: 低リスク - データ構造はヘッダーファイルで定義確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] btree.c以外の呼び出し元がないか確認
- [ ] addToBlockedList()の条件判定ロジックが正確か確認
- [ ] ミューテックスの取得・解放が適切に行われているか確認
