---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-sqlite3ConnectionUnlocked.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/notify.c` - sqlite3ConnectionUnlocked()実装（229-322行目）
- E-02: `src/sqliteInt.h` - sqlite3構造体定義（1790-1803行目）、関数プロトタイプ（5790行目）
- E-03: `src/vdbeaux.c` - 呼び出し元コード（3504-3508行目）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3ConnectionUnlocked()はnotify.cで実装されている | E-01 (229-322行目) | ○ |
| C-02 | sqlite3_step()またはsqlite3_close()から呼び出される | E-03 (3507-3508行目), E-01 (329行目) | ○ |
| C-03 | 関数シグネチャはvoid sqlite3ConnectionUnlocked(sqlite3 *db) | E-02 (5790行目) | ○ |
| C-04 | aStatic[16]の固定配列を初期使用 | E-01 (235行目) | ○ |
| C-05 | 16要素を超える場合は動的メモリ割り当て | E-01 (260-268行目) | ○ |
| C-06 | メモリ不足時は既存配列でコールバックを先に呼び出し | E-01 (269-296行目のコメントと実装) | ○ |
| C-07 | pBlockingConnection==dbの場合はNULLにクリア | E-01 (245-247行目) | ○ |
| C-08 | pUnlockConnection==dbの場合はコールバック準備 | E-01 (250-305行目) | ○ |
| C-09 | 同一コールバック関数はコンテキストを配列化 | E-01 (300行目: `aArg[nArg++] = p->pUnlockArg`) | ○ |
| C-10 | 異なるコールバックへの切り替え時に先行呼び出し | E-01 (252-255行目) | ○ |
| C-11 | 両方NULLになったエントリはリストから削除 | E-01 (308-314行目) | ○ |
| C-12 | autoCommit==trueの場合に呼び出される | E-03 (3507行目) | ○ |
| C-13 | sqlite3ConnectionClosed()から内部的に呼び出される | E-01 (329行目) | ○ |
| C-14 | enterMutex()でSTATIC_MAINミューテックス取得 | E-01 (238行目) | ○ |
| C-15 | leaveMutex()でミューテックス解放 | E-01 (321行目) | ○ |
| C-16 | 戻り値はvoid | E-02 (5790行目) | ○ |
| C-17 | sqlite3BlockedListをスキャン | E-01 (241行目: `for(pp=&sqlite3BlockedList; *pp; )`) | ○ |
| C-18 | sqlite3BeginBenignMalloc()でメモリ割り当てを保護 | E-01 (257行目) | ○ |
| C-19 | sqlite3EndBenignMalloc()でメモリ保護を終了 | E-01 (298行目) | ○ |
| C-20 | pUnlockArg, xUnlockNotify, pUnlockConnectionをクリア | E-01 (302-304行目) | ○ |
| C-21 | 最終的にsqlite3_free(aDyn)でメモリ解放 | E-01 (320行目) | ○ |
| C-22 | コールバック関数シグネチャはvoid(*)(void**, int) | E-01 (230行目: `void (*xUnlockNotify)(void **, int) = 0`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 関数の実装はソースコードで直接確認可能
- 0: 低リスク - 呼び出し元はgrepで網羅的に確認済み
- 0: 低リスク - メモリ管理のロジックはコメント付きで明確

## 6) レビュアーチェックリスト（最小）
- [ ] メモリ不足時の分割コールバック呼び出しの影響が理解されているか確認
- [ ] リストスキャン中のエントリ削除ロジックが正確か確認
- [ ] 複数のコールバック関数がある場合の呼び出し順序が適切か確認
