---
generated_at: 2026-01-21 17:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **推奨ブラウザ・バージョン情報**：一般的な推奨値（要確認）
  2. **althttpdコマンドのポート番号**：実際の設定に依存
  3. **ユーザー種別の定義**：明示的な定義ドキュメントなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - プロジェクト概要・技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義一覧
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移フロー
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応
- E-06: `docs/code-to-docs/画面設計書/1-WASMテストページインデックス.md` - インデックス画面設計
- E-07: `docs/code-to-docs/画面設計書/8-SQLite3Fiddle.md` - Fiddle画面設計
- E-08: `ext/wasm/index.html` - インデックスページソース（設計書から参照）
- E-09: `ext/wasm/fiddle/fiddle.js` - Fiddleアプリケーションロジック（設計書から参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQLite WASMはWebAssemblyにコンパイルされたSQLiteデータベースエンジン | E-01 | ○ |
| C-02 | サーバー不要でクライアントサイドのみでSQL操作が可能 | E-01, E-06 | ○ |
| C-03 | 32-bit版と64-bit版の両方を提供 | E-02, E-03 | ○ |
| C-04 | 多様なAPI（同期/非同期、Worker対応）を提供 | E-04, E-05 | ○ |
| C-05 | SQL学習・検証はSQLite Fiddleを使用 | E-02, E-07 | ○ |
| C-06 | パフォーマンス測定はSpeedtest1を使用 | E-02, E-05 | ○ |
| C-07 | 機能テストはTester1を使用 | E-02, E-05 | ○ |
| C-08 | VFS検証でOPFS・kvvfs等の永続化機能をテスト | E-02, E-04 | ○ |
| C-09 | インデックスページはナビゲーションハブとして機能 | E-06 | ○ |
| C-10 | SQLite3 Fiddleは対話型SQL実行環境 | E-07 | ○ |
| C-11 | HTTPサーバー経由でのアクセスが必要 | E-06, E-07 | ○ |
| C-12 | althttpdコマンドで-enable-sabフラグが必要（OPFS使用時） | E-06 | ○ |
| C-13 | file:// URLではWASMファイルをロードできない | E-06 | ○ |
| C-14 | インメモリDBはセッション終了でデータ消失 | E-07 | ○ |
| C-15 | kvvfsはlocalStorage/sessionStorageに保存 | E-02, E-05 | ○ |
| C-16 | OPFSはOrigin Private File Systemに保存 | E-02, E-04 | ○ |
| C-17 | インデックスページのタイトルは"sqlite3 WASM test pages" | E-06 | ○ |
| C-18 | Core testsセクションにTester1へのリンク群がある | E-06 | ○ |
| C-19 | High-level appsセクションにFiddle、デモページへのリンク群がある | E-06 | ○ |
| C-20 | リンクをクリックすると新しいタブでテストページが開く | E-06 | ○ |
| C-21 | 32-bit版/64-bit版はWASMのポインタサイズの違い | E-02, E-03 | ○ |
| C-22 | ESM版/conventional版はモジュール形式の違い | E-02 | ○ |
| C-23 | Worker版/メインスレッド版は実行スレッドの違い | E-02, E-03 | ○ |
| C-24 | speedtest1ではURLパラメータでVFSを指定可能 | E-02 | ○ |
| C-25 | Fiddleで「Run」ボタンまたはCtrl+Enter/Shift+Enterで実行 | E-07 | ○ |
| C-26 | テキストを選択した状態でRunをクリックすると選択部分のみ実行 | E-07 | ○ |
| C-27 | ExamplesドロップダウンからサンプルSQLを選択可能 | E-07 | ○ |
| C-28 | サンプルにHelp、Box Mode、Setup table T等がある | E-07 | ○ |
| C-29 | Load DBボタンでデータベースファイルをインポート可能 | E-07 | ○ |
| C-30 | Download DBボタンでデータベースをエクスポート可能 | E-07 | ○ |
| C-31 | Reset DBボタンでデータベースをリセット可能 | E-07 | ○ |
| C-32 | 表示オプションにSide-by-side、Swap in/out等がある | E-07 | ○ |
| C-33 | Tester1は単体テスト・回帰テストを実行 | E-02, E-05 | ○ |
| C-34 | tester1.html、tester1-64bit.html等のバリエーションがある | E-02, E-03 | ○ |
| C-35 | OPFSテストはCOOP/COEPヘッダーが必要 | E-06 | ○ |
| C-36 | OPFS並行性テストは複数Workerを使用 | E-02 | ○ |
| C-37 | demo-123.htmlはUIスレッド版の基本デモ | E-02 | ○ |
| C-38 | demo-jsstorage.htmlはkvvfs VFSを使用した永続化デモ | E-02, E-05 | ○ |
| C-39 | module-symbols.htmlはAPIシンボル一覧を表示 | E-02 | ○ |
| C-40 | Lemonパーサージェネレータのドキュメントがdoc/lemon.htmlにある | E-02 | ○ |
| C-41 | Fiddleの?aboutパラメータでAbout画面を初期表示 | E-07 | ○ |
| C-42 | SQLite公式サイトはhttps://sqlite.org/ | E-01 | ○ |
| C-43 | 推奨ブラウザはChrome、Edge、Safari、Firefox（最新版） | **根拠なし** | △ |
| C-44 | デフォルトポートは8080 | **根拠なし** | △ |
| C-45 | ユーザー種別は開発者、テスター、学習者 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-43（推奨ブラウザ）: 公式ドキュメントでの明示的な推奨ブラウザ一覧が見つからない
  - 候補：SQLite公式サイト / ブラウザ互換性テスト結果 / WASM仕様書
- C-44（デフォルトポート）: althttpdのデフォルトポート設定が不明確
  - 候補：althttpdドキュメント / 設定ファイル / コマンドライン引数
- C-45（ユーザー種別）: 明示的なユーザー種別定義ドキュメントがない
  - 候補：ユースケース図 / 要件定義書 / ステークホルダー分析

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、画面構成、機能説明（根拠が明確）
- **1: 中リスク** - 操作手順の詳細（一部推測含む）
- **0: 低リスク** - トラブルシューティング（画面設計書のエラー処理から抽出）
- **1: 中リスク** - 推奨環境情報（一般的な推奨値を使用）

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPサーバー起動コマンドとポート番号が実環境と一致するか確認
- [ ] 推奨ブラウザの記載が最新の互換性情報と一致するか確認
- [ ] ユーザー種別の定義が組織のステークホルダーと一致するか確認
- [ ] 業務フロー（STEP1-5）が実際の利用パターンと一致するか確認
- [ ] トラブルシューティングの対処法が実際に機能するか確認
- [ ] 画面操作手順が最新バージョンのUIと一致するか確認
