# SQLite WASM 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】ツール選択機能（インデックスページ）](#4-step1ツール選択機能インデックスページ)
5. [【STEP2-3】SQL実行機能（SQLite3 Fiddle）](#5-step2-3sql実行機能sqlite3-fiddle)
6. [【STEP3-4】テスト・ベンチマーク機能](#6-step3-4テストベンチマーク機能)
7. [【STEP4-5】結果確認・データ管理機能](#7-step4-5結果確認データ管理機能)

**【サポート機能】**
8. [デモ機能](#8-デモ機能)
9. [開発者向けツール](#9-開発者向けツール)
10. [ドキュメント機能](#10-ドキュメント機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 SQLite WASMとは

SQLite WASMは、SQLiteデータベースエンジンをWebAssembly（WASM）にコンパイルしたもので、Webブラウザ上でSQLiteを直接実行できるツールキットです。サーバー不要でクライアントサイドのみでSQL操作が可能なため、開発者やデータベース学習者に最適な環境を提供します。

**主な特徴：**
- サーバー不要でブラウザのみでSQL実行可能
- 永続化オプション（OPFS、localStorage等）をサポート
- 32-bit版と64-bit版の両方を提供
- 多様なAPI（同期/非同期、Worker対応）

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **SQL学習・検証** | SQLite Fiddleを使用したSQL文の対話的な実行・学習 |
| **パフォーマンス測定** | Speedtest1によるベンチマーク実行・性能評価 |
| **機能テスト** | Tester1による単体テスト・回帰テスト実行 |
| **API検証** | デモページを使用したWASM APIの動作確認 |
| **VFS検証** | OPFS・kvvfs等の永続化機能テスト |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        業務フロー                                │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】インデックスページでツール・テストを選択              │
│      ↓                                                          │
│  【STEP 2】SQLite Fiddleやデモで基本操作を実行                   │
│      ↓                                                          │
│  【STEP 3】テストやベンチマークを実行                            │
│      ↓                                                          │
│  【STEP 4】実行結果を確認・分析                                  │
│      ↓                                                          │
│  【STEP 5】データベースの保存・エクスポート                      │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | APIテスト、パフォーマンス検証、VFS動作確認、デバッグ |
| **テスター** | 単体テスト実行、回帰テスト実行、並行性テスト |
| **学習者** | SQL学習、Fiddleでの練習、サンプルコード実行 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| インデックスページ | テストページ一覧とナビゲーション | STEP 1 |
| SQLite3 Fiddle | 対話型SQL実行環境 | STEP 2-3 |
| Speedtest1 | パフォーマンスベンチマーク | STEP 3 |
| Tester1 | APIテストスイート | STEP 3 |
| デモページ | 基本機能のデモ | STEP 2 |
| OPFS テスト | 永続化機能テスト | STEP 3-4 |
| モジュールシンボル一覧 | API一覧表示 | 随時参照 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 開発者 | SQLite WASMの機能開発・検証を行うユーザー |
| テスター | テストスイートを実行し動作検証を行うユーザー |
| 学習者 | SQLやSQLite WASMの学習目的でFiddle等を使用するユーザー |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

**注意事項：**
- OPFS機能を使用する場合、COOP/COEPヘッダー対応のブラウザが必要
- SharedArrayBufferとAtomics APIのサポートが必要な機能あり

---

## 2. ログイン・ログアウト手順

### 2.1 アクセス方法

SQLite WASMは認証不要のシステムです。HTTPサーバー経由でアクセスします。

**アクセス手順：**

1. ターミナルを開き、プロジェクトディレクトリに移動します
2. HTTPサーバーを起動します

```bash
# 推奨コマンド（OPFS機能を使用する場合）
althttpd -enable-sab -page index.html

# または任意のHTTPサーバー
python -m http.server 8000
```

3. ブラウザで以下のURLにアクセスします
   - `http://localhost:8080/ext/wasm/index.html`

### 2.2 HTTPサーバー起動について

**重要な注意事項：**
- `file://` URLではWASMファイルをロードできません
- 必ずHTTPサーバー経由でアクセスしてください
- OPFS関連機能を使用する場合は `-enable-sab` フラグが必要です

### 2.3 セッション終了

ブラウザタブを閉じるとセッションが終了します。

**データの永続化について：**
- インメモリDB（デフォルト）: セッション終了でデータ消失
- localStorage/sessionStorage（kvvfs）: ブラウザに保存
- OPFS: ブラウザのOrigin Private File Systemに保存

---

## 3. トップページ（TOP画面）

### 3.1 インデックスページ概要

インデックスページ（index.html）は、SQLite WASMプロジェクトのナビゲーションハブです。

**画面構成：**

| 項目 | 説明 |
|------|------|
| タイトルバー | "sqlite3 WASM test pages" |
| 使用方法説明 | サーバー起動コマンドの説明 |
| Core tests | Tester1へのリンク群（32/64-bit、ESM版など） |
| High-level apps | Fiddle、デモページへのリンク群 |
| speedtest1 | ベンチマークツールへのリンク群 |
| Misc | OPFSテスト、シンボル一覧へのリンク群 |

### 3.2 リンクの操作

各リンクをクリックすると、新しいタブでテストページが開きます。

**操作方法：**
1. 目的のテストページを探します
2. リンクをクリックします
3. 新しいタブでページが開きます

**リンクの種類：**
- 32-bit版 / 64-bit版: WASMのポインタサイズ
- ESM版 / conventional版: モジュール形式
- Worker版 / メインスレッド版: 実行スレッド

---

## 4. 【STEP1】ツール選択機能（インデックスページ）

> **業務フローでの位置**: ユーザーが目的に応じたツール・テストページを選択するステップです。

### 4.1 テストページの選択

**操作手順：**

1. インデックスページ（index.html）にアクセスします
2. 目的に応じてセクションを探します：
   - SQL学習・実行 → 「High-level apps」セクションの「fiddle」
   - パフォーマンス測定 → 「speedtest1」セクション
   - APIテスト → 「Core tests」セクション
3. 適切なバージョンを選択します
   - 通常は32-bit版を使用
   - 大規模データを扱う場合は64-bit版

### 4.2 バージョン選択の目安

| 用途 | 推奨バージョン |
|------|---------------|
| 一般的なSQL学習 | 32-bit、メインスレッド版 |
| 長時間処理 | Worker版（UIがブロックされない） |
| ESMモジュール開発 | ESM版 |
| OPFS永続化検証 | Worker版 + OPFS VFS |

### 4.3 VFS（Virtual File System）選択

speedtest1では、URLパラメータでVFSを指定できます：

| VFS | 説明 | URLパラメータ例 |
|-----|------|----------------|
| memdb | インメモリ（デフォルト） | なし |
| kvvfs | localStorage/sessionStorage | `?vfs=kvvfs` |
| opfs | Origin Private File System | `?vfs=opfs` |
| opfs-sahpool | OPFS SAHPool | `?vfs=opfs-sahpool` |

---

## 5. 【STEP2-3】SQL実行機能（SQLite3 Fiddle）

> **業務フローでの位置**: ユーザーがSQLを対話的に実行し、結果を確認するステップです。

### 5.1 SQLite3 Fiddleへのアクセス

**操作手順：**

1. インデックスページで「fiddle」リンクをクリックします
2. SQLite3 Fiddleページが新しいタブで開きます
3. 初期化中はスピナーが表示されます
4. 初期化完了後、SQL入力が可能になります

### 5.2 SQL入力と実行

**基本的な操作手順：**

1. 上部のテキストエリアにSQL文を入力します
2. 「Run」ボタンをクリックするか、Ctrl+EnterまたはShift+Enterを押します
3. 下部の出力エリアに実行結果が表示されます

**入力例：**
```sql
-- テーブル作成
CREATE TABLE users (id INTEGER PRIMARY KEY, name TEXT);

-- データ挿入
INSERT INTO users VALUES (1, 'Alice'), (2, 'Bob');

-- データ取得
SELECT * FROM users;
```

### 5.3 部分実行

テキストを選択した状態で「Run」をクリックすると、選択部分のみが実行されます。

**操作手順：**

1. 実行したいSQL文をマウスで選択します
2. 「Run」ボタンをクリックします
3. 選択した部分のみが実行されます

### 5.4 サンプルSQLの使用

**操作手順：**

1. 「Examples」ドロップダウンから例を選択します
2. 入力エリアにサンプルコードが表示されます
3. 自動的に実行されます

**利用可能なサンプル：**
- Help: ヘルプコマンド（.help）
- Box Mode: 表形式出力（.mode box）
- Setup table T: テーブル作成サンプル
- sqlite_schema: スキーマ情報表示
- Mandelbrot: 再帰CTEによるフラクタル生成
- JSON pretty-print: JSON整形

### 5.5 データベースのインポート

**操作手順：**

1. 「Load DB」ボタンをクリックします
2. ファイル選択ダイアログが表示されます
3. SQLiteデータベースファイル（.db、.sqlite等）を選択します
4. データベースが読み込まれ、操作可能になります

### 5.6 データベースのエクスポート

**操作手順：**

1. 「Download DB」ボタンをクリックします
2. 現在のデータベースがファイルとしてダウンロードされます
3. ファイル名は自動的に付与されます

### 5.7 データベースのリセット

**操作手順：**

1. 「Reset DB」ボタンをクリックします
2. 確認ダイアログが表示されます
3. 「OK」をクリックするとデータベースが初期化されます

**注意事項：**
- リセットすると全てのテーブルとデータが削除されます
- エクスポートしていないデータは失われます

### 5.8 表示オプション

| オプション | 説明 |
|----------|------|
| Side-by-side | 入出力エリアを横並びに表示 |
| Swap in/out | 入力と出力の位置を入れ替え |
| Auto-scroll output | 出力エリアを自動スクロール |
| Auto-clear output | 実行前に出力をクリア |

---

## 6. 【STEP3-4】テスト・ベンチマーク機能

> **業務フローでの位置**: 開発者・テスターがAPIテストやパフォーマンス測定を実行するステップです。

### 6.1 Tester1（APIテスト）

Tester1は、SQLite WASM APIの単体テスト・回帰テストを実行します。

**操作手順：**

1. インデックスページで「tester1」リンクをクリックします
2. テストページが開き、自動的にテストが開始されます
3. 進行状況がコンソールまたは画面に表示されます
4. テスト完了後、結果サマリーが表示されます

**テストバリエーション：**
- tester1.html: 32-bit版、メインスレッド
- tester1-64bit.html: 64-bit版、メインスレッド
- tester1-esm.html: ESMモジュール版
- tester1-worker.html: Workerスレッド版

### 6.2 Speedtest1（ベンチマーク）

Speedtest1は、SQLiteのパフォーマンスベンチマークを実行します。

**操作手順：**

1. インデックスページで「speedtest1」または「speedtest1-worker」リンクをクリックします
2. ベンチマークページが開きます
3. Worker版の場合、オプションを選択できます
4. 「Run」ボタンをクリックしてベンチマークを開始します
5. 結果が画面に表示されます

**オプション（Worker版）：**

| オプション | 説明 |
|----------|------|
| VFS選択 | memdb、kvvfs、opfs、opfs-sahpoolから選択 |
| サイズ設定 | テストデータのサイズ |
| スレッドモード | --singlethread、--multithread、--serialized |

### 6.3 OPFSテスト

OPFSテストは、Origin Private File Systemを使用した永続化機能をテストします。

**操作手順：**

1. インデックスページで「test-opfs-vfs」リンクをクリックします
2. OPFSテストページが開きます
3. テストが自動的に実行されます
4. 結果がコンソールに表示されます

**注意事項：**
- COOP/COEPヘッダーが必要です（`-enable-sab`フラグ使用）
- SharedArrayBuffer対応ブラウザが必要です

### 6.4 OPFS並行性テスト

複数Workerを使用した並行アクセステストを実行します。

**操作手順：**

1. インデックスページで「tests/opfs/concurrency/」リンクをクリックします
2. パラメータを設定します：
   - workers: Worker数
   - interval: 実行間隔
   - iterations: 繰り返し回数
3. テストを開始します
4. 結果が表示されます

---

## 7. 【STEP4-5】結果確認・データ管理機能

> **業務フローでの位置**: テスト結果を確認し、データベースを保存・管理するステップです。

### 7.1 テスト結果の確認

**Tester1の結果確認：**
- 画面またはブラウザのコンソール（F12キーで開く）で確認
- PASSした項目とFAILした項目が表示されます
- エラーがある場合はエラーメッセージを確認

**Speedtest1の結果確認：**
- 各テスト項目の実行時間が表示されます
- 合計時間とスコアが表示されます
- 異なるVFSや設定での結果を比較可能

### 7.2 結果のエクスポート

**コンソールログのコピー：**

1. ブラウザの開発者ツールを開きます（F12キー）
2. 「Console」タブを選択します
3. ログを選択してコピーします

**データベースのエクスポート（Fiddle）：**

1. 「Download DB」ボタンをクリックします
2. データベースファイルがダウンロードされます

### 7.3 データの永続化

**kvvfs（localStorage/sessionStorage）：**
- demo-jsstorage.htmlでテスト可能
- ブラウザを閉じてもデータが保持されます
- ストレージ容量に制限があります

**OPFS（Origin Private File System）：**
- test-opfs-vfs.htmlでテスト可能
- より大きなデータを永続化できます
- ブラウザごとのサポート状況を確認

---

## 8. デモ機能

### 8.1 基本デモ（UIスレッド版）

**アクセス方法：** demo-123.html

**機能：**
- sqlite3のUIスレッドでの基本動作デモ
- データベース作成、テーブル操作、クエリ実行

**操作手順：**

1. インデックスページで「demo-123」リンクをクリックします
2. ページが開くと自動的にデモが実行されます
3. 結果がページ内に表示されます

### 8.2 基本デモ（Worker版）

**アクセス方法：** demo-123-worker.html

**機能：**
- sqlite3のWorkerスレッドでの基本動作デモ
- UIをブロックしない非同期実行

### 8.3 JS Storageデモ

**アクセス方法：** demo-jsstorage.html

**機能：**
- kvvfs VFSを使用した永続化デモ
- localStorage/sessionStorageへのデータ保存

**操作手順：**

1. インデックスページで「demo-jsstorage」リンクをクリックします
2. デモが実行され、データがlocalStorageに保存されます
3. ブラウザを閉じて再度開くと、データが保持されています

### 8.4 Worker1 APIデモ

**アクセス方法：** demo-worker1.html

**機能：**
- Worker1 APIの動作デモ
- 開発者コンソールで出力を確認

### 8.5 Worker1 Promiserデモ

**アクセス方法：** demo-worker1-promiser.html

**機能：**
- Promise形式のWorker1 APIデモ
- 非同期処理の書き方を確認

---

## 9. 開発者向けツール

### 9.1 モジュールシンボル一覧

**アクセス方法：** module-symbols.html

**機能：**
- sqlite3.wasmが公開するAPIシンボルの一覧表示
- namespace、関数、定数の確認

**操作手順：**

1. インデックスページで「module-symbols」リンクをクリックします
2. シンボル一覧が表示されます
3. 検索やフィルタリングでAPIを探せます

### 9.2 WASMFS Scratchpad

**アクセス方法：** scratchpad-wasmfs.html

**機能：**
- WASMFS/OPFS統合の実験・スクラッチパッド
- 開発者コンソールで出力を確認

### 9.3 SQLTester

**アクセス方法：** SQLTester/index.html

**機能：**
- 外部テストスクリプトの実行
- SQLTesterフォーマットのテストを実行

**注意事項：**
- 外部テストスクリプトファイルが必要です

---

## 10. ドキュメント機能

### 10.1 Lemonパーサージェネレータ

**アクセス方法：** doc/lemon.html

**機能：**
- SQLiteで使用されるLemonパーサージェネレータのドキュメント
- パーサー生成の仕組みを理解するためのリファレンス

### 10.2 About画面（Fiddle内）

**アクセス方法：** Fiddle画面内の「About」ボタン、またはURLに`?about`を付加

**機能：**
- SQLite3 Fiddleアプリケーションの説明
- 使用方法のヘルプ

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】インデックスページでツール・テストを選択 → 4章参照
    ↓
【STEP 2】SQLite Fiddleやデモで基本操作を実行 → 5章、8章参照
    ↓
【STEP 3】テストやベンチマークを実行 → 6章参照
    ↓
【STEP 4】実行結果を確認・分析 → 7章参照
    ↓
【STEP 5】データベースの保存・エクスポート → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【開発者】STEP1-3: APIの動作確認

新機能の開発やバグ修正時に、APIの動作を確認します。

**操作手順：**

1. HTTPサーバーを起動します
   ```bash
   althttpd -enable-sab -page index.html
   ```
2. ブラウザでindex.htmlにアクセスします
3. 目的のテストページ（tester1等）を選択します
4. テスト結果を確認します
5. 必要に応じてSpeedtest1でパフォーマンスを確認します

### 11.2 【テスター】STEP1-4: 回帰テストの実行

リリース前やコード変更後に回帰テストを実行します。

**操作手順：**

1. HTTPサーバーを起動します
2. tester1.htmlにアクセスしてテストを実行します
3. 32-bit版、64-bit版、Worker版等、全バリエーションをテストします
4. OPFS関連テストを実行します
5. テスト結果を記録します

### 11.3 【学習者】STEP1-5: SQLの学習

SQLite Fiddleを使用してSQLを学習します。

**操作手順：**

1. HTTPサーバーを起動します
2. fiddle/index.htmlにアクセスします
3. Examplesからサンプルを選んで実行します
4. 自分でSQLを入力して試します
5. 作成したデータベースをエクスポートして保存します

---

## 12. よくある質問と対処法

### 12.1 アクセスに関するQ&A

**Q: ページが表示されません**

A: 以下を確認してください：
- HTTPサーバーが起動しているか確認
- URLが正しいか確認（file://ではなくhttp://）
- ポート番号が正しいか確認

**Q: WASMがロードできません**

A: 以下を確認してください：
- HTTPサーバー経由でアクセスしているか
- ブラウザがWASMをサポートしているか
- ブラウザのコンソールでエラーを確認

### 12.2 SQL実行に関するQ&A

**Q: SQLがエラーになります**

A: 以下を確認してください：
- SQL構文が正しいか
- テーブル名やカラム名が存在するか
- セミコロンで文が終わっているか

**Q: 日本語が文字化けします**

A: SQLiteはUTF-8を使用しています。
- ブラウザの文字エンコーディングがUTF-8か確認
- データベースファイルのエンコーディングを確認

### 12.3 データ保存に関するQ&A

**Q: データが消えてしまいます**

A: デフォルトはインメモリデータベースです。
- kvvfs VFSを使用するとlocalStorageに保存されます
- OPFS VFSを使用するとより安全に保存されます
- 「Download DB」でファイルにエクスポートできます

**Q: インポートしたデータベースが開けません**

A: 以下を確認してください：
- ファイルが有効なSQLiteデータベースファイルか
- ファイルサイズが大きすぎないか
- 64-bit版が必要な場合があります

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| WASMロード失敗 | HTTPサーバー未起動またはパスエラー | HTTPサーバーを起動し、正しいURLでアクセス |
| OPFS not available | ブラウザ未対応またはヘッダー不足 | `-enable-sab`フラグでサーバー起動 |
| SharedArrayBuffer not defined | COOP/COEPヘッダー不足 | 対応HTTPサーバーを使用 |
| SQL syntax error | SQL構文エラー | SQL文を確認して修正 |
| Export failed | データベースが空または破損 | データベースの状態を確認 |
| Loading failed | ファイル形式エラー | 有効なSQLiteファイルを使用 |

### 13.2 よくあるトラブルと解決方法

**トラブル: ページが真っ白になる**

解決方法：
1. ブラウザの開発者ツールを開きます（F12）
2. Consoleタブでエラーを確認します
3. Networkタブでファイルの読み込み状況を確認します
4. エラーメッセージに従って対処します

**トラブル: テストが途中で止まる**

解決方法：
1. Worker版を使用している場合、メインスレッド版を試します
2. ブラウザのキャッシュをクリアします
3. 別のブラウザで試します
4. メモリ使用量を確認します

**トラブル: ベンチマーク結果が不安定**

解決方法：
1. 他のタブやアプリケーションを閉じます
2. ブラウザを再起動します
3. 複数回実行して平均を取ります
4. Worker版を使用します

### 13.3 サポートへの連絡方法

**SQLite公式リソース：**
- 公式サイト: https://sqlite.org/
- フォーラム: https://sqlite.org/forum
- ソースリポジトリ: https://sqlite.org/src/timeline

**問題報告時に含める情報：**
- ブラウザ名とバージョン
- OS名とバージョン
- エラーメッセージ（コンソールログ）
- 再現手順
- 使用しているテストページ

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-21 | 初版作成 |

---

*本マニュアルは、SQLite WASMのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
