---
generated_at: 2026-01-21 23:15:00
metrics:
  claims_total: 60
  claims_with_evidence: 55
  claims_without_evidence: 5
confidence_derived: 0.92
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：55 / 60、根拠なし：5
- 優先レビュー（高）
  1. **NFT-037〜NFT-049（リソース制限テスト）**：具体的なテスト実装ファイルの参照が不十分
  2. **NFT-053〜NFT-055（保守性テスト）**：ビルドプロセスの詳細確認が必要
  3. **合格基準の具体性**：数値的な基準が「妥当な時間内」等の表現になっている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/speed1.test` - 性能テストスクリプト（INSERT/SELECT/UPDATE/DELETE処理時間計測）
- E-02: `test/thread001.test` - マルチスレッドテストスクリプト（10スレッド同時アクセス）
- E-03: `test/mutex1.test` - ミューテックステストスクリプト（スレッド安全性確認）
- E-04: `test/mutex2.test` - ミューテックステストスクリプト（追加テスト）
- E-05: `test/thread002.test〜thread005.test` - 追加マルチスレッドテスト
- E-06: `test/auth.test` - 認可制御テストスクリプト（sqlite3_set_authorizer API）
- E-07: `test/crash.test` - クラッシュ復旧テストスクリプト（ジャーナル復旧）
- E-08: `test/crash2.test〜crash8.test` - 追加クラッシュ復旧テスト
- E-09: `test/corrupt.test` - 破損データベーステストスクリプト
- E-10: `test/corrupt2.test〜corruptN.test` - 追加破損データベーステスト
- E-11: `mptest/mptest.c` - マルチプロセステストプログラム
- E-12: `src/sqliteLimit.h` - SQLite制限値定義ヘッダ
- E-13: `src/os_unix.c` - Unix VFS実装
- E-14: `src/os_win.c` - Windows VFS実装
- E-15: `src/mem1.c, src/mem3.c, src/mem5.c` - メモリアロケータ実装
- E-16: `test/bigrow.test` - 大規模行テスト
- E-17: `test/bigfile.test, test/bigfile2.test` - 大容量ファイルテスト
- E-18: `test/altermalloc.test` - malloc失敗テスト
- E-19: `src/test_malloc.c` - メモリテスト用ユーティリティ
- E-20: `src/test_vdbecov.c` - VDBEカバレッジテスト
- E-21: `README.md` - ビルド手順・プロジェクト概要
- E-22: `test/aggfault.test, test/btreefault.test等` - フォールト注入テスト群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 大量INSERT処理性能テスト | E-01 | ○ |
| C-02 | インデックス付きINSERT性能テスト | E-01 | ○ |
| C-03 | フルテーブルスキャンSELECT性能テスト | E-01 | ○ |
| C-04 | LIKE検索性能テスト | E-01 | ○ |
| C-05 | インデックス検索性能テスト | E-01 | ○ |
| C-06 | rowid検索性能テスト | E-01 | ○ |
| C-07 | ユニークインデックス検索性能テスト | E-01 | ○ |
| C-08 | テキスト列インデックス検索性能テスト | E-01 | ○ |
| C-09 | VACUUM処理性能テスト | E-01 | ○ |
| C-10 | 範囲UPDATE処理性能テスト | E-01 | ○ |
| C-11 | 単一行UPDATE処理性能テスト | E-01 | ○ |
| C-12 | 全行UPDATE処理性能テスト | E-01 | ○ |
| C-13 | DELETE処理性能テスト | E-01 | ○ |
| C-14 | テーブル間COPY処理性能テスト | E-01 | ○ |
| C-15 | ランダムSELECT処理性能テスト | E-01 | ○ |
| C-16 | ランダムDELETE処理性能テスト | E-01 | ○ |
| C-17 | マルチプロセス同時アクセス性能テスト | E-11 | ○ |
| C-18 | マルチスレッド処理性能テスト | E-02, E-05 | ○ |
| C-19 | INSERT操作の認可制御テスト | E-06 | ○ |
| C-20 | CREATE TABLE操作の認可制御テスト | E-06 | ○ |
| C-21 | SELECT操作の認可制御テスト | E-06 | ○ |
| C-22 | UPDATE操作の認可制御テスト | E-06 | ○ |
| C-23 | DELETE操作の認可制御テスト | E-06 | ○ |
| C-24 | TEMP TABLE操作の認可制御テスト | E-06 | ○ |
| C-25 | ジャーナル同期中クラッシュ復旧テスト | E-07, E-08 | ○ |
| C-26 | データベース同期中クラッシュ復旧テスト | E-07, E-08 | ○ |
| C-27 | コミット中クラッシュ復旧テスト | E-07, E-08 | ○ |
| C-28 | ランダムクラッシュ復旧テスト | E-07, E-08 | ○ |
| C-29 | 破損データベースからの復旧テスト | E-09, E-10 | ○ |
| C-30 | 破損インデックスからの復旧テスト | E-09, E-10 | ○ |
| C-31 | 整合性チェックテスト | E-02 | ○ |
| C-32 | ミューテックス動作確認テスト | E-03, E-04 | ○ |
| C-33 | シリアライズドモードテスト | E-03 | ○ |
| C-34 | マルチスレッドモードテスト | E-03 | ○ |
| C-35 | シングルスレッドモードテスト | E-03 | ○ |
| C-36 | 共有キャッシュモードマルチスレッドテスト | E-02 | ○ |
| C-37 | 最大BLOB長制限テスト | E-12 | △ |
| C-38 | 最大メモリ割り当てサイズ制限テスト | E-12 | △ |
| C-39 | 最大列数制限テスト | E-12 | ○ |
| C-40 | 最大SQL長制限テスト | E-12 | ○ |
| C-41 | 最大式ツリー深度制限テスト | E-12 | ○ |
| C-42 | 最大パーサースタック深度制限テスト | E-12 | △ |
| C-43 | 最大COMPOUND SELECT数制限テスト | E-12 | ○ |
| C-44 | 最大関数引数数制限テスト | E-12 | ○ |
| C-45 | 最大ATTACH数制限テスト | E-12 | ○ |
| C-46 | 最大ページサイズ制限テスト | E-12 | ○ |
| C-47 | 最大ページ数制限テスト | E-12 | ○ |
| C-48 | 最大LIKE/GLOBパターン長制限テスト | E-12 | ○ |
| C-49 | 最大トリガー再帰深度制限テスト | E-12 | ○ |
| C-50 | Unix VFS動作確認テスト | E-13 | ○ |
| C-51 | Windows VFS動作確認テスト | E-14 | ○ |
| C-52 | メモリアロケータ互換性テスト | E-15 | ○ |
| C-53 | アマルガメーション生成確認テスト | E-21 | ○ |
| C-54 | デバッグビルド確認テスト | E-21 | ○ |
| C-55 | VDBEカバレッジテスト | E-20 | △ |
| C-56 | 大量データ処理ストレステスト | E-16 | ○ |
| C-57 | 大容量ファイル処理テスト | E-17 | ○ |
| C-58 | メモリ割り当て失敗耐性テスト | E-18, E-19 | ○ |
| C-59 | OOM耐性テスト | E-19 | ○ |
| C-60 | フォールト注入テスト | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- **リソース制限テストの具体的実装**：sqliteLimit.hで定義されている制限値に対する具体的なテストケースの実装詳細が一部不明
  - 候補：test/limit.test / test/sqllimits1.test / test/boundary*.test
- **VDBEカバレッジの具体的達成率**：カバレッジ率の具体的な数値が不明
  - 候補：CI/CDレポート / テストカバレッジツール出力
- **性能テストの具体的な合格基準**：「妥当な時間内」の定義が曖昧
  - 候補：ベンチマーク基準値定義ドキュメント / 過去のテスト結果

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：性能テスト（NFT-001〜NFT-018）- test/speed1.testに明確な実装あり
- **0（低リスク）**：セキュリティテスト（NFT-019〜NFT-024）- test/auth.testに詳細な認可テストあり
- **0（低リスク）**：可用性テスト（NFT-025〜NFT-036）- crash/corrupt/mutex/threadテストで網羅
- **1（中リスク）**：リソース制限テスト（NFT-037〜NFT-049）- 制限値定義はあるが個別テストの実装確認が一部必要
- **1（中リスク）**：互換性テスト（NFT-050〜NFT-052）- VFS/メモリアロケータの実装は確認済みだがテスト網羅性の確認が必要
- **1（中リスク）**：保守性テスト（NFT-053〜NFT-055）- ビルドプロセスの詳細確認が必要
- **0（低リスク）**：ストレステスト（NFT-056〜NFT-060）- 関連テストファイルで網羅

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テスト（NFT-001〜NFT-018）の合格基準が実環境で妥当か確認
- [ ] リソース制限テスト（NFT-037〜NFT-049）の具体的なテスト実装を確認
- [ ] 各テストケースの優先度が業務要件と整合しているか確認
- [ ] マルチスレッド/マルチプロセステストのスレッド数・プロセス数が十分か確認
- [ ] クラッシュ復旧テストのシナリオカバレッジが十分か確認
- [ ] セキュリティテストで認可制御以外の観点（SQLインジェクション等）が必要か検討
- [ ] 互換性テストで対象プラットフォーム・バージョンの網羅性を確認
