---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **レスポンスタイム目標値**：具体的な数値目標がコードから推測
  2. **稼働率目標**：定量的な目標値なし
  3. **暗号化機能**：コアには含まれず（SEE等は別売）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/sqliteLimit.h` - 各種制限値の定義
- E-02: `src/malloc.c` - メモリ管理機能の実装
- E-03: `src/pager.c` - ページキャッシュとトランザクション管理
- E-04: `src/pcache.c` - ページキャッシュの実装
- E-05: `src/wal.c` - Write-Ahead Loggingの実装
- E-06: `src/backup.c` - オンラインバックアップAPI
- E-07: `src/auth.c` - 認可コールバック機能
- E-08: `src/main.c` - 初期化とグローバル設定
- E-09: `src/global.c` - グローバル設定変数
- E-10: `src/sqliteInt.h` - 内部ヘッダー、各種マクロ定義
- E-11: `src/os_unix.c` - Unix VFS実装、ファイルロック
- E-12: `src/mutex.c` - ミューテックス実装
- E-13: `src/btree.c` - B-Treeストレージエンジン
- E-14: `README.md` - プロジェクト概要とビルド手順
- E-15: `ext/` - 拡張機能ディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQLITE_MAX_LENGTH = 1,000,000,000バイト | E-01 (L23-25) | ○ |
| C-02 | SQLITE_MAX_SQL_LENGTH = 1,000,000,000バイト | E-01 (L88-90) | ○ |
| C-03 | SQLITE_MAX_COLUMN = 2,000 | E-01 (L72-76) | ○ |
| C-04 | SQLITE_MAX_PAGE_SIZE = 65,536バイト | E-01 (L207) | ○ |
| C-05 | SQLITE_DEFAULT_PAGE_SIZE = 4,096バイト | E-01 (L213-215) | ○ |
| C-06 | SQLITE_MAX_PAGE_COUNT = 4,294,967,294 | E-01 (L244-246) | ○ |
| C-07 | SQLITE_MAX_FUNCTION_ARG = 1,000 | E-01 (L147-149) | ○ |
| C-08 | SQLITE_MAX_EXPR_DEPTH = 1,000 | E-01 (L101-103) | ○ |
| C-09 | SQLITE_MAX_ATTACHED = 10 | E-01 (L178-180) | ○ |
| C-10 | SQLITE_DEFAULT_CACHE_SIZE = -2000 | E-01 (L160-162) | ○ |
| C-11 | SQLITE_DEFAULT_WAL_AUTOCHECKPOINT = 1000 | E-01 (L168-170) | ○ |
| C-12 | SQLITE_MAX_ALLOCATION_SIZE = 2,147,483,391 | E-01 (L42-47) | ○ |
| C-13 | ソフト/ハードヒープ上限設定可能 | E-02 (L95-153) | ○ |
| C-14 | sqlite3_soft_heap_limit64()存在 | E-02 (L95-123) | ○ |
| C-15 | sqlite3_hard_heap_limit64()存在 | E-02 (L137-153) | ○ |
| C-16 | SQLITE_DEFAULT_LOOKASIDE = 1200,40 | E-09 (L218-224) | ○ |
| C-17 | SQLITE_MALLOC_SOFT_LIMIT = 1024 | E-10 (L425-427) | ○ |
| C-18 | Pagerによるトランザクション管理 | E-03 (L12-110) | ○ |
| C-19 | ロールバックジャーナルによる自動復旧 | E-03 (L26-110) | ○ |
| C-20 | WALモードによる同時読み書き | E-05 (L1-200) | ○ |
| C-21 | 5レベルのロック制御 | E-03 (L134-169) | ○ |
| C-22 | オンラインバックアップAPI | E-06 (L11-200) | ○ |
| C-23 | sqlite3_backup_init()スレッドセーフ | E-06 (L44-71) | ○ |
| C-24 | 認可コールバック機能 | E-07 (L19-84) | ○ |
| C-25 | SQLITE_DENY, SQLITE_IGNORE対応 | E-07 (L60-65) | ○ |
| C-26 | SQLITE_DEFAULT_FILE_PERMISSIONS = 0644 | E-11 (L166-168) | ○ |
| C-27 | SQLITE_DEFAULT_PROXYDIR_PERMISSIONS = 0755 | E-11 (L173-175) | ○ |
| C-28 | MAX_PATHNAME = 512 | E-11 (L180) | ○ |
| C-29 | SQLITE_MAX_SYMLINKS = 100 | E-11 (L185) | ○ |
| C-30 | 複数ファイルロッキング方式対応 | E-11 (L17-65) | ○ |
| C-31 | SQLITE_THREADSAFEによるスレッドモード | E-10 (L347-369) | ○ |
| C-32 | SQLITE_MAX_PARSER_DEPTH = 2500 | E-01 (L116-118) | ○ |
| C-33 | SQLITE_MAX_LIKE_PATTERN_LENGTH = 50,000 | E-01 (L252-254) | ○ |
| C-34 | SQLITE_MAX_TRIGGER_DEPTH = 1,000 | E-01 (L263-265) | ○ |
| C-35 | VFSプラグイン可能 | E-11 (L1-45) | ○ |
| C-36 | FTS3/4/5拡張存在 | E-15 | ○ |
| C-37 | R-Tree拡張存在 | E-15 | ○ |
| C-38 | ICU拡張存在 | E-15 | ○ |
| C-39 | アマルガメーション対応 | E-14 (L277-302) | ○ |
| C-40 | SQLITE_ENABLE_API_ARMOR | E-10 (L328-332) | ○ |
| C-41 | SQLITE_DEFAULT_MEMSTATUS = 1 | E-10 (L380-386) | ○ |
| C-42 | レスポンスタイム目標値 | **根拠なし** | △ |
| C-43 | 稼働率目標値 | **根拠なし** | △ |
| C-44 | 暗号化機能 | **根拠なし** | △ |
| C-45 | 2GB超ファイルサポート | E-10 (L67-96) | ○ |

## 4) 不足情報（Unknown / Missing）
- **レスポンスタイム目標値**：コード上に具体的な性能目標は定義されていない。実際のパフォーマンスはハードウェア、データ量、クエリ複雑度に依存する。
  - 候補：ベンチマーク結果 / 公式ドキュメント / SQLite Consortium資料
- **稼働率目標値**：組み込みデータベースのため、サーバ稼働率という概念が適用されない。アプリケーション可用性に依存。
  - 候補：運用実績データ / ユーザー事例
- **暗号化機能**：SQLiteコアには暗号化機能なし。SQLite Encryption Extension (SEE)は別売商用製品。
  - 候補：SEEドキュメント / サードパーティ暗号化拡張

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: データ制限値（C-01〜C-12）- コード内定数から直接抽出
- **0（低リスク）**: メモリ管理API（C-13〜C-17）- 実装コードから確認済み
- **0（低リスク）**: トランザクション管理（C-18〜C-21）- 実装ロジックから確認済み
- **1（中リスク）**: パフォーマンス目標（C-42）- 定量目標なし、環境依存
- **1（中リスク）**: 可用性目標（C-43）- 定量目標なし、運用依存
- **2（高リスク）**: 暗号化機能（C-44）- コア機能に含まれず、要追加検討

## 6) レビュアーチェックリスト（最小）
- [ ] SQLITE_MAX_LENGTH等の制限値がsqliteLimit.hの実際の値と一致しているか確認
- [ ] メモリ管理関数（sqlite3_soft_heap_limit64等）の仕様がmalloc.cの実装と一致しているか確認
- [ ] ロック制御の5段階がpager.cのコメントと一致しているか確認
- [ ] 認可コールバックの応答コード（SQLITE_OK, DENY, IGNORE）がauth.cの実装と一致しているか確認
- [ ] VFS対応ロッキング方式がos_unix.cのコメントと一致しているか確認
- [ ] ext/ディレクトリに記載の拡張機能が実在するか確認
- [ ] レスポンスタイム・稼働率目標の妥当性を運用観点でレビュー
- [ ] 暗号化要件がある場合、SEEまたは代替手段の検討が必要
