# 非機能要件定義書

## 概要

本ドキュメントは、SQLiteデータベースエンジンの非機能要件を定義します。SQLiteは、軽量で高速な組み込み型リレーショナルデータベースであり、サーバレスアーキテクチャを採用しています。本定義書では、ソースコードから抽出された性能、可用性、セキュリティ、拡張性、保守性、運用・監視の各要件について記載します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 単純SELECT | マイクロ秒オーダー | インメモリキャッシュ活用時 |
| INSERT/UPDATE/DELETE | ミリ秒オーダー | ジャーナルモードにより変動 |
| 複雑なJOINクエリ | データ量依存 | クエリオプティマイザによる最適化 |
| トランザクションコミット | fsync設定依存 | synchronous設定により変動 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時読み取り接続数 | 制限なし（WALモード時） | SHARED lockで複数リーダー許可 |
| 書き込み接続 | 1接続（排他） | EXCLUSIVE lockによる排他制御 |
| ページキャッシュサイズ | デフォルト2048KB（-2000ページ） | SQLITE_DEFAULT_CACHE_SIZE設定 |
| WAL自動チェックポイント | 1000フレーム | SQLITE_DEFAULT_WAL_AUTOCHECKPOINT |

### メモリ管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| 最大メモリ割当サイズ | 2,147,483,391バイト | SQLITE_MAX_ALLOCATION_SIZE |
| ソフトヒープ上限 | 設定可能 | sqlite3_soft_heap_limit64() |
| ハードヒープ上限 | 設定可能 | sqlite3_hard_heap_limit64() |
| Lookaside割当 | 1200バイト x 40スロット（デフォルト） | SQLITE_DEFAULT_LOOKASIDE |
| メモリマップサイズ | SQLITE_MAX_MMAP_SIZE依存 | szMmap設定 |

### データ制限

| 項目 | 制限値 | 備考 |
| --- | --- | --- |
| 最大BLOB/TEXTサイズ | 1,000,000,000バイト | SQLITE_MAX_LENGTH |
| 最大SQL文長 | 1,000,000,000バイト | SQLITE_MAX_SQL_LENGTH |
| 最大カラム数 | 2,000 | SQLITE_MAX_COLUMN |
| 最大ページサイズ | 65,536バイト | SQLITE_MAX_PAGE_SIZE |
| デフォルトページサイズ | 4,096バイト | SQLITE_DEFAULT_PAGE_SIZE |
| 最大ページ数 | 4,294,967,294 | SQLITE_MAX_PAGE_COUNT |
| 最大関数引数 | 1,000 | SQLITE_MAX_FUNCTION_ARG |
| 最大式の深さ | 1,000 | SQLITE_MAX_EXPR_DEPTH |
| 最大接続データベース数 | 10（最大125） | SQLITE_MAX_ATTACHED |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 埋込型DB特性により高可用性 | サーバレスのためサーバダウンなし |
| 計画停止時間 | 不要 | アプリケーション起動時に自動初期化 |
| 障害復旧時間（RTO） | 秒単位 | ジャーナル/WALからの自動リカバリ |
| 目標復旧時点（RPO） | 最終コミット時点 | ACID準拠のトランザクション |

### トランザクション管理

- **ジャーナルモード**: DELETE, TRUNCATE, PERSIST, MEMORY, WAL, OFF
- **ロールバックジャーナル**: トランザクション失敗時の自動復旧
- **WAL（Write-Ahead Logging）**: 同時読み書きの最適化、チェックポイントによるデータ永続化
- **アトミックコミット**: 電源障害時もデータ整合性を保証

### ロック制御

| ロックタイプ | 説明 | 同時実行性 |
| --- | --- | --- |
| UNLOCKED | ロックなし | - |
| SHARED | 読み取りロック | 複数許可 |
| RESERVED | 書き込み予約 | 1接続のみ |
| PENDING | 書き込み待機 | 新規SHARED禁止 |
| EXCLUSIVE | 排他ロック | 全操作排他 |

### ファイルロッキング方式

- POSIX Advisory Locks（デフォルト）
- flock()
- dot-file locks
- AFP locks（macOS）
- proxy locking（macOS）
- named semaphores（VxWorks）

## セキュリティ要件

### アクセス制御

- **認可コールバック**: sqlite3_set_authorizer()による操作レベル制御
- **認可対象操作**:
  - CREATE/DROP（TABLE, INDEX, VIEW, TRIGGER）
  - INSERT, UPDATE, DELETE, SELECT
  - PRAGMA, TRANSACTION, ATTACH
- **認可応答**: SQLITE_OK（許可）, SQLITE_DENY（拒否）, SQLITE_IGNORE（無視）

### ファイルセキュリティ

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| デフォルトファイルパーミッション | 0644 | SQLITE_DEFAULT_FILE_PERMISSIONS |
| プロキシディレクトリパーミッション | 0755 | SQLITE_DEFAULT_PROXYDIR_PERMISSIONS |

### 入力検証

- SQL文長制限（SQLITE_MAX_SQL_LENGTH）
- 式の深さ制限（SQLITE_MAX_EXPR_DEPTH）
- パーサースタック制限（SQLITE_MAX_PARSER_DEPTH: 2500）
- LIKEパターン長制限（SQLITE_MAX_LIKE_PATTERN_LENGTH: 50,000）
- トリガー再帰深さ制限（SQLITE_MAX_TRIGGER_DEPTH: 1,000）

### メモリ保護

- SQLITE_MALLOC_SOFT_LIMIT: 1024バイト（割当サイズ推奨上限）
- API Armor: SQLITE_ENABLE_API_ARMORによる不正使用検出
- メモリ使用量監視: SQLITE_DEFAULT_MEMSTATUS

## 拡張性要件

### VFS（Virtual File System）

- プラグイン可能なファイルシステム抽象化層
- OS依存コードの分離（os_unix.c, os_win.c）
- カスタムVFS登録機能

### 拡張機能

- **FTS3/4/5**: 全文検索エンジン
- **R-Tree**: 空間インデックス
- **ICU**: 国際化対応
- **JSON**: JSON操作関数
- **RBU**: Resumable Bulk Update
- **Session**: 変更追跡・適用

### スレッドセーフティ

| モード | SQLITE_THREADSAFE値 | 説明 |
| --- | --- | --- |
| シングルスレッド | 0 | ミューテックス無効 |
| マルチスレッド | 2 | 異なる接続は別スレッドで使用可 |
| シリアライズ | 1（デフォルト） | 同一接続も複数スレッドで使用可 |

### アマルガメーション

- 全ソースを単一ファイル（sqlite3.c）に統合
- コンパイラ最適化の向上（約5%高速化）
- 配布・統合の簡素化

## 保守性要件

### コード品質

- 公開ドメインライセンス
- 広範なテストスイート（test/ディレクトリ）
- コンパイル時オプションによる機能カスタマイズ
- デバッグモード（SQLITE_DEBUG）
- カバレッジテスト（SQLITE_COVERAGE_TEST）

### 設定管理

- コンパイル時オプション（-DSQLITE_*）
- PRAGMA文による実行時設定
- sqlite3_config()によるグローバル設定
- sqlite3_db_config()によるデータベース固有設定

### ドキュメント

- インラインコメントによる実装説明
- ソースヘッダーファイル（sqlite3.h）内のAPIドキュメント
- 設計意図の明示（IMPLEMENTATION-OF, EVIDENCE-OF コメント）

## 運用・監視要件

### ステータス監視

- sqlite3_status64(): グローバル統計
- sqlite3_db_status(): データベース統計
- sqlite3_stmt_status(): ステートメント統計

### メモリ監視

| 指標 | 取得方法 |
| --- | --- |
| 使用中メモリ量 | sqlite3_memory_used() |
| 最大メモリ使用量 | sqlite3_memory_highwater() |
| ヒープ上限到達 | sqlite3HeapNearlyFull() |

### ロギング

- sqlite3_config(SQLITE_CONFIG_LOG)によるログコールバック
- SQLITE_ENABLE_SQLLOGによるSQL文ロギング
- IOトレース（SQLITE_ENABLE_IOTRACE）

### バックアップ

- **Online Backup API**: sqlite3_backup_init(), sqlite3_backup_step(), sqlite3_backup_finish()
- 稼働中のデータベースから安全にバックアップ取得可能
- ページ単位のインクリメンタルコピー

### 自動回復機能

- 電源障害時の自動ロールバック
- WALチェックポイント自動実行
- 破損検出と回復（PRAGMA integrity_check）

## 備考

### 移植性

- 幅広いOS対応: Linux, macOS, Windows, iOS, Android, VxWorks等
- 2GB超ファイルサポート（_FILE_OFFSET_BITS=64）
- リトルエンディアン/ビッグエンディアン対応
- WebAssembly(WASM)対応

### コンパイル要件

- C89/C90互換
- オプションでC99数学関数使用（SQLITE_HAVE_C99_MATH_FUNCS）
- MSVC 2013以降でC99数学関数利用可能

### 制限事項

- ネットワークファイルシステムでのWALモード非サポート（共有メモリ要件）
- 最大パス長: 512バイト（MAX_PATHNAME）
- シンボリックリンク最大深度: 100（SQLITE_MAX_SYMLINKS）
