# API設計書

## 概要

本ドキュメントは、StaxRip（Windows用動画/音声エンコーディングGUIアプリケーション）が提供する各種APIおよびインターフェースについて記載します。StaxRipはWebベースのREST APIを持たないデスクトップアプリケーションですが、以下の4種類のプログラマブルインターフェースを提供しています：

1. **コマンドラインインターフェース** - アプリケーション起動時の引数処理
2. **コマンドシステム** - GlobalCommandsで定義された自動化コマンド
3. **マクロシステム** - 変数展開のためのマクロAPI
4. **PowerShell統合** - PowerShellスクリプトからStaxRipを制御するAPI

## 共通仕様

### アプリケーション情報

```
アプリケーション名: StaxRip
プラットフォーム: Windows (VB.NET)
ライセンス: MIT License
```

### 動作環境

| 項目 | 内容 |
| --- | --- |
| OS | Windows 8以降（一部機能はWindows 7対応） |
| ランタイム | .NET Framework / Visual C++ Redistributable |
| 前提条件 | Microsoft Visual C++ Redistributable Runtimes |

## API一覧

### 1. コマンドラインインターフェース

| コマンド | パラメータ | 説明 |
| --- | --- | --- |
| -LoadTemplate | templateName | 指定したテンプレートをロード |
| -LoadSourceFile | path | ソースファイルをロード |
| -LoadSourceFiles | paths[] | 複数のソースファイルをロード |
| -SetTargetFile | path | ターゲットファイルパスを設定 |
| -StartJobs | - | アクティブなジョブを開始 |
| -ExecuteCommandLine | commandLine, waitForExit, showProcessWindow, useShellExecute, workingDirectory | コマンドラインを実行 |
| -ExecutePowerShellCode | code, externalShell | PowerShellコードを実行 |
| -Standby | - | PCをスタンバイ |
| -Shutdown | - | PCをシャットダウン |
| -SetHideDialogsOption | hide | ダイアログ非表示オプションを設定 |

### 2. GlobalCommands（自動化コマンド）

| コマンド | パラメータ | 説明 |
| --- | --- | --- |
| CheckForUpdate | - | アップデートの有無をチェック |
| ShowLogFile | - | ログファイルを表示 |
| ShowDemuxTool | - | デマックスツールを表示 |
| StartJobs | - | アクティブなジョブを開始 |
| ShowMacrosDialog | - | マクロダイアログを表示 |
| ExecuteCommandLine | commandLine, waitForExit, showProcessWindow, useShellExecute, workingDirectory | コマンドラインを実行 |
| StartTool | name | ツールを名前で起動 |
| ExecutePowerShellCode | code, externalShell | PowerShellコードを実行 |
| ExecutePowerShellFile | filepath, args | PowerShellスクリプトファイルを実行 |
| SetCrop | left, top, right, bottom | クロップ値を設定 |
| AddFilter | active, name, category, script | フィルタを追加 |
| SetFilter | name, category, script | フィルタを設定 |
| DisableFilterNames | filterNames[] | フィルタを名前で無効化 |
| EnableFilterNames | filterNames[] | フィルタを名前で有効化 |
| SetTargetFile | path | ターゲットファイルを設定 |
| LoadSourceFile | path | ソースファイルをロード |
| LoadSourceFiles | paths[] | 複数のソースファイルをロード |
| AddAttachments | attachments[] | 添付ファイルを追加（mkvmergeのみ） |
| AddChaptersFile | filepath | チャプターファイルを追加 |
| AddSubtitle | enabled, lang, name, default, forced, commentary, hearingimpaired, filepath | 字幕を追加 |
| AddSubtitles | subtitles[] | 字幕を一括追加 |
| AddTagFile | filepath | タグファイルを追加（mkvmergeのみ） |
| AddTags | tags | タグを追加（mkvmergeのみ） |
| SetTitle | title | コンテナタイトルを設定（mkvmergeのみ） |
| SetVideoTrackLanguage | lang | ビデオトラック言語を設定（mkvmergeのみ） |
| SetVideoTrackName | trackName | ビデオトラック名を設定 |
| DisableEvents | eventNames[] | イベントを名前で無効化 |
| EnableEvents | eventNames[] | イベントを名前で有効化 |
| ShowMessageBox | mainInstruction, content, icon | メッセージボックスを表示 |
| CopyToClipboard | value | クリップボードにコピー |
| WriteLog | header, message | ログにメッセージを書き込み |
| DeleteFiles | dir, filter | ファイルを削除 |
| ImportVideoEncoderCommandLine | commandLine | ビデオエンコーダー設定をインポート |
| PlaySound | FilePath, Volume | サウンドを再生 |
| ShowMediaInfo | filepath | MediaInfoを表示 |
| ShowMkvInfo | - | MKVInfoを表示 |
| SaveMKVHDR | - | MKVにHDR10メタデータを保存 |
| SaveGIF | - | GIFアニメーションを生成 |
| SavePNG | - | PNGアニメーションを生成 |
| ShowThumbnailerDialogAsync | - | サムネイル生成ダイアログを表示 |
| ResetSettings | - | 設定をリセット |

### 3. マクロシステム

| マクロ名 | 型 | 説明 |
| --- | --- | --- |
| %source_file% | String | ソースファイルのパス |
| %source_dir% | String | ソースファイルのディレクトリ |
| %source_name% | String | ソースファイル名（拡張子なし） |
| %source_ext% | String | ソースファイルの拡張子 |
| %source_width% | Integer | ソース映像の幅 |
| %source_height% | Integer | ソース映像の高さ |
| %source_frames% | Integer | ソース映像のフレーム数 |
| %source_framerate% | Decimal | ソース映像のフレームレート |
| %source_seconds% | Integer | ソース映像の長さ（秒） |
| %target_file% | String | ターゲットファイルのパス |
| %target_dir% | String | ターゲットファイルのディレクトリ |
| %target_name% | String | ターゲットファイル名（拡張子なし） |
| %target_width% | Integer | ターゲット映像の幅 |
| %target_height% | Integer | ターゲット映像の高さ |
| %target_frames% | Integer | ターゲット映像のフレーム数 |
| %target_framerate% | Decimal | ターゲット映像のフレームレート |
| %crop_left% | Integer | 左クロップ値 |
| %crop_top% | Integer | 上クロップ値 |
| %crop_right% | Integer | 右クロップ値 |
| %crop_bottom% | Integer | 下クロップ値 |
| %crop_width% | Integer | クロップ後の幅 |
| %crop_height% | Integer | クロップ後の高さ |
| %video_bitrate% | Integer | ビデオビットレート（Kbps） |
| %audio_bitrate% | Integer | オーディオビットレート（合計） |
| %encoder% | String | アクティブなビデオエンコーダー名 |
| %encoder_profile% | String | エンコーダープロファイル名 |
| %encoder_settings% | String | エンコーダー設定 |
| %encoder_ext% | String | エンコーダー出力拡張子 |
| %muxer_ext% | String | マクサー出力拡張子 |
| %script_file% | String | スクリプトファイルのパス |
| %script_ext% | String | スクリプト拡張子（avs/vpy） |
| %temp_dir% | String | 一時ディレクトリ |
| %temp_file% | String | 一時ファイルパス |
| %startup_dir% | String | アプリケーションディレクトリ |
| %settings_dir% | String | 設定ディレクトリ |
| %plugin_dir% | String | プラグインディレクトリ |
| %version% | String | StaxRipバージョン |
| %current_date% | String | 現在の日付（yyyy-MM-dd） |
| %current_time% | String | 現在の時刻（12時間形式） |
| %current_time24% | String | 現在の時刻（24時間形式） |
| %processing% | String | ジョブ処理中かどうか（True/False） |
| %app_path:name% | String | 指定ツールのパス |
| %app_dir:name% | String | 指定ツールのディレクトリ |
| %app_version:name% | String | 指定ツールのバージョン |
| %eval:expression% | String | PowerShell式を評価 |
| %filter:name% | String | 指定フィルタのスクリプトコード |
| %random:digits% | Integer | ランダムな数値 |
| %source_mi_g:property% | String | MediaInfo General プロパティ |
| %source_mi_v:property% | String | MediaInfo Video プロパティ |
| %source_mi_a:property% | String | MediaInfo Audio プロパティ |
| %source_mi_t:property% | String | MediaInfo Text プロパティ |

#### インタラクティブマクロ

| マクロ名 | 説明 |
| --- | --- |
| $browse_file$ | ファイルブラウザを表示 |
| $enter_text$ | テキスト入力ダイアログを表示 |
| $enter_text:prompt$ | プロンプト付きテキスト入力ダイアログ |
| $select:param1;param2;...$ | 選択ダイアログを表示 |

### 4. イベントシステム

| イベント名 | 説明 |
| --- | --- |
| AfterJobAdded | ジョブ追加後 |
| AfterJobFailed | ジョブ失敗後 |
| AfterJobMuxed | ジョブマックス後 |
| AfterJobProcessed | ジョブ処理後 |
| AfterJobsProcessed | 全ジョブ処理後 |
| AfterProjectLoaded | プロジェクトロード後 |
| AfterProjectOrSourceLoaded | プロジェクトまたはソースロード後 |
| AfterSourceOpened | ソースオープン後 |
| AfterSourceLoaded | ソースロード後 |
| AfterVideoEncoded | ビデオエンコード後 |
| ApplicationExit | アプリケーション終了時 |
| BeforeJobAdding | ジョブ追加前 |
| BeforeJobProcessed | ジョブ処理前 |
| BeforeMuxing | マックス前 |
| BeforeProcessing | 処理前 |
| WhileProcessing | 処理中（commandLine, percentage, lastProgress） |

## 各APIエンドポイント定義

### コマンドラインインターフェース

#### 1. LoadSourceFile

ソースファイルをロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-LoadSourceFile:path` |
| パラメータ | ファイルパス |

**使用例**

```
StaxRip.exe -LoadSourceFile:"C:\Videos\input.mkv"
```

---

#### 2. LoadSourceFiles

複数のソースファイルをロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-LoadSourceFiles:path1;path2;...` |
| パラメータ | セミコロン区切りのファイルパス |

**使用例**

```
StaxRip.exe -LoadSourceFiles:"C:\Videos\part1.mkv";"C:\Videos\part2.mkv"
```

---

#### 3. LoadTemplate

テンプレートをロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-LoadTemplate:templateName` |
| パラメータ | テンプレート名 |

**使用例**

```
StaxRip.exe -LoadTemplate:"x265 1080p" "C:\Videos\input.mkv"
```

---

#### 4. SetTargetFile

ターゲットファイルのパスを設定します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-SetTargetFile:path` |
| パラメータ | 出力ファイルパス |

**使用例**

```
StaxRip.exe "C:\Videos\input.mkv" -SetTargetFile:"D:\Output\video.mkv"
```

---

#### 5. ExecuteCommandLine

外部コマンドラインを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-ExecuteCommandLine:commandLine,waitForExit,showProcessWindow,useShellExecute,workingDirectory` |
| パラメータ | コマンドライン、待機フラグ、プロセスウィンドウ表示、シェル実行使用、作業ディレクトリ |

**パラメータ詳細**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| commandLine | String | ○ | - | 実行するコマンドライン（マクロ展開可） |
| waitForExit | Boolean | - | False | コマンド完了まで待機 |
| showProcessWindow | Boolean | - | False | プロセスウィンドウを表示 |
| useShellExecute | Boolean | - | True | シェル実行を使用 |
| workingDirectory | String | - | - | 作業ディレクトリ |

---

#### 6. ExecutePowerShellCode

PowerShellコードを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-ExecutePowerShellCode:code,externalShell` |
| パラメータ | PowerShellコード、外部シェル使用フラグ |

**パラメータ詳細**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| code | String | ○ | - | 実行するPowerShellコード（マクロ展開可） |
| externalShell | Boolean | - | False | 外部シェルで実行 |

---

#### 7. StartJobs

アクティブな全ジョブを開始します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-StartJobs` |
| パラメータ | なし |

**使用例**

```
StaxRip.exe "C:\Videos\input.mkv" -StartJobs
```

---

#### 8. AddSubtitle

字幕ファイルをコンテナに追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `-AddSubtitle:enabled,lang,name,default,forced,commentary,hearingimpaired,filepath` |
| パラメータ | 有効フラグ、言語、名前、デフォルトフラグ、強制フラグ、コメンタリーフラグ、聴覚障害者用フラグ、ファイルパス |

**パラメータ詳細**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| enabled | Boolean | - | True | 有効/無効 |
| lang | String | - | - | 言語コードまたは名前 |
| name | String | - | - | 字幕タイトル |
| default | Boolean | - | False | デフォルトフラグ |
| forced | Boolean | - | False | 強制フラグ |
| commentary | Boolean | - | False | コメンタリーフラグ |
| hearingimpaired | Boolean | - | False | 聴覚障害者用フラグ |
| filepath | String | ○ | - | 字幕ファイルパス |

---

### PowerShell統合API

StaxRipは内部でPowerShellランタイムを統合しており、PowerShellスクリプトからStaxRipを直接制御できます。

#### PowerShell実行環境

| 項目 | 内容 |
| --- | --- |
| 実行ポリシー | Unrestricted（プロセススコープ） |
| スレッドオプション | UseCurrentThread |
| アパートメント状態 | STA |

#### 利用可能なオブジェクト

PowerShellスクリプト内で以下のStaxRipオブジェクトにアクセスできます：

| オブジェクト | 説明 |
| --- | --- |
| p | 現在のプロジェクト（Project） |
| s | アプリケーション設定（ApplicationSettings） |
| g | グローバルクラス（GlobalClass） |

#### 自動ロードスクリプト

以下のディレクトリに配置された`.ps1`ファイルはアプリケーション起動時に自動実行されます：

- `{StaxRip起動ディレクトリ}/Apps/Scripts/`
- `{設定ディレクトリ}/Scripts/Auto Load/`

---

### マクロシステム使用例

#### 基本的なマクロ展開

```
%source_file%  -> C:\Videos\input.mkv
%target_file%  -> C:\Output\output.mkv
%source_width% -> 1920
%source_height% -> 1080
```

#### パラメータ付きマクロ

```
%app_path:x265%      -> C:\StaxRip\Apps\x265\x265.exe
%app_version:ffmpeg% -> 6.1
%eval:1+1%           -> 2
%audio_bitrate:1%    -> 192 (1番目のオーディオトラックのビットレート)
```

#### MediaInfoマクロ

```
%source_mi_g:Format%        -> Matroska
%source_mi_v:Format%        -> HEVC
%source_mi_a0:Channels%     -> 6
%source_mi_t0:Language%     -> Japanese
```

---

## 備考

### 制限事項

1. StaxRipはWindowsデスクトップアプリケーションであり、HTTPベースのWeb APIは提供していません。
2. コマンドライン引数は起動時にのみ処理されます。
3. PowerShell統合はStaxRipのプロセス内で実行されるため、StaxRipのUIとの相互作用が可能です。
4. マクロはプロジェクトコンテキストに依存するため、プロジェクトがロードされていない状態では一部のマクロが展開されません。

### 参考リンク

- GitHub: https://github.com/staxrip/staxrip
- Wiki: https://github.com/staxrip/staxrip/wiki
- Discord: https://discord.gg/uz8pVR79Bd
