---
generated_at: 2026-01-21 19:45:00
metrics:
  claims_total: 48
  claims_with_evidence: 45
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：45 / 48、根拠なし：3
- 優先レビュー（高）
  1. **PowerShell実行環境の詳細設定**：一部のデフォルト値が推測
  2. **自動ロードスクリプトの正確なパス**：設定ディレクトリの詳細が不明
  3. **一部のマクロのデフォルト動作**：エッジケースの動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/GlobalCommands.vb` - GlobalCommandsクラス定義
- E-02: `Source/General/Macro.vb` - Macroクラス定義
- E-03: `Source/General/PowerShell.vb` - PowerShell統合実装
- E-04: `Source/General/GlobalClass.vb` - GlobalClassイベント定義
- E-05: `Source/Forms/MainForm.vb` - ProcessCommandLineメソッド
- E-06: `Source/General/General.vb` - ProcessCommandLineArgumentメソッド
- E-07: `README.md` - プロジェクト概要
- E-08: `Source/StaxRip.sln` - ソリューション構造確認
- E-09: `Source/General/ApplicationSettings.vb` - 設定クラス（参照）
- E-10: `Source/General/Project.vb` - プロジェクトクラス（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StaxRipはWindowsデスクトップアプリケーションである | E-07, E-08 | ○ |
| C-02 | WebベースのREST APIを持たない | E-01～E-06（該当コードなし） | ○ |
| C-03 | コマンドラインインターフェースが存在する | E-05, E-06 | ○ |
| C-04 | GlobalCommandsで自動化コマンドが定義されている | E-01 | ○ |
| C-05 | マクロシステムが存在する | E-02 | ○ |
| C-06 | PowerShell統合機能がある | E-03, E-04 | ○ |
| C-07 | -LoadSourceFileコマンドが存在する | E-01 (LoadSourceFileメソッド) | ○ |
| C-08 | -LoadSourceFilesコマンドが存在する | E-01 (LoadSourceFilesメソッド) | ○ |
| C-09 | -SetTargetFileコマンドが存在する | E-01 (SetTargetFileメソッド) | ○ |
| C-10 | -StartJobsコマンドが存在する | E-01 (StartJobsメソッド) | ○ |
| C-11 | -ExecuteCommandLineコマンドが存在する | E-01 (ExecuteCommandLineメソッド) | ○ |
| C-12 | -ExecutePowerShellCodeコマンドが存在する | E-01 (ExecutePowerShellCodeメソッド) | ○ |
| C-13 | CheckForUpdateコマンドが存在する | E-01 (CheckForUpdateメソッド) | ○ |
| C-14 | ShowLogFileコマンドが存在する | E-01 (ShowLogFileメソッド) | ○ |
| C-15 | ShowDemuxToolコマンドが存在する | E-01 (ShowDemuxToolメソッド) | ○ |
| C-16 | StartToolコマンドが存在する | E-01 (StartToolメソッド) | ○ |
| C-17 | SetCropコマンドが存在する | E-01 (SetCropメソッド) | ○ |
| C-18 | AddFilterコマンドが存在する | E-01 (AddFilterメソッド) | ○ |
| C-19 | SetFilterコマンドが存在する | E-01 (SetFilterメソッド) | ○ |
| C-20 | AddSubtitleコマンドが存在する | E-01 (AddSubtitleメソッド) | ○ |
| C-21 | AddTagsコマンドが存在する | E-01 (AddTagsメソッド) | ○ |
| C-22 | SetTitleコマンドが存在する | E-01 (SetTitleメソッド) | ○ |
| C-23 | %source_file%マクロが存在する | E-02 (Expandメソッド) | ○ |
| C-24 | %target_file%マクロが存在する | E-02 (Expandメソッド) | ○ |
| C-25 | %source_width%マクロが存在する | E-02 (Expandメソッド) | ○ |
| C-26 | %crop_left%等のクロップマクロが存在する | E-02 (Expandメソッド) | ○ |
| C-27 | %app_path:name%マクロが存在する | E-02 (Expandメソッド) | ○ |
| C-28 | %eval:expression%マクロが存在する | E-02 (Expandメソッド) | ○ |
| C-29 | %source_mi_*%マクロが存在する | E-02 (Expandメソッド) | ○ |
| C-30 | $browse_file$インタラクティブマクロが存在する | E-02 (ExpandGUIメソッド) | ○ |
| C-31 | AfterJobAddedイベントが存在する | E-04 (Eventステートメント) | ○ |
| C-32 | AfterSourceLoadedイベントが存在する | E-04 (Eventステートメント) | ○ |
| C-33 | WhileProcessingイベントが存在する | E-04 (Eventステートメント) | ○ |
| C-34 | PowerShell実行ポリシーがUnrestrictedに設定される | E-03 (Invokeメソッド) | ○ |
| C-35 | スレッドオプションがUseCurrentThreadである | E-03 (Invokeメソッド) | ○ |
| C-36 | アパートメント状態がSTAである | E-03 (Invokeメソッド) | ○ |
| C-37 | PlaySoundコマンドが存在する | E-01 (PlaySoundメソッド) | ○ |
| C-38 | ShowMediaInfoコマンドが存在する | E-01 (ShowMediaInfoメソッド) | ○ |
| C-39 | SaveGIFコマンドが存在する | E-01 (SaveGIFメソッド) | ○ |
| C-40 | SavePNGコマンドが存在する | E-01 (SavePNGメソッド) | ○ |
| C-41 | コマンドライン引数のパース処理が存在する | E-05 (ParseCommandLineメソッド) | ○ |
| C-42 | マクロ展開時にプロジェクトコンテキストが必要 | E-02 (Expandメソッドシグネチャ) | ○ |
| C-43 | MIT Licenseである | E-07 (README.md) | ○ |
| C-44 | VB.NETで実装されている | E-08 (ソリューション/プロジェクトファイル) | ○ |
| C-45 | Windows 8以降が推奨される | E-07 (README.md) | ○ |
| C-46 | 自動ロードスクリプトディレクトリの正確なパス | E-04 (LoadPowerShellScriptsメソッド) | △ |
| C-47 | 一部マクロのエッジケース動作 | **根拠なし** | △ |
| C-48 | 全コマンドのデフォルトパラメータ値 | **一部根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-46：自動ロードスクリプトのパスについて、`Folder.Scripts`の実際のパスが設定ファイルに依存するため、正確なパスの確認が必要
  - 候補：ユーザー設定 / デフォルト設定 / 環境変数
- C-47：マクロのエッジケース（nullプロジェクト、存在しないファイルパス等）の動作
  - 候補：単体テスト / 実行時確認 / ドキュメント
- C-48：一部のコマンドパラメータのデフォルト値がコードで明示されていない
  - 候補：コード確認 / 実行時確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：コマンドラインインターフェースの基本仕様
- **0（低リスク）**：マクロシステムの基本仕様
- **0（低リスク）**：GlobalCommandsの基本コマンド
- **1（中リスク）**：PowerShell統合のセキュリティ設定（実行ポリシーがUnrestricted）
- **0（低リスク）**：イベントシステムの仕様

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドライン引数の形式が実際の実装と一致しているか確認
- [ ] マクロ名と展開結果の例が正しいか確認
- [ ] PowerShell統合のセキュリティ設定が許容範囲内か確認
- [ ] 自動ロードスクリプトのパスが正しいか実環境で確認
- [ ] 一部のコマンドパラメータのデフォルト値を実行時に確認
