# StaxRip

## 概要

StaxRipは、Windows向けの高機能なビデオ/オーディオエンコーディングGUIアプリケーションです。x265、mkvmerge、ffmpegなどのコンソールアプリケーションを制御・実行し、AviSynth+およびVapourSynthによるスクリプトベースのフレームサーバーを使用してビデオ処理を行います。各プロジェクトはイベントや設定により柔軟に拡張可能です。

StaxRipは「ワンクリックエンコーダー」ではありません。ビデオ/オーディオ処理の幅広い作業を実行できる強力なツールですが、その機能を最大限に活用するには、ユーザーが目的を理解し、適切に設定する必要があります。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ビデオエンコーディング | x264、x265、SVT-AV1、AOM AV1、rav1e、VVenCなど多数のエンコーダーをサポート |
| ハードウェアエンコーディング | NVIDIA (NVEnc)、Intel (QSVEnc)、AMD (VCEEnc) のハードウェアエンコーダーに対応 |
| オーディオ処理 | 複数のオーディオプロファイルとエンコーダーをサポート |
| Demuxing | ffmpeg、eac3toなどを使用したストリームの分離・抽出 |
| Muxing | mkvmerge、mp4boxなどを使用した複数ストリームの結合 |
| フレームサーバー | AviSynth+およびVapourSynthによるフィルタリング・処理 |
| クロップ/リサイズ | 自動クロップ検出、カスタムリサイズ設定 |
| プレビュー | リアルタイムプレビューとビデオ比較機能 |
| ジョブ管理 | 複数ジョブのキュー管理と一括処理 |
| アシスタント機能 | 初心者向けのステップバイステップガイド |
| カスタマイズ | イベントコマンド、マクロ、PowerShellスクリプトによる拡張 |
| テーマ | ダーク/ライトテーマのサポート |

## 技術スタック

### コア

- フレームワーク: .NET Framework 4.8
- 言語: VB.NET (Visual Basic .NET)
- プラットフォーム: Windows (x64)
- UI: Windows Forms

### 主要ライブラリ

- DirectN 1.5.0 - DirectX操作用
- ManagedCuda 10.0.31 - CUDA操作用 (NVIDIA GPU支援)
- Microsoft.PowerShell.5.ReferenceAssemblies - PowerShellスクリプト統合

### 連携外部ツール

- ビデオエンコーダー: x264, x265, SVT-AV1, AOM AV1, rav1e, VVenC, ffmpeg
- ハードウェアエンコーダー: NVEnc (NVIDIA), QSVEnc (Intel), VCEEnc (AMD)
- フレームサーバー: AviSynth+, VapourSynth
- Muxer: mkvmerge (MKVToolNix), mp4box, ffmpeg
- Demuxer: ffmpeg, eac3to
- メディア情報: MediaInfo

## ディレクトリ構成

```
staxrip-master/
├── Source/                    # ソースコード
│   ├── Controls/              # カスタムUIコントロール
│   ├── Encoding/              # エンコーダー実装
│   │   ├── x264Enc.vb         # x264エンコーダー
│   │   ├── x265Enc.vb         # x265エンコーダー
│   │   ├── NVEnc.vb           # NVIDIAハードウェアエンコーダー
│   │   ├── QSVEnc.vb          # Intelハードウェアエンコーダー
│   │   ├── VCEEnc.vb          # AMDハードウェアエンコーダー
│   │   ├── SvtAv1Enc.vb       # SVT-AV1エンコーダー
│   │   └── ...                # その他エンコーダー
│   ├── Forms/                 # Windowsフォーム
│   │   ├── MainForm.vb        # メインウィンドウ
│   │   ├── PreviewForm.vb     # プレビューウィンドウ
│   │   ├── ProcessingForm.vb  # 処理進捗ウィンドウ
│   │   └── ...                # その他フォーム
│   ├── FrameServer/           # フレームサーバー統合 (C++)
│   │   ├── AviSynthServer.cpp # AviSynth+サーバー
│   │   └── VapourSynthServer.cpp # VapourSynthサーバー
│   ├── General/               # 共通クラス・ユーティリティ
│   │   ├── GlobalClass.vb     # グローバル設定・状態管理
│   │   ├── Project.vb         # プロジェクト管理
│   │   ├── Demux.vb           # Demuxer基底クラス
│   │   ├── Muxer.vb           # Muxer実装
│   │   └── ...                # その他ユーティリティ
│   ├── Scripts/               # PowerShellスクリプト例
│   ├── UI/                    # UI関連クラス
│   │   ├── Theme.vb           # テーマ管理
│   │   ├── Controls/          # カスタムコントロール
│   │   └── ...                # その他UI
│   ├── Video/                 # ビデオ処理関連
│   │   ├── VideoScript.vb     # スクリプト生成
│   │   ├── FrameServer.vb     # フレームサーバー管理
│   │   └── VideoRenderer.vb   # レンダリング
│   ├── Tools/                 # 補助ツール
│   │   └── AutoCrop/          # 自動クロップツール
│   ├── StaxRip.sln            # ソリューションファイル
│   ├── StaxRip.vbproj         # プロジェクトファイル
│   └── packages.config        # NuGetパッケージ設定
├── Docs/                      # ドキュメント
├── Images/                    # 画像リソース
├── CHANGELOG.md               # 変更履歴
├── CHANGELOG-SUPPORTER.md     # サポーター向け変更履歴
├── License.txt                # MITライセンス
└── README.md                  # プロジェクト説明
```

## セットアップ

### 必要条件

- Windows 8以降 (Windows 7は一部機能制限あり)
- Microsoft Visual C++ Redistributable Runtimes
  - 推奨インストール元: https://github.com/abbodi1406/vcredist/releases
- .NET Framework 4.8

### インストール手順

StaxRipはポータブルアプリケーションです。インストーラーは不要で、以下の手順で使用できます。

1. [最新リリース](https://github.com/staxrip/staxrip/releases/latest)からアーカイブをダウンロード
2. 任意のフォルダに解凍
3. `StaxRip.exe`を実行
4. 初回起動時に設定保存先を選択 (推奨: 起動フォルダ内のサブフォルダ)

### ビルド手順

1. Visual Studio 2019以降をインストール (.NET Framework 4.8開発ツールを含む)
2. ソリューションファイル `Source/StaxRip.sln` を開く
3. NuGetパッケージを復元
4. Release / x64構成でビルド

```powershell
# PowerShellでのビルド
cd Source
.\Build.ps1
```

## 開発

### コーディング規約

- 言語: VB.NET
- フレームワーク: .NET Framework 4.8
- Option Strict: On
- Option Explicit: On

### テスト

`Source/Forms/TestForm.vb`に内部テスト用コードがあります。

### スクリプト拡張

StaxRipはPowerShellスクリプトによる拡張をサポートしています。`Source/Scripts/`にサンプルスクリプトがあります。

### ビルドスクリプト

- `Build.ps1` - 通常ビルド
- `BuildAndPack.ps1` - ビルドとパッケージング
- `Release.ps1` - リリース作成

## ライセンス

MIT License

Copyright (C) 2002-2025 StaxRip Authors

詳細は[License.txt](../../License.txt)を参照してください。

## コミュニティ・サポート

- [GitHub Wiki](https://github.com/staxrip/staxrip/wiki) - ドキュメント
- [Discord](https://discord.gg/uz8pVR79Bd) - コミュニティチャット
- [VideoHelp Forum](https://forum.videohelp.com/threads/369913-StaxRip-support-thread)
- [Doom9 Forum](https://forum.doom9.org/showthread.php?t=172068)
