---
generated_at: 2026-01-21 16:08:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **ビルド手順のPowerShellコマンド詳細**：Build.ps1の内部動作は未検証
  2. **Windows 7機能制限の詳細範囲**：具体的な制限内容はREADME.mdからの引用のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクトルートの公式README
- E-02: `Source/StaxRip.vbproj` - プロジェクト定義ファイル
- E-03: `Source/packages.config` - NuGetパッケージ設定
- E-04: `License.txt` - ライセンスファイル
- E-05: `Source/Encoding/*.vb` - エンコーダー実装ファイル群
- E-06: `Source/Forms/*.vb` - フォーム実装ファイル群
- E-07: `Source/General/*.vb` - 共通クラス群
- E-08: `Source/FrameServer/*.cpp` - フレームサーバー実装
- E-09: `Source/UI/*.vb` - UI関連クラス群
- E-10: `Source/Video/*.vb` - ビデオ処理クラス群
- E-11: `Source/Scripts/` - PowerShellスクリプト例
- E-12: `Source/Build.ps1` - ビルドスクリプト
- E-13: `Source/Tools/AutoCrop/` - 自動クロップツール

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StaxRipはWindows向けのビデオ/オーディオエンコーディングGUI | E-01, E-02 | ○ |
| C-02 | x265、mkvmerge、ffmpegなどのコンソールアプリを制御 | E-01, E-05 | ○ |
| C-03 | AviSynth+およびVapourSynthフレームサーバーをサポート | E-08 | ○ |
| C-04 | .NET Framework 4.8を使用 | E-02 | ○ |
| C-05 | VB.NETで記述されている | E-02, E-05, E-06, E-07 | ○ |
| C-06 | x264エンコーダーをサポート | E-05 (x264Enc.vb) | ○ |
| C-07 | x265エンコーダーをサポート | E-05 (x265Enc.vb) | ○ |
| C-08 | SVT-AV1エンコーダーをサポート | E-05 (SvtAv1Enc.vb) | ○ |
| C-09 | NVEnc (NVIDIA)をサポート | E-05 (NVEnc.vb) | ○ |
| C-10 | QSVEnc (Intel)をサポート | E-05 (QSVEnc.vb) | ○ |
| C-11 | VCEEnc (AMD)をサポート | E-05 (VCEEnc.vb) | ○ |
| C-12 | AOM AV1エンコーダーをサポート | E-05 (AOMEnc.vb) | ○ |
| C-13 | rav1eエンコーダーをサポート | E-05 (Rav1e.vb) | ○ |
| C-14 | VVenCエンコーダーをサポート | E-05 (VvencffappEnc.vb) | ○ |
| C-15 | DirectN 1.5.0ライブラリを使用 | E-03 | ○ |
| C-16 | ManagedCuda 10.0.31ライブラリを使用 | E-03 | ○ |
| C-17 | PowerShell統合をサポート | E-03, E-11 | ○ |
| C-18 | MainForm.vbがメインウィンドウ | E-06 (MainForm.vb) | ○ |
| C-19 | PreviewForm.vbがプレビューウィンドウ | E-06 (PreviewForm.vb) | ○ |
| C-20 | ProcessingForm.vbが処理進捗ウィンドウ | E-06 (ProcessingForm.vb) | ○ |
| C-21 | GlobalClass.vbがグローバル設定管理 | E-07 (GlobalClass.vb) | ○ |
| C-22 | Theme.vbがテーマ管理 | E-09 (Theme.vb) | ○ |
| C-23 | MITライセンスで公開 | E-04 | ○ |
| C-24 | Build.ps1でビルド可能 | E-12 | ○ |
| C-25 | 自動クロップツールが存在 | E-13 | ○ |
| C-26 | ポータブルアプリケーションである | E-01 | ○ |
| C-27 | Build.ps1の具体的なビルド手順 | **根拠なし** | △ |
| C-28 | Windows 7の具体的な機能制限範囲 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Build.ps1の内部実装詳細を確認していない
  - 候補：Build.ps1の内容読み込み / ビルドドキュメント / 開発者ガイド
- Windows 7機能制限の詳細はオリジナルREADME.mdからの引用であり、コードレベルでの検証は行っていない
  - 候補：GlobalClass.vb / Native.vb / OS判定ロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロジェクト概要、技術スタック、ライセンス情報は信頼性が高い
- 0: 低リスク - エンコーダーサポート一覧はソースコードから直接確認
- 1: 中リスク - ビルド手順はスクリプトファイルの存在は確認したが、実行結果は未検証
- 0: 低リスク - ディレクトリ構成は実際のファイルシステムから取得

## 6) レビュアーチェックリスト（最小）
- [ ] ビルド手順が実際に動作することを確認
- [ ] Windows 7での機能制限が正確に記載されているか確認
- [ ] 各エンコーダーの対応バージョン情報が最新であるか確認
- [ ] 外部ツール連携の記載漏れがないか確認
- [ ] コミュニティリンクが有効であるか確認
