---
generated_at: 2026-01-21 19:55:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **グローバル変数パターンの `s` 変数**：ApplicationSettingsの具体的な定義ファイルの確認が必要
  2. **ジョブ処理フローの詳細**：JobManager.vbの具体的な処理フローの検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/StaxRip.vbproj` - プロジェクト設定ファイル
- E-02: `Source/StaxRip.sln` - ソリューションファイル
- E-03: `Source/General/GlobalClass.vb` - グローバルクラス定義
- E-04: `Source/General/Project.vb` - プロジェクトクラス定義
- E-05: `Source/Forms/MainForm.vb` - メインフォーム定義
- E-06: `Source/Encoding/VideoEncoder.vb` - エンコーダー基底クラス
- E-07: `Source/General/General.vb` - 共通クラス・ユーティリティ
- E-08: `Source/General/Audio.vb` - オーディオ処理クラス
- E-09: `Source/General/Demux.vb` - デマクサークラス
- E-10: `Source/General/Muxer.vb` - マクサークラス
- E-11: `Source/General/Macro.vb` - マクロ処理クラス
- E-12: `Source/General/Extensions.vb` - 拡張メソッド定義
- E-13: `Source/Video/VideoScript.vb` - ビデオスクリプト管理
- E-14: `Source/UI/Theme.vb` - テーマ定義
- E-15: `README.md` - プロジェクト説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StaxRipはVB.NET（Visual Basic .NET）で記述されたWindows Forms アプリケーション | E-01, E-02 | ○ |
| C-02 | .NET Framework 4.8をターゲット | E-01:39 `<TargetFrameworkVersion>v4.8</TargetFrameworkVersion>` | ○ |
| C-03 | 64ビットプラットフォーム向けにビルド | E-01:76 `<PlatformTarget>x64</PlatformTarget>` | ○ |
| C-04 | GlobalClassがグローバル状態を管理 | E-03:21-35 | ○ |
| C-05 | Projectクラスがプロジェクト設定を管理 | E-04:7-370 | ○ |
| C-06 | `p`はProjectのインスタンス | E-03, E-06:96-99での使用例 | ○ |
| C-07 | `g`はGlobalClassのインスタンス | E-03, E-07での使用例 | ○ |
| C-08 | `s`はApplicationSettingsのインスタンス | E-07での参照のみ、定義ファイル未確認 | △ |
| C-09 | SafeSerializationでオブジェクトを永続化 | E-07:294-431 | ○ |
| C-10 | VideoEncoderは抽象基底クラス | E-06:7-11 `Public MustInherit Class VideoEncoder` | ○ |
| C-11 | Encodeメソッドは派生クラスで実装必須 | E-06:12 `MustOverride Sub Encode()` | ○ |
| C-12 | Muxerは抽象基底クラス | E-10:11-12 `Public MustInherit Class Muxer` | ○ |
| C-13 | MainFormはFormBaseを継承 | E-05:18-19 | ○ |
| C-14 | 拡張メソッドがExtensions.vbに定義 | E-12:17-200 | ○ |
| C-15 | マクロ展開機能がMacro.vbに実装 | E-11:8-150 | ○ |
| C-16 | AudioクラスがProcess静的メソッドを持つ | E-08:8-69 | ○ |
| C-17 | DemuxerがRun抽象メソッドを持つ | E-09:7-8 `MustOverride Sub Run(proj As Project)` | ○ |
| C-18 | デマクサーのデフォルト実装がGetDefaults()で取得可能 | E-09:70-107 | ○ |
| C-19 | VideoScriptがAviSynth/VapourSynthのスクリプトを管理 | E-13:12-200 | ○ |
| C-20 | Themeクラスがテーマカラーを定義 | E-14:7-977 | ○ |
| C-21 | 各フォームに対応するテーマカラーが存在 | E-14:23-110 | ○ |
| C-22 | ControlsThemeColorsが各UI要素のテーマを定義 | E-14:129-789 | ○ |
| C-23 | プロジェクトがMITライセンス | E-15:43 | ○ |
| C-24 | Windows 7では一部機能が制限 | E-15:75-86 | ○ |
| C-25 | ポータブルアプリケーションとして動作 | E-15:90-98 | ○ |
| C-26 | Source/Controlsにエンコーダー固有UIコントロールが配置 | ディレクトリ構造確認 | ○ |
| C-27 | Source/Encodingにエンコーダー実装が配置 | ディレクトリ構造確認、E-06含む | ○ |
| C-28 | Source/Formsにウィンドウ定義が配置 | ディレクトリ構造確認、E-05含む | ○ |
| C-29 | Source/Generalにコアロジックが配置 | ディレクトリ構造確認 | ○ |
| C-30 | Source/UIに共通UIコンポーネントが配置 | ディレクトリ構造確認、E-14含む | ○ |
| C-31 | Source/Videoにビデオ処理関連が配置 | ディレクトリ構造確認、E-13含む | ○ |
| C-32 | x265、x264、NVEnc等のエンコーダーがサポートされている | E-01:198-209, Encoding/ディレクトリ内ファイル | ○ |
| C-33 | Procクラスで外部プロセスを実行 | E-08:107-116での使用例 | ○ |
| C-34 | Crop設定がProject.vbで管理 | E-04:233-275 | ○ |
| C-35 | 音声トラックがAudioTracksリストで管理 | E-04:21 `Public AudioTracks As New List(Of AudioTrack)` | ○ |
| C-36 | ソース情報（幅、高さ、フレームレート等）がProjectに保存 | E-04:119-136 | ○ |
| C-37 | ターゲット設定（幅、高さ、ビットレート等）がProjectに保存 | E-04:141-155 | ○ |
| C-38 | Sub MainがアプリケーションのエントリーポイントStartupObject | E-01:26 `<StartupObject>Sub Main</StartupObject>` | ○ |
| C-39 | DirectN、ManagedCudaの外部ライブラリを使用 | E-01:112-116 | ○ |
| C-40 | PowerShell連携機能が存在 | E-01:138-139 `System.Management.Automation` | ○ |
| C-41 | FilterがVideoScript.Filtersで管理 | E-13:22 `Property Filters As New List(Of VideoFilter)` | ○ |
| C-42 | AviSynthとVapourSynthの切り替えがEngineプロパティで管理 | E-13:24 `Overridable Property Engine As ScriptEngine` | ○ |
| C-43 | マクロが%xxx%形式で定義 | E-11:21-25 | ○ |
| C-44 | JobManagerがジョブキューを管理 | コード参照のみ、詳細実装未確認 | △ |
| C-45 | LogBuilderがログを管理 | E-04:97 `Public Log As New LogBuilder` | ○ |

## 4) 不足情報（Unknown / Missing）
- **ApplicationSettings (`s` 変数) の定義ファイル**
  - E-07およびE-01で参照されているが、ApplicationSettings.vbの詳細内容は未読
  - 候補：`Source/General/ApplicationSettings.vb`

- **JobManager.vbの詳細実装**
  - ジョブ処理フローの詳細が未確認
  - 候補：`Source/General/JobManager.vb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的なアーキテクチャ説明は正確
- **0: 低リスク** - VB.NET構文の説明は標準的で正確
- **1: 中リスク** - グローバル変数 `s` の説明は推測を含む可能性あり
- **0: 低リスク** - ディレクトリ構造の説明は実際の構造と一致
- **0: 低リスク** - コードサンプルは実際のソースから引用
- **1: 中リスク** - JobManager関連のフロー説明は詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] グローバル変数 `s` (ApplicationSettings) の定義を `Source/General/ApplicationSettings.vb` で確認
- [ ] JobManager.vbのジョブ処理フローが説明と一致するか確認
- [ ] コードサンプルの行番号が現行ソースと一致するか抜き打ち確認
- [ ] x265Enc.vb等の具体的なエンコーダー実装がパターン説明と一致するか確認
- [ ] 用語集の定義が公式ドキュメントと矛盾しないか確認
