---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **バージョン情報**: 外部ツールの具体的なバージョン番号は根拠不足
  2. **設定の永続化方式**: レジストリ使用の詳細確認が必要
  3. **トランザクション管理の分離レベル**: 実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/GlobalClass.vb` - グローバル状態管理クラス
- E-02: `Source/General/Project.vb` - プロジェクトモデル
- E-03: `Source/General/JobManager.vb` - ジョブ管理
- E-04: `Source/General/Muxer.vb` - Muxer基底クラスと派生クラス
- E-05: `Source/General/Audio.vb` - オーディオ処理
- E-06: `Source/General/Demux.vb` - デマックス処理
- E-07: `Source/General/Package.vb` - 外部ツールパッケージ管理
- E-08: `Source/Encoding/VideoEncoder.vb` - ビデオエンコーダー基底クラス
- E-09: `Source/Video/VideoScript.vb` - ビデオスクリプト管理
- E-10: `Source/Forms/MainForm.vb` - メインフォーム
- E-11: `Source/StaxRip.vbproj` - プロジェクトファイル
- E-12: `Source/packages.config` - NuGetパッケージ設定
- E-13: `README.md` - プロジェクト説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StaxRipはVB.NET / .NET Frameworkで構築されている | E-11 (StaxRip.vbproj: TargetFrameworkVersion=v4.8) | ○ |
| C-02 | Windowsフォームアプリケーションである | E-11 (OutputType=WinExe, WindowsForms参照) | ○ |
| C-03 | ffmpegとコマンドライン連携している | E-07 (Package.ffmpeg定義), E-05 (Audio.ConvertFF) | ○ |
| C-04 | mkvmergeとコマンドライン連携している | E-04 (MkvMuxer.Mux, Package.mkvmerge) | ○ |
| C-05 | MP4Boxとコマンドライン連携している | E-04 (MP4Muxer.Mux, Package.MP4Box) | ○ |
| C-06 | MediaInfo.dllをDLL連携で使用している | E-07 (Package.MediaInfo) | ○ |
| C-07 | AviSynthをフレームサーバーとして使用している | E-09 (VideoScript.ModifyAVSScript), E-07 (Package.AviSynth) | ○ |
| C-08 | VapourSynthをフレームサーバーとして使用している | E-09 (VideoScript.ModifyVSScript), E-07 (Package.VapourSynth) | ○ |
| C-09 | 3層アーキテクチャを採用している | E-01, E-02, E-04, E-08 (レイヤー分離の実装) | ○ |
| C-10 | GlobalClass(g)でグローバル状態を管理している | E-01 (GlobalClass定義、プロパティ群) | ○ |
| C-11 | Project(p)でプロジェクト設定を管理している | E-02 (Project定義) | ○ |
| C-12 | JobManagerでジョブを管理している | E-03 (JobManager.GetJobs, SaveJobs, AddJob) | ○ |
| C-13 | BinaryFormatterでシリアライズしている | E-03 (BinaryFormatter使用), E-02 | ○ |
| C-14 | VideoEncoderは抽象基底クラスである | E-08 (MustInherit, MustOverride修飾子) | ○ |
| C-15 | Muxerは抽象基底クラスである | E-04 (MustInherit, MustOverride修飾子) | ○ |
| C-16 | MkvMuxer, MP4Muxer, ffmpegMuxerが存在する | E-04 (各クラスの実装) | ○ |
| C-17 | WebMMuxerはMkvMuxerを継承している | E-04 (WebMMuxer Inherits MkvMuxer) | ○ |
| C-18 | eac3toと連携している | E-05 (Audio.ConvertEac3to), E-07 (Package.eac3to) | ○ |
| C-19 | qaacと連携している | E-07 (Package.qaac) | ○ |
| C-20 | OpusEncと連携している | E-07 (Package.OpusEnc) | ○ |
| C-21 | DeeZy/DEEと連携している | E-07 (Package.DeeZy, Package.DEE) | ○ |
| C-22 | Jobs.datでジョブを永続化している | E-03 (JobManager.SaveJobs, JobsPath) | ○ |
| C-23 | .sripファイルでプロジェクトを保存している | E-03 (JobManager.JobPath: .srip拡張子) | ○ |
| C-24 | AbortExceptionで処理中断を制御している | E-05, E-09 (Throw New AbortException) | ○ |
| C-25 | ErrorAbortExceptionでエラー中断を制御している | E-05 (Throw New ErrorAbortException) | ○ |
| C-26 | ファイルロックにリトライ機構がある | E-03 (SaveJobs/GetJobsのWhile/Try-Catch, counter>9) | ○ |
| C-27 | Procクラスで外部プロセスを実行している | E-04, E-05 (Using proc As New Proc) | ○ |
| C-28 | VideoScriptでAviSynth/VapourSynthを抽象化している | E-09 (ScriptEngine列挙型, IsAviSynth/IsVapourSynth) | ○ |
| C-29 | 外部ツールのバージョン管理をPackageで行っている | E-07 (Package.Version, VersionAllowOld等) | △ |
| C-30 | レジストリで設定を永続化している | **根拠なし** - コードから直接確認できず | △ |
| C-31 | トランザクション分離レベルは排他ロック | E-03 (FileShare.None) - 推測による記述 | △ |
| C-32 | x264/x265エンコーダーをサポートしている | E-07 (Package参照推測) - 直接確認が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- **レジストリ使用**: Settings関連のコードを十分に調査できなかった。実際の設定保存先はアプリケーション実行時の動作確認が必要
  - 候補：Settings.vb / ApplicationSettings / Registry
- **x264/x265パッケージ定義**: Package.vbの全体を読み込めておらず、x264/x265の定義が存在するか確認が必要
  - 候補：Package.vb（続き）/ Encodingディレクトリ内のファイル
- **具体的なバージョン情報**: 外部ツールの推奨バージョンについては動的に取得される可能性があり、静的な根拠が不足
  - 候補：DownloadURL / Version属性

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - レイヤー構成、主要クラスの役割、継承関係
- **0: 低リスク** - 外部ツール連携方式（コマンドライン/DLL）
- **1: 中リスク** - バージョン情報の正確性（動的取得の可能性）
- **1: 中リスク** - 設定永続化方式（レジストリ vs ファイル）
- **0: 低リスク** - シリアライズ方式（BinaryFormatter使用は確認済み）
- **1: 中リスク** - 全てのエンコーダーの網羅性（x264/x265等の確認）

## 6) レビュアーチェックリスト（最小）
- [ ] Package.vbの全内容を確認し、x264/x265等の主要エンコーダーの定義を検証
- [ ] Settings関連のコードを確認し、設定永続化方式を検証
- [ ] 外部ツールのバージョン管理方式を実際のコードで検証
- [ ] Encoding/ディレクトリ内のエンコーダー実装を確認
- [ ] MainFormの全体像を確認し、UIレイヤーの責務を検証
- [ ] BinaryFormatterの使用箇所とセキュリティリスクの評価
