# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "StaxRip Application"
        subgraph "Presentation Layer"
            MF[MainForm]
            PF[PreviewForm]
            JF[JobsForm]
            CF[CropForm]
            AF[AudioForm]
            CEd[CodeEditor]
            ProcF[ProcessingForm]
        end

        subgraph "Application Layer"
            GC[GlobalClass<br/>g]
            GCmd[GlobalCommands]
            JM[JobManager]
        end

        subgraph "Domain Layer"
            subgraph "Video Domain"
                VE[VideoEncoder]
                VS[VideoScript]
                VF[VideoFilter]
            end
            subgraph "Audio Domain"
                AU[Audio]
                AP[AudioProfile]
            end
            subgraph "Muxing Domain"
                MX[Muxer]
                MKV[MkvMuxer]
                MP4[MP4Muxer]
                FFM[ffmpegMuxer]
            end
            subgraph "Demuxing Domain"
                DM[Demuxer]
                MKDM[mkvDemuxer]
                FFDM[ffmpegDemuxer]
                MP4DM[MP4BoxDemuxer]
            end
            subgraph "Project"
                PJ[Project<br/>p]
                Job[Job]
            end
            subgraph "Package Management"
                PKG[Package]
                PPKG[PluginPackage]
            end
        end

        subgraph "Infrastructure Layer"
            Proc[Proc]
            MI[MediaInfo]
            FS[FrameServer]
            FH[FileHelp]
            Log[LogBuilder]
        end
    end

    subgraph "External Tools"
        FFMPEG[ffmpeg]
        X264[x264]
        X265[x265]
        MKVMRG[mkvmerge]
        MP4BOX[MP4Box]
        EAC3TO[eac3to]
        QAAC[qaac]
        OPUS[opusenc]
    end

    subgraph "Frame Servers"
        AVS[AviSynth]
        VPY[VapourSynth]
    end

    subgraph "Storage"
        SRIP[(.srip files)]
        JOBS[(Jobs.dat)]
        SETTINGS[(Settings)]
        INDEX[(Index Files)]
    end

    %% Presentation to Application
    MF --> GC
    MF --> GCmd
    JF --> JM
    ProcF --> GC

    %% Application to Domain
    GC --> PJ
    GC --> VE
    GC --> VS
    JM --> Job

    %% Domain relationships
    PJ --> VE
    PJ --> AP
    PJ --> VS
    VE --> MX
    VS --> VF
    AP --> AU
    MX --> MKV
    MX --> MP4
    MX --> FFM
    DM --> MKDM
    DM --> FFDM
    DM --> MP4DM
    PKG --> PPKG

    %% Domain to Infrastructure
    VE --> Proc
    MX --> Proc
    AU --> Proc
    DM --> Proc
    VS --> FS
    Proc --> MI
    Proc --> Log

    %% Infrastructure to External
    Proc --> FFMPEG
    Proc --> X264
    Proc --> X265
    Proc --> MKVMRG
    Proc --> MP4BOX
    Proc --> EAC3TO
    Proc --> QAAC
    Proc --> OPUS
    FS --> AVS
    FS --> VPY
    MI -.-> FFMPEG

    %% Storage
    PJ --> SRIP
    JM --> JOBS
    GC --> SETTINGS
    FS --> INDEX
```

## レイヤー構成図

```mermaid
graph TB
    subgraph "Presentation Layer"
        direction LR
        UI1[Windows Forms]
        UI2[Custom Controls]
        UI3[Dialogs]
    end

    subgraph "Application Layer"
        direction LR
        APP1[GlobalClass]
        APP2[GlobalCommands]
        APP3[JobManager]
    end

    subgraph "Domain Layer"
        direction LR
        DOM1[VideoEncoder]
        DOM2[AudioProfile]
        DOM3[Muxer]
        DOM4[Demuxer]
        DOM5[VideoScript]
        DOM6[Project]
        DOM7[Package]
    end

    subgraph "Infrastructure Layer"
        direction LR
        INF1[Proc]
        INF2[MediaInfo]
        INF3[FrameServer]
        INF4[FileHelp]
    end

    UI1 --> APP1
    UI2 --> APP1
    UI3 --> APP1

    APP1 --> DOM1
    APP1 --> DOM2
    APP1 --> DOM6
    APP2 --> DOM1
    APP3 --> DOM6

    DOM1 --> INF1
    DOM2 --> INF1
    DOM3 --> INF1
    DOM4 --> INF1
    DOM5 --> INF3
    DOM7 --> INF4
```

## データフロー図

### エンコーディング処理フロー

```mermaid
sequenceDiagram
    participant User
    participant MainForm
    participant GlobalClass
    participant ProcessingForm
    participant Demuxer
    participant Audio
    participant VideoEncoder
    participant Muxer
    participant Proc
    participant ExternalTool

    User->>MainForm: Start Encoding
    MainForm->>GlobalClass: Init Processing
    GlobalClass->>ProcessingForm: Show Progress

    rect rgb(200, 230, 200)
        Note over Demuxer,Proc: Demuxing Phase
        ProcessingForm->>Demuxer: Demux()
        Demuxer->>Proc: Execute Command
        Proc->>ExternalTool: ffmpeg/mkvmerge
        ExternalTool-->>Proc: Output
        Proc-->>Demuxer: Result
    end

    rect rgb(200, 200, 230)
        Note over Audio,Proc: Audio Processing Phase
        ProcessingForm->>Audio: Process()
        Audio->>Proc: Execute Command
        Proc->>ExternalTool: ffmpeg/eac3to/qaac
        ExternalTool-->>Proc: Output
        Proc-->>Audio: Result
    end

    rect rgb(230, 200, 200)
        Note over VideoEncoder,Proc: Video Encoding Phase
        ProcessingForm->>VideoEncoder: Encode()
        VideoEncoder->>Proc: Execute Command
        Proc->>ExternalTool: x264/x265/ffmpeg
        ExternalTool-->>Proc: Output
        Proc-->>VideoEncoder: Result
    end

    rect rgb(230, 230, 200)
        Note over Muxer,Proc: Muxing Phase
        ProcessingForm->>Muxer: Mux()
        Muxer->>Proc: Execute Command
        Proc->>ExternalTool: mkvmerge/MP4Box
        ExternalTool-->>Proc: Output
        Proc-->>Muxer: Result
    end

    ProcessingForm-->>MainForm: Complete
    MainForm-->>User: Done
```

### ソースファイル読み込みフロー

```mermaid
sequenceDiagram
    participant User
    participant MainForm
    participant Project
    participant MediaInfo
    participant VideoScript
    participant FrameServer

    User->>MainForm: Open Source File
    MainForm->>Project: Set SourceFile
    Project->>MediaInfo: GetSummary()
    MediaInfo-->>Project: File Info

    MainForm->>VideoScript: Generate Source Filter
    VideoScript->>VideoScript: Detect Engine (AVS/VS)
    VideoScript->>FrameServer: Synchronize()
    FrameServer-->>VideoScript: ServerInfo

    VideoScript-->>MainForm: Script Ready
    MainForm->>FrameServer: Get Preview Frame
    FrameServer-->>MainForm: Frame Data
    MainForm-->>User: Display Preview
```

## コンポーネント依存関係図

```mermaid
graph LR
    subgraph "Core Components"
        Project
        GlobalClass
    end

    subgraph "Video Processing"
        VideoEncoder
        VideoScript
        VideoFilter
    end

    subgraph "Audio Processing"
        Audio
        AudioProfile
    end

    subgraph "Container Processing"
        Muxer
        Demuxer
    end

    subgraph "External Interface"
        Package
        Proc
        MediaInfo
    end

    Project --> VideoEncoder
    Project --> VideoScript
    Project --> AudioProfile
    Project --> Muxer
    Project --> Demuxer

    GlobalClass --> Project
    GlobalClass --> Package

    VideoEncoder --> Proc
    VideoEncoder --> Muxer
    VideoScript --> VideoFilter

    Audio --> Proc
    Audio --> AudioProfile

    Muxer --> Proc
    Demuxer --> Proc

    Package --> Proc
    Proc --> MediaInfo
```

## 継承関係図

### VideoEncoder階層

```mermaid
classDiagram
    class Profile {
        <<abstract>>
        +Name: String
        +Edit(): DialogResult
    }

    class VideoEncoder {
        <<abstract>>
        +Encode()
        +Codec: String
        +OutputExt: String
        +Muxer: Muxer
    }

    class BasicVideoEncoder {
        +GetCommandLine()
    }

    class NullEncoder {
        +Encode()
    }

    class x264Enc {
        +Encode()
    }

    class x265Enc {
        +Encode()
    }

    class ffmpegEnc {
        +Encode()
    }

    Profile <|-- VideoEncoder
    VideoEncoder <|-- BasicVideoEncoder
    VideoEncoder <|-- NullEncoder
    BasicVideoEncoder <|-- x264Enc
    BasicVideoEncoder <|-- x265Enc
    BasicVideoEncoder <|-- ffmpegEnc
```

### Muxer階層

```mermaid
classDiagram
    class Muxer {
        <<abstract>>
        +Mux()
        +OutputExt: String
        +Subtitles: List~Subtitle~
    }

    class MkvMuxer {
        +Mux()
        +GetArgs(): String
    }

    class MP4Muxer {
        +Mux()
        +GetArgs(): String
    }

    class WebMMuxer {
        +Mux()
    }

    class ffmpegMuxer {
        +Mux()
        +OutputFormat: String
    }

    class NullMuxer {
        +Mux()
    }

    class BatchMuxer {
        +Mux()
        +CommandLines: String
    }

    Profile <|-- Muxer
    Muxer <|-- MkvMuxer
    Muxer <|-- MP4Muxer
    Muxer <|-- ffmpegMuxer
    Muxer <|-- NullMuxer
    Muxer <|-- BatchMuxer
    MkvMuxer <|-- WebMMuxer
```

### AudioProfile階層

```mermaid
classDiagram
    class AudioProfile {
        <<abstract>>
        +File: String
        +Language: Language
        +Delay: Integer
    }

    class GUIAudioProfile {
        +Params: Parameters
        +GetEncoder(): GuiAudioEncoder
    }

    class MuxAudioProfile {
        +ExtractDTSCore: Boolean
    }

    class NullAudioProfile {
    }

    Profile <|-- AudioProfile
    AudioProfile <|-- GUIAudioProfile
    AudioProfile <|-- MuxAudioProfile
    AudioProfile <|-- NullAudioProfile
```

## パッケージ構成図

```mermaid
graph TB
    subgraph "Source Directory"
        subgraph "Forms"
            F1[MainForm.vb]
            F2[PreviewForm.vb]
            F3[ProcessingForm.vb]
            F4[JobsForm.vb]
            F5[Other Forms...]
        end

        subgraph "General"
            G1[GlobalClass.vb]
            G2[GlobalCommands.vb]
            G3[Project.vb]
            G4[JobManager.vb]
            G5[Audio.vb]
            G6[AudioProfile.vb]
            G7[Muxer.vb]
            G8[Demux.vb]
            G9[Package.vb]
            G10[Macro.vb]
        end

        subgraph "Encoding"
            E1[VideoEncoder.vb]
            E2[VideoEncoderCommandLine.vb]
        end

        subgraph "Video"
            V1[VideoScript.vb]
            V2[FrameServer.vb]
            V3[VideoRenderer.vb]
        end

        subgraph "UI"
            U1[Controls/]
            U2[Theme.vb]
            U3[Menu.vb]
            U4[Criteria/]
        end

        subgraph "Tools"
            T1[AutoCrop/]
        end
    end

    F1 --> G1
    F1 --> G2
    F3 --> G1
    F4 --> G4

    G1 --> G3
    G3 --> E1
    G3 --> V1
    G3 --> G6
    G3 --> G7
    G3 --> G8

    E1 --> G7
    V1 --> V2
    G5 --> G6

    G9 --> G1
```
