---
generated_at: 2026-01-21 20:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **メモリ要件（8GB/16GB推奨）**：具体的な根拠なし、推定値
  2. **AVX512対応による効率化の程度**：定性的記述のみ
  3. **一時ファイル使用量**：具体的なサイズ記述なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルート）
- E-02: `Source/StaxRip.vbproj`（プロジェクト設定）
- E-03: `Source/StaxRip.sln`（ソリューションファイル）
- E-04: `Source/app.config`（アプリケーション設定）
- E-05: `Source/packages.config`（NuGetパッケージ設定）
- E-06: `Source/My Project/app.manifest`（アプリケーションマニフェスト）
- E-07: `Docs/Introduction/System-Requirements.md`（システム要件）
- E-08: `Docs/Introduction/Installation.md`（インストール手順）
- E-09: `Docs/Introduction/Features.md`（機能一覧）
- E-10: `Source/General/Package.vb`（パッケージ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Framework 4.8をターゲットとしている | E-02, E-04 | ○ |
| C-02 | Windows 64-bit版のみサポート | E-07, E-02 | ○ |
| C-03 | Windows 7は部分的サポート | E-07, E-08 | ○ |
| C-04 | Windows 8以降を推奨 | E-06, E-07 | ○ |
| C-05 | ポータブルアプリケーションである | E-01, E-08 | ○ |
| C-06 | AviSynth+をポータブル同梱 | E-08, E-09 | ○ |
| C-07 | VapourSynthをポータブル同梱 | E-08, E-09 | ○ |
| C-08 | Pythonをポータブル同梱 | E-08 | ○ |
| C-09 | 200以上のツールを同梱 | E-09 | ○ |
| C-10 | NuGetパッケージとしてDirectN使用 | E-05 | ○ |
| C-11 | NuGetパッケージとしてManagedCuda使用 | E-05 | ○ |
| C-12 | PowerShell参照を使用 | E-05 | ○ |
| C-13 | マルチインスタンス並列処理対応 | E-09 | ○ |
| C-14 | 並列オーディオ/ビデオエンコード対応 | E-09 | ○ |
| C-15 | チャンクエンコード対応 | E-09 | ○ |
| C-16 | NVEncC対応（NVIDIAハードウェアエンコード） | E-09, E-10 | ○ |
| C-17 | QSVEncC対応（Intelハードウェアエンコード） | E-09, E-10 | ○ |
| C-18 | VCEEncC対応（AMDハードウェアエンコード） | E-09, E-10 | ○ |
| C-19 | Visual C++ Redistributable必要 | E-07 | ○ |
| C-20 | AVX2対応CPUを推奨 | E-07 | ○ |
| C-21 | 非AVX2 CPUでも動作可能 | E-07 | ○ |
| C-22 | GitHubから更新確認可能 | E-01 | ○ |
| C-23 | メモリ8GB以上推奨 | **根拠なし** | △ |
| C-24 | AVX512対応で効率向上 | E-07（定性的のみ） | △ |
| C-25 | 一時ファイルで大容量使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **メモリ要件の具体値**
  - 公式ドキュメントにメモリ要件の記載なし
  - 候補：ユーザーコミュニティの推奨値 / 実測値 / 開発者による推奨

- **ストレージ使用量の詳細**
  - 動画処理時の一時ファイルサイズに関する記述なし
  - 候補：ベンチマーク実施 / ユーザー報告 / コード内定数確認

- **AVX512効率向上の定量評価**
  - System-Requirements.mdでは「効率的」「高速化」と記述されるのみ
  - 候補：ベンチマーク結果 / エンコーダー公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**
  - C-01〜C-22: コードや公式ドキュメントから直接確認可能

- **1: 中リスク**
  - C-24（AVX512効率向上）: 定性的記述のため、具体的な数値は要確認

- **2: 高リスク**
  - C-23（メモリ要件）: 推定値のため、実環境テストでの検証推奨
  - C-25（一時ファイル使用量）: 具体的なサイズ推定なし

## 6) レビュアーチェックリスト（最小）
- [ ] Windows 7部分サポートの制限事項が最新リリースと一致しているか確認
- [ ] メモリ要件（8GB/16GB推奨）が実際の運用で妥当か確認
- [ ] 組み込みツールの数（200+）が現行バージョンで正確か確認
- [ ] ハードウェアエンコーダー（NVEnc, QSVEnc, VCEEnc）の対応コーデック一覧が最新か確認
- [ ] .NET Framework 4.8.1（設計書記載）vs 4.8（コード内設定）の差異確認
- [ ] 一時ファイル使用量に関する情報補完の要否検討
