# インフラ構成図

## 概要

StaxRipはWindowsローカル環境で動作するデスクトップアプリケーションであり、従来のクラウドインフラ構成とは異なります。本文書では、アプリケーションのコンポーネント構成とデータフローを図示します。

## 全体アーキテクチャ

```mermaid
graph TB
    subgraph UserPC["ユーザーPC（Windows 64-bit）"]
        subgraph Runtime["ランタイム環境"]
            DOTNET[".NET Framework 4.8.1"]
            VCPP["Visual C++ Redistributable"]
        end

        subgraph StaxRipApp["StaxRip アプリケーション"]
            MainApp["StaxRip.exe<br/>（VB.NET WinForms）"]
            FrameServer["FrameServer.dll<br/>（C++/CLI）"]
        end

        subgraph FrameServerEnv["フレームサーバー環境"]
            AviSynth["AviSynth+<br/>（ポータブル版）"]
            VapourSynth["VapourSynth<br/>（ポータブル版）"]
            Python["Python<br/>（ポータブル版）"]
        end

        subgraph Tools["組み込みツール群（200+）"]
            subgraph Encoders["エンコーダー"]
                x264["x264"]
                x265["x265"]
                ffmpeg["ffmpeg"]
                NVEnc["NVEncC"]
                QSVEnc["QSVEncC"]
                VCEEnc["VCEEncC"]
                SVTAv1["SVT-AV1"]
            end

            subgraph AudioEncoders["オーディオエンコーダー"]
                eac3to["eac3to"]
                qaac["qaac"]
                opusenc["opusenc"]
            end

            subgraph Muxers["マルチプレクサ"]
                mkvmerge["mkvmerge"]
                MP4Box["MP4Box"]
            end

            subgraph Plugins["フィルタプラグイン"]
                AVSPlugins["AviSynth+ Plugins"]
                VSPlugins["VapourSynth Plugins"]
            end
        end

        subgraph Storage["ストレージ"]
            Settings["設定ファイル"]
            Projects["プロジェクトファイル"]
            TempFiles["一時ファイル"]
            Output["出力ファイル"]
        end

        subgraph HW["ハードウェア"]
            CPU["CPU"]
            GPU["GPU（オプション）"]
            Disk["ディスク"]
        end
    end

    subgraph External["外部サービス"]
        GitHub["GitHub<br/>（更新確認）"]
        ToolSites["ツール配布サイト"]
    end

    MainApp --> DOTNET
    MainApp --> FrameServer
    FrameServer --> AviSynth
    FrameServer --> VapourSynth
    VapourSynth --> Python
    AviSynth --> AVSPlugins
    VapourSynth --> VSPlugins

    MainApp --> Encoders
    MainApp --> AudioEncoders
    MainApp --> Muxers

    Encoders --> CPU
    NVEnc --> GPU
    QSVEnc --> GPU
    VCEEnc --> GPU

    MainApp --> Settings
    MainApp --> Projects
    Tools --> TempFiles
    Muxers --> Output

    MainApp -.->|HTTPS| GitHub
    MainApp -.->|HTTPS| ToolSites
```

## コンポーネント依存関係

```mermaid
graph LR
    subgraph Core["コア"]
        StaxRip["StaxRip.exe"]
        FS["FrameServer.dll"]
    end

    subgraph Dependencies["依存関係"]
        NET[".NET Framework 4.8.1"]
        DirectN["DirectN.dll"]
        ManagedCuda["ManagedCuda.dll"]
        PowerShell["PowerShell 5"]
    end

    subgraph FrameServers["フレームサーバー"]
        AVS["AviSynth+"]
        VS["VapourSynth"]
        PY["Python"]
    end

    StaxRip --> NET
    StaxRip --> DirectN
    StaxRip --> ManagedCuda
    StaxRip --> PowerShell
    StaxRip --> FS
    FS --> AVS
    FS --> VS
    VS --> PY
```

## データフロー

```mermaid
flowchart LR
    subgraph Input["入力"]
        SrcVideo["ソース動画<br/>（MKV, MP4, AVI等）"]
        SrcAudio["ソース音声"]
        SrcSub["字幕ファイル"]
    end

    subgraph Demux["デマックス処理"]
        mkvextract["mkvextract"]
        MP4Box_D["MP4Box"]
        ffmpeg_D["ffmpeg"]
        eac3to_D["eac3to"]
    end

    subgraph Process["動画処理"]
        FrameServer["フレームサーバー<br/>（AVS/VS）"]
        Filters["フィルタ処理<br/>（リサイズ、デインターレース等）"]
    end

    subgraph Encode["エンコード処理"]
        VidEnc["ビデオエンコーダー"]
        AudEnc["オーディオエンコーダー"]
    end

    subgraph Mux["マックス処理"]
        Muxer["マルチプレクサ<br/>（mkvmerge/MP4Box）"]
    end

    subgraph Output["出力"]
        OutputFile["出力ファイル<br/>（MKV, MP4）"]
    end

    SrcVideo --> Demux
    SrcAudio --> Demux
    Demux --> FrameServer
    FrameServer --> Filters
    Filters --> VidEnc
    Demux --> AudEnc
    VidEnc --> Muxer
    AudEnc --> Muxer
    SrcSub --> Muxer
    Muxer --> OutputFile
```

## ハードウェアエンコード構成

```mermaid
graph TB
    subgraph Software["ソフトウェアエンコード"]
        x264_SW["x264"]
        x265_SW["x265"]
        ffmpeg_SW["ffmpeg"]
        SVTAv1_SW["SVT-AV1"]
        AomEnc_SW["AomEnc"]
    end

    subgraph Hardware["ハードウェアエンコード"]
        subgraph NVIDIA["NVIDIA"]
            NVEnc_HW["NVEncC"]
            NVENC["NVENC<br/>（GPUエンコーダー）"]
        end

        subgraph Intel["Intel"]
            QSVEnc_HW["QSVEncC"]
            QSV["Quick Sync Video<br/>（CPU内蔵）"]
        end

        subgraph AMD["AMD"]
            VCEEnc_HW["VCEEncC"]
            VCE["Video Coding Engine<br/>（GPUエンコーダー）"]
        end
    end

    subgraph Codecs["サポートコーデック"]
        H264["H.264/AVC"]
        H265["H.265/HEVC"]
        AV1["AV1"]
        VP9["VP9"]
    end

    NVEnc_HW --> NVENC
    QSVEnc_HW --> QSV
    VCEEnc_HW --> VCE

    x264_SW --> H264
    x265_SW --> H265
    SVTAv1_SW --> AV1
    NVENC --> H264
    NVENC --> H265
    NVENC --> AV1
    QSV --> H264
    QSV --> H265
    QSV --> AV1
    VCE --> H264
    VCE --> H265
    VCE --> AV1
```

## ディレクトリ構成

```mermaid
graph TB
    Root["StaxRip/"]

    Root --> Exe["StaxRip.exe"]
    Root --> License["License.txt"]
    Root --> Settings["Settings/"]
    Root --> Apps["Apps/"]
    Root --> Encoders["Encoders/"]
    Root --> FrameServerDir["FrameServer/"]
    Root --> Audio["Audio/"]
    Root --> Support["Support/"]

    Apps --> Icons["Icons/"]
    Apps --> ToolsDir["各種ツール"]

    Encoders --> ffmpegDir["ffmpeg/"]
    Encoders --> x264Dir["x264/"]
    Encoders --> x265Dir["x265/"]
    Encoders --> OtherEnc["その他"]

    FrameServerDir --> AviSynthDir["AviSynth/"]
    FrameServerDir --> VapourSynthDir["VapourSynth/"]

    AviSynthDir --> AVSPluginsDir["plugins/"]
    VapourSynthDir --> VSPluginsDir["plugins/"]
    VapourSynthDir --> PythonDir["Python/"]

    Audio --> OpusDir["Opus/"]
    Audio --> DEEDir["DEE/"]
    Audio --> OtherAudio["その他"]

    Support --> DGMpgDec["DgMpgDec/"]
    Support --> MKVToolNix["MKVToolNix/"]
    Support --> OtherSupport["その他"]
```

## ネットワーク通信図

```mermaid
sequenceDiagram
    participant App as StaxRip
    participant GH as GitHub API
    participant Tools as ツール配布サイト
    participant Help as ヘルプサイト

    Note over App: アプリケーション起動

    App->>GH: 更新確認リクエスト（HTTPS）
    GH-->>App: 最新バージョン情報

    opt 更新あり
        App->>GH: 更新ファイルダウンロード
        GH-->>App: リリースファイル
    end

    opt ツール更新
        App->>Tools: ツールダウンロードリクエスト
        Tools-->>App: ツールファイル
    end

    opt ヘルプ表示
        App->>Help: ヘルプページリクエスト
        Help-->>App: ドキュメント表示
    end
```

## 並列処理アーキテクチャ

```mermaid
graph TB
    subgraph MultiInstance["マルチインスタンス実行"]
        Instance1["StaxRip Instance 1"]
        Instance2["StaxRip Instance 2"]
        Instance3["StaxRip Instance N"]
    end

    subgraph JobQueue["ジョブキュー"]
        Job1["Job 1"]
        Job2["Job 2"]
        Job3["Job 3"]
        Job4["Job N"]
    end

    subgraph ParallelEncode["並列エンコード（1インスタンス内）"]
        Video["ビデオトラック"]
        Audio1["オーディオトラック 1"]
        Audio2["オーディオトラック 2"]
        AudioN["オーディオトラック N"]
    end

    subgraph ChunkEncode["チャンクエンコード"]
        Chunk1["Chunk 1"]
        Chunk2["Chunk 2"]
        Chunk3["Chunk 3"]
        ChunkN["Chunk N"]
    end

    JobQueue --> Instance1
    JobQueue --> Instance2
    JobQueue --> Instance3

    Instance1 --> Video
    Instance1 --> Audio1
    Instance1 --> Audio2
    Instance1 --> AudioN

    Video --> ChunkEncode
```
