# インフラ設計書

## 概要

本ドキュメントは、StaxRip（Windows向けビデオ/オーディオエンコーディングGUIアプリケーション）の実行環境に関するインフラ設計書です。StaxRipはクラウドベースのシステムではなく、ユーザーのローカルWindows環境上で動作するポータブルなデスクトップアプリケーションであるため、従来のサーバーインフラストラクチャではなく、クライアント実行環境としての設計を記述します。

## システム構成

### 全体構成

StaxRipは、Windowsデスクトップ上で動作するスタンドアロンアプリケーションです。以下の構成で実行されます：

1. **メインアプリケーション**: StaxRip.exe（.NET Framework 4.8ベース）
2. **ネイティブコンポーネント**: FrameServer（C++/CLI）
3. **組み込みツール群**: 200以上のコンソールツール・プラグイン
4. **フレームサーバー**: AviSynth+、VapourSynth（ポータブル版同梱）
5. **Python**: VapourSynth用（ポータブル版同梱）

### サーバー構成

本アプリケーションはクライアントサイドで完結するため、従来のサーバー構成は存在しません。代わりに、ユーザーのローカルマシン要件を記載します。

| 構成要素 | 役割 | スペック要件 | 備考 |
| --- | --- | --- | --- |
| ユーザーPC（必須） | アプリケーション実行 | Windows 8以降（64-bit）、.NET Framework 4.8.1 | Windows 7は部分的サポート |
| CPU | エンコード処理 | AVX2対応推奨、AVX512対応で高速化 | 非AVX2 CPUも回避策あり |
| GPU（オプション） | ハードウェアエンコード | NVIDIA/AMD/Intel対応GPU | NVEncC、QSVEncC、VCEEncC使用時必要 |
| メモリ | 動画処理 | 8GB以上推奨 | 大容量動画処理時は16GB以上推奨 |
| ストレージ | 一時ファイル・出力 | SSD推奨、十分な空き容量 | 動画処理により大容量使用 |

### ネットワーク構成

StaxRipは基本的にオフラインで動作しますが、以下の機能でネットワークを使用します：

| 機能 | 通信先 | 用途 | プロトコル |
| --- | --- | --- | --- |
| 自動更新チェック | GitHub | アプリケーション更新確認 | HTTPS |
| ツール更新 | 各ツール配布サイト | 組み込みツールの更新 | HTTPS |
| オンラインヘルプ | 各ドキュメントサイト | ヘルプページ表示 | HTTPS |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| .NET Framework | 4.8.1 | メインアプリケーション実行基盤 |
| Microsoft Visual C++ Redistributable | 最新版推奨 | 各種ツール・プラグイン実行 |
| AviSynth+ | 同梱版 | フレームサーバー（動画スクリプト処理） |
| VapourSynth | 同梱版 | フレームサーバー（動画スクリプト処理） |
| Python | 同梱版（3.x系） | VapourSynth実行環境 |
| DirectX | システム同梱 | GPU支援、プレビュー機能 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | アプリケーション配布・更新確認 | HTTPS REST API |
| Discord | コミュニティサポート（任意） | Webブラウザ経由 |

## スケーリング設計

本アプリケーションはローカル実行型であるため、従来のサーバースケーリングは適用されません。代わりに、以下のパフォーマンス最適化機能を提供します：

### 並列処理機能

1. **マルチインスタンス実行**: 複数のStaxRipインスタンスを同時実行し、ジョブリストを並列処理可能
2. **並列エンコード**: ビデオトラックと複数オーディオトラックを並列処理
3. **チャンクエンコード**: 大容量動画を分割して並列エンコード

### ハードウェアアクセラレーション

| 機能 | 対応ハードウェア | ツール |
| --- | --- | --- |
| NVIDIA GPU エンコード | NVIDIA GPU（NVENC対応） | NVEncC |
| Intel GPU エンコード | Intel CPU内蔵GPU（QSV対応） | QSVEncC |
| AMD GPU エンコード | AMD GPU（VCE対応） | VCEEncC |

## 可用性設計

### ポータブル設計

StaxRipはポータブルアプリケーションとして設計されており、以下の特徴を持ちます：

1. **インストール不要**: 7z形式で配布、展開のみで使用可能
2. **設定の独立性**: 各バージョンの設定は独立して保持可能
3. **依存関係の同梱**: AviSynth+、VapourSynth、Pythonを同梱

### プロジェクト自動保存

- エンコーディング設定はソースファイルごとに自動保存
- 以前のプロジェクトは「Recent」メニューから復元可能
- エンコード済みの音声・動画は再利用可能

### フェイルオーバー

- 処理失敗時のログファイル出力
- 専用ログビューアで処理ステップを確認可能
- アシスタント機能による操作ガイダンス

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| 設定ファイル | ユーザー手動バックアップ | 任意 | ユーザー管理 |
| プロジェクトファイル | 自動保存 | 都度 | 明示的削除まで |
| 出力ファイル | ユーザー管理 | N/A | ユーザー管理 |

## 監視設計

本アプリケーションはローカル実行型のため、サーバー監視は不要です。以下のユーザー向け監視機能を提供します：

### ログ機能

- 詳細なログファイル出力（処理ステップごと）
- 専用ログビューアによるナビゲーション
- エラー発生時の原因特定支援

### 処理状況表示

- 処理ウィンドウのシステムトレイ最小化対応
- リアルタイム進捗表示
- 推定残り時間表示

## ディレクトリ構成

```
StaxRip/
├── StaxRip.exe              # メインアプリケーション
├── Settings/                # 設定ファイル格納
├── Apps/                    # 組み込みツール群
│   ├── Icons/              # アプリケーションアイコン
│   └── ...                 # 各種ツール
├── Encoders/               # エンコーダー群
│   ├── ffmpeg/             # ffmpeg/ffprobe
│   └── ...                 # その他エンコーダー
├── FrameServer/            # フレームサーバー関連
│   ├── AviSynth/           # AviSynth+
│   └── VapourSynth/        # VapourSynth
├── Audio/                  # オーディオツール
├── Support/                # サポートツール
└── License.txt             # ライセンスファイル
```

## 動作要件サマリー

### 必須要件

| 項目 | 要件 |
| --- | --- |
| OS | Windows 8以降（64-bit）※Windows 11推奨 |
| .NET Framework | 4.8.1以上 |
| Visual C++ ランタイム | 最新版推奨 |
| 権限 | 実行フォルダへの書き込み権限 |

### 推奨環境

| 項目 | 推奨仕様 |
| --- | --- |
| CPU | AVX2対応プロセッサ（Intel 第4世代以降、AMD Zen以降） |
| メモリ | 16GB以上 |
| ストレージ | NVMe SSD、十分な空き容量 |
| GPU | NVIDIA RTX/GTX（ハードウェアエンコード使用時） |

## 備考

1. **Windows 7制限事項**:
   - Blu-ray ISOマウント機能は非対応
   - MKVToolNix v64.0以前が必要
   - VapourSynth R73以前が必要
   - Python 3.8.x以前が必要

2. **ハードウェアエンコード**:
   - GPU対応コーデックはハードウェア依存
   - 最新GPUドライバの使用を推奨

3. **パフォーマンス考慮事項**:
   - AVX512対応CPUではより効率的な処理が可能
   - 非AVX2 CPUでも動作可能（手動で旧ビルドに置換）
