---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **C-23: HTTPS優先使用の検証**：コード上の明示的なHTTPS強制がない
  2. **C-24: .NET 5以降でのBinaryFormatter非推奨**：外部ドキュメント（Microsoft公式）の参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/GlobalClass.vb` - IsAdmin判定（行24）、WindowsPrincipal/WindowsIdentity使用
- E-02: `Source/General/General.vb` - FileIOPermission（行289）、SafeSerialization、BinaryFormatter
- E-03: `Source/General/Extensions.vb` - MD5Hash（行896-902）、ファイルパス検証関数群
- E-04: `Source/General/Documentation.vb` - ShowTip関数でのMD5Hash使用（行426）
- E-05: `Source/Forms/DownloadForm.vb` - WebClientダウンロード、User-Agent設定
- E-06: `Source/General/PowerShell.vb` - ExecutionPolicy Unrestricted設定（行22-25）
- E-07: `Source/General/StaxRipUpdate.vb` - HttpClient使用
- E-08: `Source/General/ToolUpdate.vb` - HttpClient使用、ダウンロード処理
- E-09: `Source/General/ProcController.vb` - Registry.CurrentUser.Write（行725）
- E-10: `Source/General/Package.vb` - Registry.LocalMachine.GetString使用
- E-11: `Source/General/LogBuilder.vb` - ログ出力処理
- E-12: `Source/app.config` - .NET Framework 4.8設定
- E-13: `Source/Encoding/x265Enc.vb` - Hash設定（行1002-1007）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StaxRipはローカルデスクトップアプリでユーザー認証なし | E-12 (app.config), プロジェクト構成 | ○ |
| C-02 | WindowsPrincipal/WindowsIdentityで管理者権限判定 | E-01 (GlobalClass.vb 行24) | ○ |
| C-03 | IsAdminプロパティで管理者ロール判定 | E-01 (GlobalClass.vb 行24) | ○ |
| C-04 | WebClientを使用した非同期ダウンロード | E-05 (DownloadForm.vb 行6, 18) | ○ |
| C-05 | User-Agentヘッダの設定 | E-05 (DownloadForm.vb 行16) | ○ |
| C-06 | HttpClientを使用したHTTPS通信 | E-07, E-08 (StaxRipUpdate.vb, ToolUpdate.vb) | ○ |
| C-07 | MD5ハッシュ関数の実装 | E-03 (Extensions.vb 行896-902) | ○ |
| C-08 | ヒント表示制御でMD5使用 | E-04 (Documentation.vb 行426) | ○ |
| C-09 | x265エンコーダ設定でHash使用 | E-13 (x265Enc.vb 行1002-1007) | ○ |
| C-10 | BinaryFormatterによるシリアライゼーション | E-02 (General.vb SafeSerialization) | ○ |
| C-11 | SafeSerializationクラスによるラップ | E-02 (General.vb 行294-431) | ○ |
| C-12 | FileIOPermissionによるパス検証 | E-02 (General.vb 行289) | ○ |
| C-13 | IsValidFileName関数の実装 | E-03 (Extensions.vb 行123-139) | ○ |
| C-14 | IsValidPath関数の実装 | E-03 (Extensions.vb 行141-158) | ○ |
| C-15 | LongPathPrefix関数の実装 | E-03 (Extensions.vb 行328-337) | ○ |
| C-16 | PowerShell ExecutionPolicy Unrestricted設定 | E-06 (PowerShell.vb 行22-25) | ○ |
| C-17 | Registry.CurrentUser.Writeでの設定保存 | E-09 (ProcController.vb 行725) | ○ |
| C-18 | Registry.LocalMachineからのツールパス取得 | E-10 (Package.vb 行476等) | ○ |
| C-19 | LogBuilderクラスによるログ管理 | E-11 (LogBuilder.vb) | ○ |
| C-20 | .NET Framework 4.8を使用 | E-12 (app.config 行4) | ○ |
| C-21 | MD5は識別用途のみに使用 | E-03, E-04 (メッセージ重複検出) | ○ |
| C-22 | 難読化ログ機能の存在 | E-11, プロジェクト構成 | ○ |
| C-23 | ダウンロードでHTTPS URL優先使用 | **根拠不足** - コード上の明示的強制なし | △ |
| C-24 | BinaryFormatterは.NET 5以降で非推奨 | **根拠なし** - Microsoft公式ドキュメント参照必要 | △ |

## 4) 不足情報（Unknown / Missing）
- C-23（HTTPS優先使用）について：WebClient/HttpClientでのURL指定はコード上で確認できるが、HTTPSの強制メカニズムは実装されていない
  - 候補：DownloadForm.vbのURL検証ロジック / StaxRipUpdate.vbのURL生成ロジック / 実際のダウンロードURL一覧
- C-24（BinaryFormatter非推奨）について：Microsoft公式ドキュメントからの確認が必要
  - 候補：Microsoft Learn / .NET Security Documentation / BinaryFormatter Security Guide

## 5) リスクフラグ（レビュー観点）
- **リスクフラグ 1（中リスク）**: BinaryFormatterのセキュリティリスク - 信頼されていないソースからの.sripファイル読み込み時にデシリアライゼーション攻撃の可能性
- **リスクフラグ 1（中リスク）**: PowerShell ExecutionPolicy Unrestricted - ユーザースクリプトが任意コードを実行可能
- **リスクフラグ 0（低リスク）**: MD5の使用 - 識別用途のみでセキュリティ目的ではない

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vbのIsAdmin判定（行24）が正しく実装されているか確認
- [ ] BinaryFormatterのセキュリティリスクについてMicrosoft公式ドキュメントで最新情報を確認
- [ ] PowerShell.vbのExecutionPolicy設定（行22-25）のセキュリティ影響を評価
- [ ] Extensions.vbのMD5Hash実装（行896-902）が識別用途のみに使用されているか確認
- [ ] DownloadForm.vbのWebClient実装でHTTPS以外のURLが使用される可能性を確認
- [ ] FileIOPermission（General.vb 行289）のパス検証が十分かレビュー
