---
generated_at: 2026-01-21 19:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 14
  claims_without_evidence: 4
confidence_derived: 0.78
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.78**
  - 根拠あり：14 / 18、根拠なし：4
- 優先レビュー（高）
  1. **カバレッジ目標の推奨値**：根拠不足（業界標準に基づく推奨であり、プロジェクト固有の根拠なし）
  2. **テストデータ準備方針**：根拠不足（推奨事項であり、現状の実装根拠なし）
  3. **CI/CD パイプライン推奨構成**：根拠不足（推奨事項であり、現状未実装）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/StaxRip.vbproj` - プロジェクト構成、.NET Framework バージョン、ビルド設定
- E-02: `Source/StaxRip.sln` - ソリューション構成、Visual Studio バージョン
- E-03: `Source/General/Test.vb` - ConsolAppTester クラスの実装
- E-04: `Source/Forms/TestForm.vb` - TestForm の実装
- E-05: `Source/BuildAndPack.ps1` - ビルドスクリプト、MSBuild 実行設定
- E-06: `README.md` - プロジェクト概要、外部ツール依存情報
- E-07: `.github/ISSUE_TEMPLATE/bug_report.yml` - バグレポートテンプレート
- E-08: `.github/` ディレクトリ構造 - CI/CD ワークフロー未設定の確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VB.NET で開発されている | E-01, E-02 | ○ |
| C-02 | .NET Framework 4.8 を使用 | E-01 (TargetFrameworkVersion) | ○ |
| C-03 | Windows Forms アプリケーションである | E-01 (OutputType=WinExe, MyType) | ○ |
| C-04 | 正式なテストフレームワークは未導入 | E-01 (参照に NUnit/xUnit/MSTest なし) | ○ |
| C-05 | GitHub Actions ワークフローは未設定 | E-08 (workflows ディレクトリ不在) | ○ |
| C-06 | MSBuild でビルドを実行 | E-05 (MSBuild.exe 呼び出し) | ○ |
| C-07 | Visual Studio 2019 以降を使用 | E-02 (Visual Studio Version 16) | ○ |
| C-08 | ConsolAppTester クラスが存在する | E-03 | ○ |
| C-09 | TestForm が存在する | E-04 | ○ |
| C-10 | バグレポートテンプレートが存在する | E-07 | ○ |
| C-11 | 外部ツール（x265、ffmpeg 等）に依存する | E-06 | ○ |
| C-12 | CodeAnalysisRuleSet が設定されている | E-01 (MinimumRecommendedRules.ruleset) | ○ |
| C-13 | x64/x86 両プラットフォームのビルド設定がある | E-01, E-02 | ○ |
| C-14 | Discord コミュニティでフィードバック収集 | E-06 (Discord リンク) | ○ |
| C-15 | カバレッジ目標 70-80% を推奨 | **根拠なし** | △ |
| C-16 | テストデータの体系的管理方針 | **根拠なし** | △ |
| C-17 | 推奨 CI/CD パイプライン構成 | **根拠なし** | △ |
| C-18 | 自動テストフレームワーク導入を推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標の推奨値**: プロジェクト固有の要件定義や品質基準が不明。業界標準に基づく一般的な推奨値を記載。
  - 候補：品質要件定義書 / プロジェクト方針書 / ステークホルダーとの合意文書
- **テストデータ準備方針**: 現状のテストデータ管理状況が不明。推奨事項として記載。
  - 候補：既存テストデータ / テスト手順書 / 開発者ヒアリング
- **CI/CD パイプライン推奨構成**: 現状未実装のため、一般的なベストプラクティスに基づく推奨。
  - 候補：チームの CI/CD 方針 / インフラ制約 / リリースプロセス要件

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 推奨事項（C-15, C-16, C-17, C-18）はプロジェクトの現状に基づかない一般的な提案であり、実際の導入時には要件の詳細確認が必要
- **0: 低リスク** - プロジェクトの現状分析（C-01〜C-14）はソースコードに基づいており、高い信頼性を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] VB.NET プロジェクトであること、.NET Framework 4.8 であることを確認済み
- [ ] 自動テストフレームワーク未導入の現状認識が正しいか確認済み
- [ ] GitHub Actions 未設定の現状認識が正しいか確認済み
- [ ] ConsolAppTester、TestForm の機能説明が実際の実装と一致するか確認済み
- [ ] 推奨カバレッジ目標値（70-80%）がプロジェクトの品質要件に適切か検討済み
- [ ] 推奨 CI/CD パイプライン構成がチームのインフラ・運用方針に適合するか検討済み
- [ ] 外部ツール依存のテスト戦略が実運用に適切か確認済み
