# テスト方針書

## 概要

本ドキュメントは、StaxRip プロジェクトにおけるテスト方針を定義する。StaxRip は VB.NET で開発された Windows Forms ベースの動画/音声エンコーディング GUI アプリケーションであり、x265、mkvmerge、ffmpeg などの外部コンソールアプリケーションを制御し、AviSynth+ および VapourSynth を利用したビデオ処理を行う。

現状、本プロジェクトには正式な自動テストフレームワークが導入されていないため、本方針書では現状の把握と推奨されるテスト戦略を提示する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個別クラス・メソッドの動作検証（現状未実装） | 開発者 |
| 結合テスト | コンポーネント間連携の検証、外部ツール呼び出しの検証 | 開発者 |
| システムテスト | アプリケーション全体の動作検証、エンコード処理の E2E 検証 | 開発者・QA |
| 受入テスト | ユーザー要件の充足確認、Discord コミュニティでのフィードバック | ユーザー・コミュニティ |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | エンコード機能、フィルタ適用、Mux 処理等の機能検証 | 開発時・リリース前 |
| 性能テスト | エンコード処理時間、メモリ使用量の測定 | 必要に応じて |
| セキュリティテスト | 外部ツール実行時のパス検証、入力値の検証 | 必要に応じて |
| 回帰テスト | バグ修正後の再発防止確認 | バグ修正時 |
| 互換性テスト | Windows バージョン間の動作確認（Windows 7/8/10/11） | リリース前 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| 開発環境 | 開発者によるローカルテスト | Windows 10/11、Visual Studio 2019+、.NET Framework 4.8 |
| 手動テスト環境 | リリース前の機能確認 | Windows 10/11、各種外部ツール（x265、ffmpeg 等） |
| コミュニティテスト | ベータ版のユーザーテスト | Discord コミュニティでのフィードバック収集 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Visual Studio | デバッグ・手動テスト | 2019 以降（Visual Studio Version 16） |
| MSBuild | ビルド検証 | Visual Studio 付属 |
| ConsolAppTester | コマンドラインオプションの整合性検証（内部ツール） | 内蔵 |
| TestForm | 開発者向けテスト用 UI フォーム（内部ツール） | 内蔵 |

### 現状の内部テスト機能

プロジェクトには以下の内部テスト機能が存在する：

1. **ConsolAppTester クラス** (`Source/General/Test.vb`)
   - 外部ツールのコマンドラインスイッチの実装状況を検証
   - ドキュメント記載のスイッチと実装済みスイッチの差分を検出

2. **TestForm** (`Source/Forms/TestForm.vb`)
   - 開発者向けのテスト用 UI フォーム
   - 特定機能の手動テストに使用

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 未設定（自動テストフレームワーク未導入のため） |
| 分岐カバレッジ | 未設定（自動テストフレームワーク未導入のため） |

### 推奨カバレッジ目標（将来的な導入時）

| 対象 | 推奨目標値 |
| --- | --- |
| コアロジック（エンコード、Mux 処理） | 70% 以上 |
| ユーティリティクラス | 80% 以上 |
| UI コンポーネント | 50% 以上（手動テスト補完） |

## テストデータ

### 現状
- テストデータの体系的な管理は行われていない
- 開発者がローカル環境で用意した動画ファイルを使用

### 推奨される準備方針
1. **サンプル動画ファイル**: 各種フォーマット（MP4、MKV、AVI 等）、解像度（SD、HD、4K）のサンプルを準備
2. **エンコード設定プロファイル**: 代表的なエンコード設定のテンプレートを用意
3. **期待結果データ**: エンコード結果の MediaInfo 情報等を記録

## 不具合管理

### 現状の管理方法
- **GitHub Issues**: バグレポートのテンプレート（`bug_report.yml`）を使用
- **Discord コミュニティ**: ユーザーからのフィードバック収集
- **CHANGELOG.md**: 修正済みバグの記録

### バグレポートに必要な情報（Issue Template より）
1. StaxRip のバージョン
2. OS 環境
3. 再現手順
4. 期待される動作
5. 実際の動作
6. ログファイル（必要に応じて）

## CI/CD連携

### 現状
- GitHub Actions によるワークフローは未設定
- ビルドは `BuildAndPack.ps1` PowerShell スクリプトで手動実行
- MSBuild を使用した Release ビルドの実行

### 現状のビルドプロセス
```powershell
# BuildAndPack.ps1 の主要処理
MSBuild.exe StaxRip.sln -t:Rebuild -p:Configuration=Release -p:Platform=x64
```

### 推奨される CI/CD パイプライン構成

1. **ビルド検証**
   - プルリクエスト時の自動ビルド
   - x64/x86 両プラットフォームでのビルド確認

2. **静的解析**
   - CodeAnalysisRuleSet（MinimumRecommendedRules.ruleset）の活用
   - VB.NET コンパイラ警告のチェック

3. **自動テスト**（将来的な導入時）
   - 単体テストの自動実行
   - テストカバレッジレポートの生成

4. **リリース自動化**
   - タグ付与時の自動リリースビルド
   - 7z アーカイブの自動生成

## 備考

### 現状の課題と推奨事項

1. **自動テストフレームワークの導入**
   - MSTest、NUnit、または xUnit の導入を推奨
   - 特にコアロジック（エンコード設定、Mux 処理、外部ツール呼び出し）のテストを優先

2. **CI/CD パイプラインの構築**
   - GitHub Actions ワークフローの導入
   - プルリクエスト時の自動ビルド・テスト実行

3. **テストデータの整備**
   - サンプル動画ファイルのリポジトリ管理（または外部ストレージ参照）
   - エンコード結果の期待値定義

4. **回帰テストの体系化**
   - バグ修正時のテストケース追加
   - リリース前のチェックリスト整備

### プロジェクト特性を考慮したテスト戦略

StaxRip は以下の特性を持つため、テスト戦略には特別な考慮が必要：

1. **外部ツール依存**: x265、ffmpeg、mkvmerge 等の外部ツールとの連携テストが重要
2. **GUI アプリケーション**: UI テストの自動化は困難であり、手動テストとの併用が現実的
3. **多様な入力形式**: 様々な動画/音声フォーマットへの対応テストが必要
4. **プラットフォーム依存**: Windows 専用アプリケーションのため、複数 Windows バージョンでの検証が重要
