# ER図

## 概要

本ドキュメントは、StaxRipプロジェクトのデータエンティティ間の関連を示すER図です。StaxRipは従来のRDBを使用せず、オブジェクトシリアライゼーションによるデータ永続化を行っているため、本ER図はオブジェクト間の参照関係を表現しています。

## 全体ER図

```mermaid
erDiagram
    Project ||--o{ AudioTrack : contains
    Project ||--o{ AudioProfile : "contains (AudioFiles)"
    Project ||--o| VideoEncoder : has
    Project ||--o| TargetVideoScript : has
    Project ||--o| SourceVideoScript : has
    Project ||--o{ Range : has
    Project ||--o| LogBuilder : has

    AudioTrack ||--o| AudioProfile : references

    AudioProfile ||--o{ AudioStream : "contains (Streams)"
    AudioProfile ||--o| Language : has

    AudioStream ||--o| Language : has

    ApplicationSettings ||--o{ VideoEncoder : "contains (VideoEncoderProfiles)"
    ApplicationSettings ||--o{ AudioProfile : "contains (AudioProfiles)"
    ApplicationSettings ||--o{ Muxer : "contains (MuxerProfiles)"
    ApplicationSettings ||--o{ Demuxer : "contains (Demuxers)"
    ApplicationSettings ||--o{ FilterCategory : "contains (AviSynthProfiles)"
    ApplicationSettings ||--o{ FilterCategory : "contains (VapourSynthProfiles)"
    ApplicationSettings ||--o{ TargetVideoScript : "contains (FilterSetupProfiles)"
    ApplicationSettings ||--o{ EventCommand : "contains (EventCommands)"
    ApplicationSettings ||--o{ eac3toProfile : "contains (eac3toProfiles)"
    ApplicationSettings ||--o| ObjectStorage : has
    ApplicationSettings ||--o| WindowPositions : has
    ApplicationSettings ||--o{ CustomMenuItem : "contains (CustomMenus)"

    JobManager ||--o{ Job : manages

    EventCommand ||--o{ Criteria : "contains (CriteriaList)"
    EventCommand ||--o| CommandParameters : has

    Subtitle ||--o| Language : has

    VideoStream }o--|| Project : "extracted from"
    AudioStream }o--|| Project : "extracted from"
    Subtitle }o--|| Project : "extracted from"
    M2TSStream }o--|| Project : "extracted from"

    M2TSStream ||--o| Language : has
```

## エンティティ詳細ER図

### プロジェクト関連

```mermaid
erDiagram
    Project {
        String SourceFile
        String TargetFile
        String TempDir
        Integer SourceWidth
        Integer SourceHeight
        Integer TargetWidth
        Integer TargetHeight
        Decimal SourceFrameRate
        Double TargetFrameRate
        Integer SourceFrames
        Integer TargetFrames
        Integer VideoBitrate
        Boolean BitrateIsFixed
        Integer CropLeft
        Integer CropRight
        Integer CropTop
        Integer CropBottom
        String SourceVideoFormat
        String SourceVideoHdrFormat
        Boolean BatchMode
        Boolean NoDialogs
    }

    AudioTrack {
        Integer Index
        Boolean IsRelevant
    }

    AudioProfile {
        String Name
        String File
        Integer Delay
        String StreamName
        Single Gain
        Boolean Default
        Boolean Forced
        Integer Channels
        Double Bitrate
        String OutputFileType
    }

    VideoEncoder {
        String Name
        Boolean QualityMode
        Integer Bitrate
    }

    Range {
        Integer Start
        Integer End
    }

    Project ||--o{ AudioTrack : "AudioTracks"
    Project ||--o{ AudioProfile : "AudioFiles"
    Project ||--o| VideoEncoder : "VideoEncoder"
    Project ||--o{ Range : "Ranges"
    AudioTrack ||--o| AudioProfile : "AudioProfile"
```

### オーディオ関連

```mermaid
erDiagram
    AudioProfile {
        String Name
        String File
        Integer Delay
        String StreamName
        Single Gain
        Boolean Default
        Boolean Forced
        Boolean Commentary
        Boolean ExtractDTSCore
        Integer Channels
        Double Bitrate
        String OutputFileType
    }

    AudioStream {
        Integer ID
        Integer Index
        Integer StreamOrder
        String Format
        String FormatString
        String FormatProfile
        Integer Bitrate
        Integer Bitrate2
        Integer Channels
        Integer Channels2
        Integer SamplingRate
        Integer BitDepth
        Integer Delay
        String Title
        Boolean Default
        Boolean Forced
        Boolean Commentary
        Boolean Enabled
        Boolean Lossy
        Boolean SBR
    }

    Language {
        String TwoLetterCode
        String ThreeLetterCode
        String EnglishName
        String NativeName
    }

    GUIAudioProfile {
        Parameters Params
    }

    BatchAudioProfile {
        String CommandLines
    }

    MuxAudioProfile {
    }

    NullAudioProfile {
    }

    AudioProfile ||--o{ AudioStream : "Streams"
    AudioProfile ||--o| Language : "Language"
    AudioStream ||--o| Language : "Language"

    GUIAudioProfile }|--|| AudioProfile : extends
    BatchAudioProfile }|--|| AudioProfile : extends
    MuxAudioProfile }|--|| AudioProfile : extends
    NullAudioProfile }|--|| AudioProfile : extends
```

### アプリケーション設定関連

```mermaid
erDiagram
    ApplicationSettings {
        Version Version
        Single UIScaleFactor
        Boolean CheckForUpdates
        Boolean AutoSaveProject
        Boolean WriteDebugLog
        Integer LogFileNum
        Integer ProjectsMruNum
        String ThemeName
        String StartupTemplate
        String LastSourceDir
    }

    VideoEncoder {
        String Name
        Boolean QualityMode
    }

    AudioProfile {
        String Name
        Double Bitrate
    }

    Muxer {
        String Name
        String OutputType
    }

    FilterCategory {
        String Name
    }

    EventCommand {
        String Name
        Boolean Enabled
        Boolean OrOnly
        ApplicationEvent Event
    }

    ObjectStorage {
        Dictionary StringDictionary
        Dictionary IntDictionary
        Dictionary DoubleDictionary
        Dictionary BoolDictionary
    }

    WindowPositions {
    }

    CustomMenuItem {
        String Text
        String Path
    }

    ApplicationSettings ||--o{ VideoEncoder : "VideoEncoderProfiles"
    ApplicationSettings ||--o{ AudioProfile : "AudioProfiles"
    ApplicationSettings ||--o{ Muxer : "MuxerProfiles"
    ApplicationSettings ||--o{ FilterCategory : "AviSynthProfiles"
    ApplicationSettings ||--o{ FilterCategory : "VapourSynthProfiles"
    ApplicationSettings ||--o{ EventCommand : "EventCommands"
    ApplicationSettings ||--o| ObjectStorage : "Storage"
    ApplicationSettings ||--o| WindowPositions : "WindowPositions"
    ApplicationSettings ||--o| CustomMenuItem : "CustomMenuMainForm"
    ApplicationSettings ||--o| CustomMenuItem : "CustomMenuPreview"
    ApplicationSettings ||--o| CustomMenuItem : "CustomMenuCrop"
```

### ジョブ管理関連

```mermaid
erDiagram
    JobManager {
        String JobPath
    }

    Job {
        String Name
        String Path
        Boolean Active
    }

    JobManager ||--o{ Job : "manages"
```

### メディアストリーム関連

```mermaid
erDiagram
    VideoStream {
        Integer ID
        Integer Index
        Integer StreamOrder
        String Format
    }

    AudioStream {
        Integer ID
        Integer Index
        Integer StreamOrder
        String Format
        String FormatString
        Integer Bitrate
        Integer Channels
        Integer SamplingRate
        Integer BitDepth
    }

    Subtitle {
        Integer ID
        Integer Index
        Integer IndexIDX
        Integer StreamOrder
        String Path
        String Title
        String CodecString
        String Format
        Boolean Default
        Boolean Forced
        Boolean Commentary
        Boolean Hearingimpaired
        Boolean Enabled
        Long Size
    }

    M2TSStream {
        Integer ID
        Integer TypeID
        String Codec
        String Text
        String Options
        String OutputType
        Boolean Checked
        Boolean IsAudio
        Boolean IsVideo
        Boolean IsSubtitle
        Boolean IsChapters
        Boolean IsVideoEnhancementLayer
    }

    Language {
        String TwoLetterCode
        String ThreeLetterCode
        String EnglishName
    }

    AudioStream ||--o| Language : "Language"
    Subtitle ||--o| Language : "Language"
    M2TSStream ||--o| Language : "Language"
```

### イベントコマンド関連

```mermaid
erDiagram
    EventCommand {
        String Name
        Boolean Enabled
        Boolean OrOnly
        ApplicationEvent Event
    }

    Criteria {
        String PropertyName
        String Operator
        String Value
    }

    CommandParameters {
        String CommandType
        String Parameters
    }

    EventCommand ||--o{ Criteria : "CriteriaList"
    EventCommand ||--o| CommandParameters : "CommandParameters"
```

## 関連性の説明

### 1:1 関連
- `Project` - `VideoEncoder`: 1つのプロジェクトに1つのビデオエンコーダー設定
- `Project` - `TargetVideoScript`: 1つのプロジェクトに1つのターゲットスクリプト
- `Project` - `SourceVideoScript`: 1つのプロジェクトに1つのソーススクリプト
- `AudioTrack` - `AudioProfile`: 1つのオーディオトラックに1つのオーディオプロファイル
- `EventCommand` - `CommandParameters`: 1つのイベントコマンドに1つのコマンドパラメータ

### 1:N 関連
- `Project` - `AudioTrack`: 1つのプロジェクトに複数のオーディオトラック
- `Project` - `AudioProfile (AudioFiles)`: 1つのプロジェクトに複数のオーディオファイル
- `Project` - `Range`: 1つのプロジェクトに複数のカット範囲
- `AudioProfile` - `AudioStream`: 1つのオーディオプロファイルに複数のオーディオストリーム
- `ApplicationSettings` - `VideoEncoder`: アプリケーション設定に複数のビデオエンコーダープロファイル
- `ApplicationSettings` - `AudioProfile`: アプリケーション設定に複数のオーディオプロファイル
- `ApplicationSettings` - `Muxer`: アプリケーション設定に複数のマルチプレクサープロファイル
- `ApplicationSettings` - `FilterCategory`: アプリケーション設定に複数のフィルターカテゴリ
- `ApplicationSettings` - `EventCommand`: アプリケーション設定に複数のイベントコマンド
- `EventCommand` - `Criteria`: 1つのイベントコマンドに複数の条件

### 継承関連
- `GUIAudioProfile` extends `AudioProfile`: GUIベースのオーディオプロファイル
- `BatchAudioProfile` extends `AudioProfile`: バッチ処理用オーディオプロファイル
- `MuxAudioProfile` extends `AudioProfile`: マルチプレクス用オーディオプロファイル
- `NullAudioProfile` extends `AudioProfile`: オーディオなしプロファイル
