---
generated_at: 2026-01-21 14:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **セキュリティ考慮事項**: BinaryFormatterの非推奨に関する最新情報の確認が必要
  2. **ファイル保存場所**: 実際のアプリケーション動作での保存場所の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb`
- E-02: `Source/General/ApplicationSettings.vb`
- E-03: `Source/General/JobManager.vb`
- E-04: `Source/General/AudioProfile.vb`
- E-05: `Source/General/Misc.vb` (AudioTrack, AudioStream, VideoStream, Subtitle, M2TSStream, ObjectStorage, EventCommand, Profile クラス)
- E-06: `Source/General/GlobalClass.vb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Projectクラスがシリアライズ可能でプロジェクト設定を保持する | E-01 (`<Serializable()> Public Class Project`) | ○ |
| C-02 | SourceFile, TargetFile等のファイルパス関連プロパティが存在する | E-01 (Project.vb line 119, 285) | ○ |
| C-03 | ソース映像の解像度情報（SourceWidth, SourceHeight）が存在する | E-01 (Project.vb line 124, 136) | ○ |
| C-04 | ビデオエンコーダー設定がVideoEncoderとして保持される | E-01 (Project.vb line 156) | ○ |
| C-05 | オーディオトラックがList(Of AudioTrack)として管理される | E-01 (Project.vb line 21) | ○ |
| C-06 | ApplicationSettingsクラスがアプリケーション全体の設定を管理する | E-02 (`<Serializable()> Public Class ApplicationSettings`) | ○ |
| C-07 | VideoEncoderProfilesがList(Of VideoEncoder)として存在する | E-02 (ApplicationSettings.vb line 115) | ○ |
| C-08 | AudioProfilesがList(Of AudioProfile)として存在する | E-02 (ApplicationSettings.vb line 12) | ○ |
| C-09 | Jobクラスがエンコーディングジョブを表現する | E-03 (`<Serializable> Public Class Job`) | ○ |
| C-10 | JobクラスにName, Path, Activeプロパティが存在する | E-03 (JobManager.vb line 7-9) | ○ |
| C-11 | JobManagerがJobs.datファイルを通じてジョブを永続化する | E-03 (JobManager.vb line 111) | ○ |
| C-12 | AudioProfileクラスがオーディオエンコーディング設定の基底クラスである | E-04 (`<Serializable()> Public MustInherit Class AudioProfile`) | ○ |
| C-13 | GUIAudioProfile, BatchAudioProfile, MuxAudioProfile, NullAudioProfileがAudioProfileを継承する | E-04 (line 488, 578, 618, 774) | ○ |
| C-14 | AudioTrackクラスがAudioProfileを参照する | E-05 (Misc.vb line 994-1007) | ○ |
| C-15 | AudioStreamクラスがオーディオストリーム情報を保持する | E-05 (Misc.vb line 1291-1447) | ○ |
| C-16 | VideoStreamクラスがビデオストリーム情報を保持する | E-05 (Misc.vb line 1449-1479) | ○ |
| C-17 | Subtitleクラスが字幕トラック情報を保持する | E-05 (Misc.vb line 1481-1499) | ○ |
| C-18 | M2TSStreamクラスがM2TSストリーム情報を保持する | E-05 (Misc.vb line 1239-1288) | ○ |
| C-19 | ObjectStorageクラスが汎用キーバリューストレージを提供する | E-05 (Misc.vb line 1103-1184) | ○ |
| C-20 | EventCommandクラスがイベントコマンド設定を保持する | E-05 (Misc.vb line 1193-1204) | ○ |
| C-21 | ISafeSerialization インターフェースでバージョン管理を行う | E-01, E-02 (`Implements ISafeSerialization`, `Versions` Dictionary) | ○ |
| C-22 | BinaryFormatterによるシリアライズ処理が実装されている | E-03 (JobManager.vb line 110, 143) | ○ |
| C-23 | プロジェクトファイルの拡張子が.sripである | E-03 (JobManager.vb line 52 `& ".srip"`) | ○ |
| C-24 | BinaryFormatterは.NET 5以降で非推奨である | **根拠なし** - Microsoft公式ドキュメントの参照が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- C-24（BinaryFormatter非推奨）について：Microsoft公式ドキュメントからの確認が必要
  - 候補：Microsoft Learn / .NET Security Documentation / BinaryFormatter Security Guide
- 実際のファイル保存パスについて：アプリケーション実行時の動的な設定による可能性あり
  - 候補：Folder.Settings の定義 / レジストリ設定 / 環境変数

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: データ構造の定義（C-01〜C-23）- ソースコードから直接確認可能
- **1（中リスク）**: セキュリティ関連の主張（C-24）- 外部ドキュメントの参照が必要
- **1（中リスク）**: ファイル保存場所 - 実行環境依存の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] ソースコードの各クラス定義と設計書の対応を確認
- [ ] プロパティのデータ型とNULL許容性の整合性を確認
- [ ] リレーションシップ（1:1, 1:N）の妥当性を確認
- [ ] 実際のプロジェクトファイル（.srip）を開いて構造を検証
- [ ] BinaryFormatterの現在のセキュリティステータスをMicrosoft公式ドキュメントで確認
- [ ] 継承関係（AudioProfileの派生クラス）の網羅性を確認
- [ ] VideoEncoderおよびMuxerの詳細構造について追加調査が必要か判断
