# データベース設計書

## 概要

本ドキュメントは、StaxRipプロジェクトにおけるデータ永続化構造を設計書として記載したものです。StaxRipは従来のリレーショナルデータベース（RDB）を使用せず、.NETのバイナリシリアライゼーション機能を利用してデータを永続化するWindowsデスクトップアプリケーションです。

データは主に以下の2つの形式でファイルシステムに保存されます：
- **プロジェクトファイル（.srip）**: 個別のエンコーディングプロジェクト設定を保存
- **アプリケーション設定ファイル（.dat/.bin）**: アプリケーション全体の設定とジョブキューを保存

## テーブル一覧

以下は、StaxRipのシリアライズ可能なデータエンティティをテーブルとして表現したものです。

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| Projects | Project | プロジェクト設定（ソース・ターゲット・エンコード設定） |
| ApplicationSettings | ApplicationSettings | アプリケーション全体の設定 |
| Jobs | Job | エンコーディングジョブキュー |
| AudioProfiles | AudioProfile | オーディオエンコーディングプロファイル |
| AudioTracks | AudioTrack | プロジェクト内のオーディオトラック情報 |
| AudioStreams | AudioStream | メディアファイルのオーディオストリーム情報 |
| VideoStreams | VideoStream | メディアファイルのビデオストリーム情報 |
| Subtitles | Subtitle | 字幕トラック情報 |
| VideoEncoderProfiles | VideoEncoder | ビデオエンコーダープロファイル |
| MuxerProfiles | Muxer | マルチプレクサープロファイル |
| FilterCategories | FilterCategory | フィルタープロファイルカテゴリ |
| EventCommands | EventCommand | イベントコマンド設定 |
| ObjectStorage | ObjectStorage | 汎用キーバリューストレージ |

## 各テーブル定義

### 1. Projects (Project)

プロジェクト設定を格納するメインエンティティです。エンコーディングタスクの全設定を保持します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| SourceFile | String | YES | ソースファイルパス |
| SourceFiles | List(Of String) | YES | 複数ソースファイルのリスト |
| FirstOriginalSourceFile | String | YES | 最初のオリジナルソースファイル |
| LastOriginalSourceFile | String | YES | 最後のオリジナルソースファイル |
| TargetFile | String | YES | 出力ファイルパス |
| TempDir | String | YES | 一時ディレクトリパス |
| SourceWidth | Integer | NO | ソース映像幅（デフォルト：1920） |
| SourceHeight | Integer | NO | ソース映像高さ（デフォルト：1080） |
| SourceFrameRate | Decimal | YES | ソースフレームレート |
| SourceFrames | Integer | YES | ソースフレーム数 |
| SourceSeconds | Integer | YES | ソース秒数 |
| SourceSize | Long | YES | ソースファイルサイズ |
| SourceBitrate | Integer | YES | ソースビットレート |
| SourceVideoBitDepth | Integer | YES | ソース映像ビット深度 |
| SourceVideoFormat | String | YES | ソース映像フォーマット |
| SourceChromaSubsampling | String | YES | クロマサブサンプリング |
| SourceColorSpace | String | YES | カラースペース |
| SourceScanType | String | YES | スキャンタイプ（インターレース/プログレッシブ） |
| SourceScanOrder | String | YES | スキャン順序 |
| SourceVideoHdrFormat | String | NO | HDRフォーマット（デフォルト：空文字） |
| SourcePAR | Point | NO | ソースピクセルアスペクト比（デフォルト：1:1） |
| SourceAnamorphic | Boolean | NO | アナモルフィックフラグ |
| TargetWidth | Integer | NO | 出力映像幅（デフォルト：1920） |
| TargetHeight | Integer | NO | 出力映像高さ（デフォルト：1080） |
| TargetFrames | Integer | YES | 出力フレーム数 |
| TargetFrameRate | Double | YES | 出力フレームレート |
| TargetSeconds | Integer | NO | 出力秒数（デフォルト：5400） |
| TargetSize | Integer | NO | 出力ファイルサイズ（デフォルト：5000MB） |
| VideoBitrate | Integer | NO | 映像ビットレート（デフォルト：5000kbps） |
| BitrateIsFixed | Boolean | NO | ビットレート固定フラグ（デフォルト：True） |
| CropLeft | Integer | NO | 左クロップ値 |
| CropRight | Integer | NO | 右クロップ値 |
| CropTop | Integer | NO | 上クロップ値 |
| CropBottom | Integer | NO | 下クロップ値 |
| AutoCropMode | AutoCropMode | NO | 自動クロップモード |
| AutoCorrectCropValues | Boolean | NO | 自動クロップ値補正（デフォルト：True） |
| VideoEncoder | VideoEncoder | YES | ビデオエンコーダー設定 |
| Script | TargetVideoScript | YES | ビデオスクリプト設定 |
| SourceScript | SourceVideoScript | YES | ソーススクリプト設定 |
| AudioFiles | List(Of AudioProfile) | YES | オーディオファイルリスト |
| AudioTracks | List(Of AudioTrack) | YES | オーディオトラックリスト |
| AudioTracksAvailable | Integer | NO | 利用可能オーディオトラック数（デフォルト：4） |
| SubtitleMode | SubtitleMode | YES | 字幕モード |
| HardcodedSubtitle | Boolean | NO | ハードコード字幕フラグ |
| PreferredAudio | String | YES | 優先オーディオ言語 |
| PreferredSubtitles | String | YES | 優先字幕言語 |
| Ranges | List(Of Range) | YES | カット範囲リスト |
| CuttingMode | CuttingMode | YES | カットモード |
| DeleteTempFilesMode | DeleteMode | NO | 一時ファイル削除モード |
| Log | LogBuilder | YES | ログビルダー |
| Versions | Dictionary(Of String, Integer) | YES | バージョン管理辞書 |
| TemplateName | String | NO | テンプレート名（デフォルト：空文字） |
| TemplatePath | String | NO | テンプレートパス（デフォルト：空文字） |
| NoDialogs | Boolean | NO | ダイアログ非表示フラグ |
| BatchMode | Boolean | NO | バッチモードフラグ |
| SkipVideoEncoding | Boolean | NO | 映像エンコードスキップフラグ |
| SkipAudioEncoding | Boolean | NO | オーディオエンコードスキップフラグ |

### 2. ApplicationSettings

アプリケーション全体の設定を格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| Version | Version | YES | アプリケーションバージョン |
| Versions | Dictionary(Of String, Integer) | YES | 設定バージョン管理 |
| VideoEncoderProfiles | List(Of VideoEncoder) | YES | ビデオエンコーダープロファイルリスト |
| AudioProfiles | List(Of AudioProfile) | YES | オーディオプロファイルリスト |
| MuxerProfiles | List(Of Muxer) | YES | マルチプレクサープロファイルリスト |
| Demuxers | List(Of Demuxer) | YES | デマルチプレクサーリスト |
| FilterSetupProfiles | List(Of TargetVideoScript) | YES | フィルターセットアッププロファイル |
| AviSynthProfiles | List(Of FilterCategory) | YES | AviSynthプロファイルリスト |
| VapourSynthProfiles | List(Of FilterCategory) | YES | VapourSynthプロファイルリスト |
| AviSynthFilterPreferences | StringPairList | YES | AviSynthフィルター優先設定 |
| VapourSynthFilterPreferences | StringPairList | YES | VapourSynthフィルター優先設定 |
| EventCommands | List(Of EventCommand) | YES | イベントコマンドリスト |
| eac3toProfiles | List(Of eac3toProfile) | YES | eac3toプロファイルリスト |
| RecentProjects | List(Of String) | YES | 最近使用したプロジェクトリスト |
| RecentFramePositions | List(Of String) | YES | 最近のフレーム位置リスト |
| LastSourceDir | String | YES | 最後のソースディレクトリ |
| StartupTemplate | String | YES | 起動時テンプレート |
| ThemeName | String | YES | テーマ名 |
| Fonts | Dictionary(Of FontCategory, String) | YES | フォント設定 |
| WindowPositions | WindowPositions | YES | ウィンドウ位置設定 |
| WindowPositionsRemembered | String() | YES | 記憶するウィンドウ位置リスト |
| CustomMenuMainForm | CustomMenuItem | YES | メインフォームカスタムメニュー |
| CustomMenuPreview | CustomMenuItem | YES | プレビューカスタムメニュー |
| CustomMenuCrop | CustomMenuItem | YES | クロップカスタムメニュー |
| CustomMenuCodeEditor | CustomMenuItem | YES | コードエディタカスタムメニュー |
| CustomMenuSize | CustomMenuItem | YES | サイズカスタムメニュー |
| Storage | ObjectStorage | YES | 汎用ストレージ |
| StringDictionary | Dictionary(Of String, String) | YES | 文字列辞書 |
| StringList | List(Of String) | YES | 文字列リスト |
| UIScaleFactor | Single | NO | UIスケールファクター（デフォルト：1.0） |
| CheckForUpdates | Boolean | NO | 更新確認フラグ（デフォルト：True） |
| AutoSaveProject | Boolean | NO | 自動保存フラグ |
| WriteDebugLog | Boolean | NO | デバッグログ出力フラグ |
| LogFileNum | Integer | NO | ログファイル数（デフォルト：200） |
| ProjectsMruNum | Integer | NO | 最近使用プロジェクト数（デフォルト：15） |
| ProcessPriority | ProcessPriorityClass | NO | プロセス優先度 |
| PreventStandby | Boolean | NO | スタンバイ防止（デフォルト：True） |
| MinimizeToTray | Boolean | NO | トレイ最小化フラグ |

### 3. Jobs (Job)

エンコーディングジョブキューを格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| Name | String | YES | ジョブ名 |
| Path | String | YES | プロジェクトファイルパス |
| Active | Boolean | NO | アクティブフラグ（デフォルト：True） |

### 4. AudioProfiles (AudioProfile)

オーディオエンコーディング設定のベースエンティティです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| Name | String | YES | プロファイル名 |
| File | String | YES | オーディオファイルパス |
| Language | Language | YES | 言語設定 |
| Delay | Integer | NO | 遅延（ミリ秒） |
| StreamName | String | NO | ストリーム名（デフォルト：空文字） |
| Gain | Single | NO | ゲイン |
| Streams | List(Of AudioStream) | YES | オーディオストリームリスト |
| Default | Boolean | NO | デフォルトフラグ |
| Forced | Boolean | NO | 強制フラグ |
| Commentary | Boolean | NO | コメンタリーフラグ |
| ExtractDTSCore | Boolean | NO | DTSコア抽出フラグ |
| Decoder | AudioDecoderMode | YES | デコーダーモード |
| DecodingMode | AudioDecodingMode | YES | デコードモード |
| Channels | Integer | NO | チャンネル数（デフォルト：6） |
| OutputFileType | String | YES | 出力ファイルタイプ |
| Bitrate | Double | YES | ビットレート |
| SupportedInput | String() | YES | サポートする入力形式 |
| CommandLines | String | YES | コマンドライン |

### 5. AudioTracks (AudioTrack)

プロジェクト内のオーディオトラック情報を格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| AudioProfile | AudioProfile | YES | オーディオプロファイル参照 |
| Index | Integer | NO | トラックインデックス |

### 6. AudioStreams (AudioStream)

メディアファイルから抽出されたオーディオストリーム情報を格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| ID | Integer | NO | ストリームID |
| Index | Integer | NO | ストリームインデックス |
| StreamOrder | Integer | NO | ストリーム順序 |
| Format | String | YES | フォーマット |
| FormatString | String | YES | フォーマット文字列 |
| FormatProfile | String | YES | フォーマットプロファイル |
| Bitrate | Integer | NO | ビットレート（kbps） |
| Bitrate2 | Integer | NO | セカンダリビットレート |
| Channels | Integer | NO | チャンネル数 |
| Channels2 | Integer | NO | セカンダリチャンネル数 |
| SamplingRate | Integer | NO | サンプリングレート |
| BitDepth | Integer | NO | ビット深度 |
| Delay | Integer | NO | 遅延（ミリ秒） |
| Language | Language | YES | 言語 |
| Title | String | YES | タイトル |
| Default | Boolean | NO | デフォルトフラグ |
| Forced | Boolean | NO | 強制フラグ |
| Commentary | Boolean | NO | コメンタリーフラグ |
| Enabled | Boolean | NO | 有効フラグ（デフォルト：True） |
| Lossy | Boolean | NO | 非可逆圧縮フラグ |
| SBR | Boolean | NO | SBRフラグ |

### 7. VideoStreams (VideoStream)

メディアファイルから抽出されたビデオストリーム情報を格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| ID | Integer | NO | ストリームID |
| Index | Integer | NO | ストリームインデックス |
| StreamOrder | Integer | NO | ストリーム順序 |
| Format | String | YES | フォーマット（MPEG Video, AVC, HEVC等） |

### 8. Subtitles (Subtitle)

字幕トラック情報を格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| ID | Integer | NO | 字幕ID |
| Index | Integer | NO | 字幕インデックス |
| IndexIDX | Integer | NO | IDXインデックス |
| StreamOrder | Integer | NO | ストリーム順序 |
| Path | String | YES | 字幕ファイルパス |
| Title | String | NO | タイトル（デフォルト：空文字） |
| CodecString | String | YES | コーデック文字列 |
| Format | String | YES | フォーマット |
| Language | Language | YES | 言語 |
| Default | Boolean | NO | デフォルトフラグ |
| Forced | Boolean | NO | 強制フラグ |
| Commentary | Boolean | NO | コメンタリーフラグ |
| Hearingimpaired | Boolean | NO | 聴覚障害者向けフラグ |
| Enabled | Boolean | NO | 有効フラグ（デフォルト：True） |
| Size | Long | NO | サイズ |

### 9. EventCommands (EventCommand)

イベント発生時に実行するコマンド設定を格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| Name | String | NO | コマンド名（デフォルト：???） |
| Enabled | Boolean | NO | 有効フラグ（デフォルト：True） |
| CriteriaList | List(Of Criteria) | YES | 条件リスト |
| OrOnly | Boolean | NO | OR条件のみフラグ |
| CommandParameters | CommandParameters | YES | コマンドパラメータ |
| Event | ApplicationEvent | YES | 対象アプリケーションイベント |

### 10. ObjectStorage

汎用キーバリューストレージを格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| StringDictionary | Dictionary(Of String, String) | YES | 文字列値の辞書 |
| IntDictionary | Dictionary(Of String, Integer) | YES | 整数値の辞書 |
| DoubleDictionary | Dictionary(Of String, Double) | YES | 倍精度浮動小数点値の辞書 |
| BoolDictionary | Dictionary(Of String, Boolean) | YES | ブール値の辞書 |

### 11. M2TSStream

M2TS形式のストリーム情報を格納します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| ID | Integer | NO | ストリームID |
| TypeID | Integer | NO | タイプID |
| Codec | String | NO | コーデック（デフォルト：空文字） |
| Text | String | NO | テキスト（デフォルト：Nothing） |
| Options | String | NO | オプション（デフォルト：空文字） |
| OutputType | String | NO | 出力タイプ（デフォルト：空文字） |
| Language | Language | YES | 言語 |
| Checked | Boolean | NO | 選択フラグ |
| IsAudio | Boolean | NO | オーディオフラグ |
| IsVideo | Boolean | NO | ビデオフラグ |
| IsSubtitle | Boolean | NO | 字幕フラグ |
| IsChapters | Boolean | NO | チャプターフラグ |
| IsVideoEnhancementLayer | Boolean | NO | ビデオ拡張レイヤーフラグ |
| ListViewItem | ListViewItem | YES | リストビュー項目参照 |

### 12. Profile (基底クラス)

全プロファイルの基底クラスです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| Name | String | YES | プロファイル名 |
| CanEdit | Boolean | NO | 編集可能フラグ |

## 備考

### データ永続化方式

StaxRipは以下の方式でデータを永続化しています：

1. **BinaryFormatter シリアライゼーション**
   - `Project`クラスはプロジェクトファイル（.srip）として保存
   - `ApplicationSettings`クラスはアプリケーション設定ファイルとして保存
   - `Job`リストはジョブファイル（Jobs.dat）として保存

2. **ファイル保存場所**
   - プロジェクトファイル: ユーザー指定のディレクトリ
   - 設定ファイル: `%AppData%\StaxRip` または アプリケーションディレクトリ
   - ジョブファイル: 設定ディレクトリ内の `Jobs.dat`

### セキュリティ考慮事項

- `BinaryFormatter`は.NET 5以降で非推奨とされており、セキュリティ上のリスクがあります
- 信頼できないソースからのプロジェクトファイル読み込みには注意が必要です

### バージョン管理

- `ISafeSerialization`インターフェースを実装し、`Versions`辞書でデータ構造のバージョン管理を行っています
- `Check`メソッドでバージョン不一致時のマイグレーション処理を実行します
- `Migrate`メソッドで後方互換性を維持するためのデータ変換を行います

### リレーションシップ

- `Project` -> `AudioTracks` (1:N)
- `Project` -> `AudioProfile` (via AudioFiles, 1:N)
- `Project` -> `VideoEncoder` (1:1)
- `AudioTrack` -> `AudioProfile` (1:1)
- `AudioProfile` -> `AudioStream` (1:N via Streams)
- `ApplicationSettings` -> `VideoEncoder` (1:N via VideoEncoderProfiles)
- `ApplicationSettings` -> `AudioProfile` (1:N via AudioProfiles)
- `ApplicationSettings` -> `Muxer` (1:N via MuxerProfiles)
- `ApplicationSettings` -> `EventCommand` (1:N via EventCommands)
