---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Build.ps1`
- E-02: `Source/Release.ps1`
- E-03: `Source/BuildAndPack.ps1`
- E-04: `Source/Scripts/Hello World.ps1`
- E-05: `Source/Scripts/Show task dialog.ps1`
- E-06: `Source/Scripts/Set audio decoding mode.ps1`
- E-07: `Source/Scripts/Set filter.ps1`
- E-08: `Source/Scripts/Legacy/Update.ps1`
- E-09: `Source/Scripts/Legacy/Update.py`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Build.ps1はStaxRipソリューションをReleaseモードでビルドする | E-01 (行56: `& $msBuildExe "$solution" -t:Rebuild -p:Configuration=Release -p:Platform=x64`) | ○ |
| C-02 | Release.ps1はリリース用7zアーカイブを作成する | E-02 (行95: `& $7zExe a -t7z -mx9 -m0=LZMA2 ...`) | ○ |
| C-03 | BuildAndPack.ps1はEXEとPDBファイルのみをパッケージする | E-03 (行79: `& $7zExe a ... "$appExe" "$appPdb"`) | ○ |
| C-04 | Hello World.ps1はHello Worldメッセージを表示する | E-04 (行2: `[MainModule]::MsgInfo('Hello World')`) | ○ |
| C-05 | Show task dialog.ps1はタスクダイアログを表示する | E-05 (行2-6: `$td = New-Object TaskDialog[string]` ... `$td.Show()`) | ○ |
| C-06 | Set audio decoding mode.ps1はオーディオデコードモードをPipeに設定する | E-06 (行13: `$audio.DecodingMode = 'Pipe'`) | ○ |
| C-07 | Set filter.ps1はQTGMCフィルタを自動設定する | E-07 (行10,14: `SetFilter('Field', 'QTGMC Interlaced', ...)` / `SetFilter('Field', 'QTGMC Progressive', ...)`) | ○ |
| C-08 | Update.ps1はGitHubから最新リリースをダウンロードする | E-08 (行77-82: `Download-staxrip` 関数, GitHub URLからダウンロード) | ○ |
| C-09 | Update.pyはGitHubから最新リリースをダウンロードする | E-09 (行77-84: `DownloadStaxRip` 関数, GitHub URLからダウンロード) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのバッチファイル/スクリプトは実際のソースコードから直接確認され、機能説明も各ファイルの内容と整合しています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠があり、コードとの整合性が確認されています。

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類が適切か確認する（ビルド、リリース、スクリプト、更新）
- [ ] 各バッチ/スクリプトの説明が実際の機能と一致しているか確認する
- [ ] Legacyディレクトリ内のスクリプトが現在も使用されているか確認する
- [ ] 備考欄のファイルパスが正しいか確認する
