# バッチ設計書 1-Build.ps1

## 概要

本ドキュメントは、StaxRipアプリケーションのビルドを実行するPowerShellスクリプト「Build.ps1」の設計書です。ソリューションファイルをReleaseモードでビルドし、ビルド完了後にバージョン情報を表示します。

### 本バッチの処理概要

このバッチは、StaxRipソリューションをMSBuildを使用してReleaseモードでビルドし、ビルド後のEXEファイルからバージョン情報を取得・表示するPowerShellスクリプトです。

**業務上の目的・背景**：StaxRipは動画エンコーディングツールであり、開発者がソースコードを変更した後、アプリケーションをビルドして実行可能な状態にする必要があります。このスクリプトは、ビルドプロセスを自動化し、プロジェクトファイル内の非ASCII文字を事前にチェックすることで、ビルドエラーを未然に防止します。

**バッチの実行タイミング**：開発者がソースコードを変更した後、手動でビルドを実行する際に使用されます。リリース前のビルド検証やCI/CDパイプラインからの呼び出しにも対応しています。

**主要な処理内容**：
1. プロジェクトファイルの非ASCII文字チェック（.config, .cpp, .h, .ps1, .rc, .resx, .sln, .vbproj）
2. MSBuildによるソリューションのReleaseモードビルド（x64プラットフォーム）
3. ビルド完了後のバージョン情報取得と表示

**前後の処理との関連**：このスクリプトはRelease.ps1やBuildAndPack.ps1の前提処理となります。ビルドが成功した後、リリースパッケージの作成処理が実行されます。

**影響範囲**：Source\binディレクトリにビルド成果物（StaxRip.exe等）が出力されます。ビルドに失敗した場合は例外がスローされ、後続処理が中断されます。

## バッチ種別

ビルド処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| MSBuildのインストール | MSBuild.exeがパスに存在すること |
| ソリューションファイル | StaxRip.slnが$PSScriptRootに存在すること |
| .NET Framework | ビルドに必要な.NET Framework SDKがインストールされていること |

### 実行可否判定

プロジェクトファイル内に非ASCII文字が含まれている場合、ビルド前にエラーがスローされ処理が中断されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| StaxRip.sln | ソリューションファイル | ビルド対象のソリューションファイル |
| プロジェクトファイル群 | .config, .cpp, .h, .ps1等 | ASCII文字チェック対象ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Source\bin\ | ディレクトリ | ビルド成果物（EXE、DLL等） |
| コンソール | テキスト | バージョン情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | StaxRip.exe（他多数） |
| 出力先 | $PSScriptRoot\bin |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 変数の初期化
   └─ ソリューションパス、binディレクトリ、除外パターン等を設定
2. プロジェクトファイルの非ASCII文字チェック
   └─ Apps、.vb、.mdファイルを除外して全プロジェクトファイルをスキャン
3. MSBuildによるビルド実行
   └─ Releaseモード、x64プラットフォームでRebuildを実行
4. バージョン情報の取得と表示
   └─ StaxRip.exeからFileVersionInfoを取得して表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変数初期化]
    B --> C[プロジェクトファイル取得]
    C --> D{全ファイルチェック完了?}
    D -->|No| E[非ASCII文字チェック]
    E -->|非ASCII検出| F[例外スロー]
    E -->|OK| D
    D -->|Yes| G[MSBuild実行]
    G -->|エラー| H[例外スロー]
    G -->|成功| I[バージョン情報取得]
    I --> J[バージョン情報表示]
    J --> K[バッチ終了]
    F --> L[異常終了]
    H --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 非ASCII文字エラー | プロジェクトファイルに非ASCII文字が含まれる | 該当ファイルを修正し、非ASCII文字を除去 |
| $LastExitCode | ビルドエラー | MSBuildが失敗した場合 | ビルドエラーの内容を確認し、ソースコードを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 非ASCII文字エラーの場合：エラーメッセージに表示されるファイルと行を確認し、非ASCII文字を除去
2. ビルドエラーの場合：MSBuildの出力を確認し、コンパイルエラーを修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ソリューション |
| 目標処理時間 | プロジェクト規模に依存（通常数分） |
| メモリ使用量上限 | MSBuild依存 |

## 排他制御

同一ディレクトリでの複数同時実行は推奨されません。ビルド出力ディレクトリが競合する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| バージョン情報 | ビルド完了時 | FileVersionInfo（緑色で表示） |
| エラーログ | エラー発生時 | 例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド成功/失敗 | 失敗時 | コンソール出力 |

## 備考

- 本スクリプトはRelease.ps1、BuildAndPack.ps1と共通の変数定義部分を持ちます
- 除外パターン（$excludeBinPatterns）は定義されていますが、本スクリプトでは使用されていません
- 7-Zipや出力先ディレクトリの変数も定義されていますが、本スクリプトでは使用されていません
