# バッチ設計書 2-Release.ps1

## 概要

本ドキュメントは、StaxRipアプリケーションのリリースパッケージを作成するPowerShellスクリプト「Release.ps1」の設計書です。ソリューションをビルドし、不要ファイルを除外した上で7z形式のアーカイブを作成します。

### 本バッチの処理概要

このバッチは、StaxRipソリューションをビルドし、ビルド成果物から不要なファイル（ログ、設定ファイル、デバッグシンボル等）を除外して、リリース用の7zアーカイブを作成する包括的なリリース自動化スクリプトです。

**業務上の目的・背景**：StaxRipの新バージョンをユーザーに配布するために、クリーンなリリースパッケージを作成する必要があります。手動でファイルを選別すると漏れやミスが発生しやすいため、このスクリプトで自動化することで、一貫性のあるリリースパッケージを効率的に作成できます。

**バッチの実行タイミング**：新バージョンのリリース時に手動で実行されます。通常、開発完了後のリリース作業フェーズで使用されます。

**主要な処理内容**：
1. プロジェクトファイルの非ASCII文字チェック（品質保証）
2. MSBuildによるソリューションのReleaseモードビルド（x64プラットフォーム）
3. ビルド成果物のバージョン情報取得とターゲットディレクトリ名の決定
4. 除外パターンに基づく不要ファイルのフィルタリング
5. フィルタリング後のファイルをターゲットディレクトリにコピー
6. 7-Zipを使用した高圧縮アーカイブ（LZMA2）の作成

**前後の処理との関連**：Build.ps1の処理内容を包含しており、単独で完結するリリースワークフローを提供します。作成されたアーカイブはGitHub Releases等で配布されます。

**影響範囲**：A:\StaxRip-Releasesディレクトリにリリースパッケージが出力されます。既存のターゲットディレクトリやアーカイブファイルは上書きされます。

## バッチ種別

リリース処理 / パッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| MSBuildのインストール | MSBuild.exeがパスに存在すること |
| 7-Zipのインストール | 7z.exeがパスに存在すること |
| ソリューションファイル | StaxRip.slnが$PSScriptRootに存在すること |
| 出力先ディレクトリ | A:\StaxRip-Releasesディレクトリが存在すること |

### 実行可否判定

- プロジェクトファイル内に非ASCII文字が含まれている場合、処理が中断されます
- ビルドに失敗した場合、後続のパッケージング処理は実行されません

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| StaxRip.sln | ソリューションファイル | ビルド対象のソリューションファイル |
| Source\bin\ | ディレクトリ | ビルド成果物の格納ディレクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| A:\StaxRip-Releases\StaxRip-v{version}-x64\ | ディレクトリ | フィルタリング後のリリースファイル |
| A:\StaxRip-Releases\StaxRip-v{version}-x64.7z | 7zアーカイブ | 配布用圧縮ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | StaxRip-v{FileVersion}-x64.7z |
| 出力先 | A:\StaxRip-Releases |
| 圧縮形式 | 7z（LZMA2、辞書サイズ1024MB） |
| 圧縮レベル | 最高（-mx9） |

### 除外ファイルパターン

以下のパターンに一致するファイルはリリースパッケージから除外されます：

- Settingsフォルダ（^\\[^\\]*Settings）
- 復旧ファイル（.*recovery\.srip$）
- ログファイル（.*\.log$）
- INIファイル（eac3to.ini以外）
- ヘルプテキスト（.*help\.txt$）
- バグレポート（.*\\eac3to\\bugreport\.txt$）
- 各種ログファイル（.*\\log\d+\.txt$）
- QTfiles（.*\\qaac\\QTfiles.*）
- ビルド中間ファイル（.exp, .ilk, .lib, .pdb等）
- XMLドキュメント（ManagedCuda.xml, System.Management.Automation.xml）
- VSホストファイル（.*\\StaxRip\.vshost.*）
- Pythonキャッシュ（.*_pycache_.*）

## 処理フロー

### 処理シーケンス

```
1. 変数の初期化
   └─ パス、除外パターン等を設定
2. プロジェクトファイルの非ASCII文字チェック
   └─ Apps、.vb、.mdファイルを除外して全プロジェクトファイルをスキャン
3. MSBuildによるビルド実行
   └─ Releaseモード、x64プラットフォームでRebuildを実行
4. バージョン情報の取得
   └─ StaxRip.exeからバージョンを取得し、ターゲットディレクトリ名を決定
5. 既存ターゲットディレクトリの削除
   └─ 存在する場合は再帰的に削除
6. ファイルのフィルタリングとコピー
   └─ 除外パターンに一致しないファイルをターゲットディレクトリにコピー
7. 既存アーカイブの削除
   └─ 存在する場合は削除
8. 7-Zipによるアーカイブ作成
   └─ LZMA2、最高圧縮でアーカイブを作成
9. 完了メッセージの表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変数初期化]
    B --> C[非ASCII文字チェック]
    C -->|エラー| X[異常終了]
    C -->|OK| D[MSBuild実行]
    D -->|エラー| X
    D -->|成功| E[バージョン情報取得]
    E --> F[ターゲットディレクトリ名決定]
    F --> G{既存ディレクトリ存在?}
    G -->|Yes| H[既存ディレクトリ削除]
    G -->|No| I[ファイルコピー]
    H --> I
    I --> J{既存アーカイブ存在?}
    J -->|Yes| K[既存アーカイブ削除]
    J -->|No| L[7-Zipでアーカイブ作成]
    K --> L
    L -->|エラー| X
    L -->|成功| M[完了メッセージ表示]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 非ASCII文字エラー | プロジェクトファイルに非ASCII文字が含まれる | 該当ファイルを修正 |
| $LastExitCode | ビルドエラー | MSBuildが失敗した場合 | ビルドエラーを修正 |
| $LastExitCode | 圧縮エラー | 7-Zipが失敗した場合 | ディスク容量、ファイルアクセス権を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ビルドエラー：MSBuildの出力を確認し、コンパイルエラーを修正
2. 圧縮エラー：出力先ディスクの空き容量を確認、ファイルがロックされていないか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（処理失敗時は中間ファイルが残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リリースパッケージ |
| 目標処理時間 | ビルド+圧縮で数分〜十数分 |
| メモリ使用量上限 | 辞書サイズ1024MBを使用するため、2GB以上推奨 |

## 排他制御

同一出力先への複数同時実行は推奨されません。既存ファイルの削除処理があるため、データ損失の可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| バージョン情報 | ビルド完了時 | FileVersionInfo（緑色） |
| 完了メッセージ | 処理完了時 | "Successfully finished"（緑色） |
| エラーログ | エラー発生時 | 例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理成功/失敗 | 失敗時 | コンソール出力 |

## 備考

- 圧縮オプション：-t7z -mx9 -m0=LZMA2 -md1024m -mfb256 -mmt3 -sse
  - LZMA2アルゴリズム、辞書サイズ1024MB、ファストバイト256、3スレッド使用
- 出力先ディレクトリ（A:\StaxRip-Releases）は環境に応じて変更が必要な場合があります
- バージョン番号のFileBuildPartが0かどうかで分岐がありますが、現在は同じ処理が実行されます
