# バッチ設計書 3-BuildAndPack.ps1

## 概要

本ドキュメントは、StaxRipアプリケーションをビルドし、EXEファイルとPDBファイルのみを軽量なアーカイブにパッケージするPowerShellスクリプト「BuildAndPack.ps1」の設計書です。

### 本バッチの処理概要

このバッチは、StaxRipソリューションをビルドし、実行ファイル（EXE）とデバッグシンボル（PDB）のみを7z形式でアーカイブ化する軽量パッケージング用スクリプトです。

**業務上の目的・背景**：完全なリリースパッケージではなく、EXEファイルとデバッグシンボルのみを配布したい場合に使用します。例えば、既存のインストール環境に対してEXEのみを更新する場合や、テスト目的でのクイック配布、デバッグ用にPDBを含めたパッケージの配布などに適しています。Release.ps1と比較して、パッケージサイズが大幅に小さくなります。

**バッチの実行タイミング**：開発中の中間リリースやホットフィックス配布時、または完全なリリースパッケージが不要な場合に手動で実行されます。

**主要な処理内容**：
1. プロジェクトファイルの非ASCII文字チェック（品質保証）
2. MSBuildによるソリューションのReleaseモードビルド（x64プラットフォーム）
3. ビルド成果物のバージョン情報取得とターゲットファイル名の決定
4. StaxRip.exeとStaxRip.pdbのみを7zアーカイブに圧縮

**前後の処理との関連**：Build.ps1の処理内容を包含しています。Release.ps1の軽量版として位置づけられ、完全なリリースが不要な場面で代替として使用されます。

**影響範囲**：A:\StaxRip-Releasesディレクトリに軽量パッケージ（EXE+PDB）が出力されます。ファイル名に"-EXE"サフィックスが付くことで、完全リリースパッケージと区別できます。

## バッチ種別

ビルド処理 / 軽量パッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| MSBuildのインストール | MSBuild.exeがパスに存在すること |
| 7-Zipのインストール | 7z.exeがパスに存在すること |
| ソリューションファイル | StaxRip.slnが$PSScriptRootに存在すること |
| 出力先ディレクトリ | A:\StaxRip-Releasesディレクトリへの書き込み権限 |

### 実行可否判定

- プロジェクトファイル内に非ASCII文字が含まれている場合、処理が中断されます
- ビルドに失敗した場合、アーカイブ作成処理は実行されません

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| StaxRip.sln | ソリューションファイル | ビルド対象のソリューションファイル |
| Source\bin\StaxRip.exe | 実行ファイル | アーカイブ対象 |
| Source\bin\StaxRip.pdb | デバッグシンボル | アーカイブ対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| A:\StaxRip-Releases\StaxRip-v{version}-x64-EXE.7z | 7zアーカイブ | EXE+PDBのみの軽量パッケージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | StaxRip-v{FileVersion}-x64-EXE.7z |
| 出力先 | A:\StaxRip-Releases |
| 圧縮形式 | 7z（LZMA2、辞書サイズ1024MB） |
| 圧縮レベル | 最高（-mx9） |
| 含まれるファイル | StaxRip.exe、StaxRip.pdb |

## 処理フロー

### 処理シーケンス

```
1. 変数の初期化
   └─ パス、除外パターン等を設定
2. プロジェクトファイルの非ASCII文字チェック
   └─ Apps、.vb、.mdファイルを除外して全プロジェクトファイルをスキャン
3. MSBuildによるビルド実行
   └─ Releaseモード、x64プラットフォームでRebuildを実行
4. バージョン情報の取得
   └─ StaxRip.exeからバージョンを取得し、ターゲットファイル名を決定（"-EXE"サフィックス付き）
5. 既存アーカイブの削除
   └─ 存在する場合は削除
6. PDBファイルパスの生成
   └─ EXEパスから拡張子をpdbに変更
7. 7-Zipによるアーカイブ作成
   └─ EXEとPDBのみをLZMA2、最高圧縮でアーカイブ
8. 完了メッセージの表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変数初期化]
    B --> C[非ASCII文字チェック]
    C -->|エラー| X[異常終了]
    C -->|OK| D[MSBuild実行]
    D -->|エラー| X
    D -->|成功| E[バージョン情報取得]
    E --> F[ターゲットファイル名決定]
    F --> G{既存アーカイブ存在?}
    G -->|Yes| H[既存アーカイブ削除]
    G -->|No| I[PDBパス生成]
    H --> I
    I --> J[7-ZipでEXE+PDBをアーカイブ]
    J -->|エラー| X
    J -->|成功| K[完了メッセージ表示]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 非ASCII文字エラー | プロジェクトファイルに非ASCII文字が含まれる | 該当ファイルを修正 |
| $LastExitCode | ビルドエラー | MSBuildが失敗した場合 | ビルドエラーを修正 |
| $LastExitCode | 圧縮エラー | 7-Zipが失敗した場合 | ファイルアクセス権を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ビルドエラー：MSBuildの出力を確認し、コンパイルエラーを修正
2. 圧縮エラー：EXE/PDBファイルがロックされていないか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2ファイル（EXE+PDB） |
| 目標処理時間 | ビルド時間+数秒 |
| メモリ使用量上限 | 辞書サイズ1024MBを使用 |

## 排他制御

同一出力先への複数同時実行は推奨されません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| バージョン情報 | ビルド完了時 | FileVersionInfo（緑色） |
| 完了メッセージ | 処理完了時 | "Successfully finished"（緑色） |
| エラーログ | エラー発生時 | 例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理成功/失敗 | 失敗時 | コンソール出力 |

## 備考

- Release.ps1との違い：
  - ファイルコピー処理がなく、EXEとPDBのみを直接アーカイブ
  - 出力ファイル名に"-EXE"サフィックスが付く
  - パッケージサイズが大幅に小さい
- 圧縮オプションはRelease.ps1と同じ（-t7z -mx9 -m0=LZMA2 -md1024m -mfb256 -mmt3 -sse）
- System.IO.Path.ChangeExtensionを使用してPDBパスを生成
