# バッチ設計書 8-Update.ps1

## 概要

本ドキュメントは、GitHubから最新のStaxRipリリースをダウンロードして自動更新するPowerShellスクリプト「Update.ps1」の設計書です。レガシースクリプトとして分類されています。

### 本バッチの処理概要

このスクリプトは、StaxRipの自動更新機能を提供するPowerShellスクリプトで、現在インストールされているバージョンとGitHub上の最新リリースバージョンを比較し、新しいバージョンが利用可能な場合に自動的にダウンロード・展開・更新を行います。

**業務上の目的・背景**：StaxRipユーザーが手動でGitHubリリースページを確認し、新バージョンをダウンロード・展開する手間を省きます。バージョン比較により不要なダウンロードを防ぎ、自動更新プロセスを効率化します。7-Zipを使用した高圧縮アーカイブの展開にも対応しています。

**バッチの実行タイミング**：ユーザーが更新を確認したい時に手動で実行します。StaxRipの起動前または終了後に実行することが推奨されます。

**主要な処理内容**：
1. PowerShellバージョンの確認（バージョン3以上が必要）
2. 管理者権限の確認と表示
3. 現在インストールされているバージョンの取得
4. GitHubリリースページから最新バージョン情報の取得
5. バージョン比較と更新要否の判定
6. 必要に応じてStaxRipプロセスの終了
7. 7-Zipのダウンロード（未存在の場合）
8. 最新リリースアーカイブのダウンロードと展開
9. 一時ファイルのクリーンアップ
10. StaxRipの起動

**前後の処理との関連**：独立した更新スクリプトです。実行前にStaxRipが終了している必要はありませんが、スクリプト内でプロセスを終了させます。

**影響範囲**：StaxRipインストールディレクトリ全体が更新されます。設定ファイル等は保持される可能性がありますが、更新内容によっては上書きされることがあります。

## バッチ種別

更新処理 / ダウンロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ユーザー任意） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShellバージョン | バージョン3以上 |
| インターネット接続 | GitHubへのアクセスが可能であること |
| TLS 1.2対応 | セキュリティプロトコル要件 |
| StaxRip.exeの存在 | 更新対象のStaxRipがインストールされていること |

### 実行可否判定

- ローカルバージョンがリモートバージョン以上の場合、ダウンロードはスキップされます
- PowerShellバージョンが2以下の場合、エラーで終了します

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| StaxRip.exe | 実行ファイル | 現在のバージョン情報取得元 |
| GitHub API | Web | 最新リリース情報取得元 |
| SourceForge | Web | 7-Zipダウンロード元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| StaxRipインストールディレクトリ | ファイル群 | 更新されたStaxRip |
| コンソール | テキスト | 進捗・状態メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 一時ファイル | StaxRip.7z（更新後削除） |
| 7-Zipディレクトリ | ./7z/（更新後削除） |
| Update.bat | 更新後削除 |

## 処理フロー

### 処理シーケンス

```
1. 管理者権限チェック
   └─ Test-Admin関数で確認し、結果を表示
2. PowerShellバージョンチェック
   └─ バージョン3未満の場合はエラー終了
3. TLSプロトコル設定
   └─ TLS 1.2を有効化
4. StaxRipプロセス終了
   └─ 実行中の場合は強制終了
5. バージョン比較
   └─ ローカルとリモートのバージョンを比較
6. 更新要否判定
   └─ 最新版の場合はスキップ
7. 最新版ダウンロード
   └─ GitHubからStaxRip.7zをダウンロード
8. 7-Zipダウンロード（必要時）
   └─ SourceForgeから7za.exeをダウンロード
9. アーカイブ展開
   └─ 7zaでStaxRip.7zを展開
10. クリーンアップ
    └─ 一時ファイルを削除
11. StaxRip起動
    └─ 更新完了後に起動
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[管理者権限チェック]
    B --> C[PowerShellバージョンチェック]
    C -->|バージョン2以下| D[エラー終了]
    C -->|バージョン3以上| E[TLS 1.2設定]
    E --> F[StaxRipプロセス終了]
    F --> G[バージョン取得・比較]
    G --> H{更新が必要?}
    H -->|No| I[最新版メッセージ表示]
    I --> J[クリーンアップ]
    J --> K[完了]
    H -->|Yes| L[StaxRipダウンロード]
    L --> M{7-Zip存在?}
    M -->|No| N[7-Zipダウンロード・展開]
    M -->|Yes| O[アーカイブ展開]
    N --> O
    O --> P[クリーンアップ]
    P --> Q[StaxRip起動]
    Q --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | PowerShellエラー | バージョン2以下 | PowerShellをアップグレード |
| - | ネットワークエラー | GitHub/SourceForgeにアクセスできない | ネットワーク接続を確認 |
| - | 展開エラー | 7-Zipの展開に失敗 | ディスク容量・権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

try-catchブロックで例外をキャッチし、エラーメッセージを表示して終了コード1で終了します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（更新失敗時は元の状態が保持されない可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の更新 |
| 目標処理時間 | ネットワーク速度に依存（数分〜十数分） |
| メモリ使用量上限 | 最小限 |

## 排他制御

StaxRipプロセスを終了させてから更新を行うため、排他制御は実質的に行われます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 管理者権限 | 開始時 | 権限状態（黄/赤色） |
| バージョン情報 | 比較時 | 現在/最新ビルド番号（赤/緑色） |
| 進捗メッセージ | 処理中 | ダウンロード/展開状況（緑色） |
| 完了メッセージ | 終了時 | "Operation Complete"（マゼンタ色） |
| エラーメッセージ | エラー時 | 例外メッセージ（赤色） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理成功/失敗 | 失敗時 | コンソール出力 |

## 備考

- 本スクリプトはLegacyフォルダに配置されており、将来的に廃止される可能性があります
- GitHubリリースURL: https://github.com/Revan654/staxrip/releases/latest
- 7-ZipダウンロードURL: http://download.sourceforge.net/sevenzip/7za920.zip
- バージョン番号パターン: [0-9].[0-9].[0-9].[0-9].x64.7z
- User-AgentにFirefoxを偽装してダウンロードを行います
- Read-KeyOrTimeoutで9秒のタイムアウト付きキー入力待ちが実装されていますが、メインフローでは使用されていません
- Get-Arch関数（PE形式解析）が実装されていますが、現在は使用されていません
