# バッチ設計書 9-Update.py

## 概要

本ドキュメントは、GitHubから最新のStaxRipリリースをダウンロードして自動更新するPythonスクリプト「Update.py」の設計書です。PowerShell版（Update.ps1）のPython実装であり、レガシースクリプトとして分類されています。

### 本バッチの処理概要

このスクリプトは、StaxRipの自動更新機能をPythonで提供するスクリプトで、現在インストールされているバージョンとGitHub上の最新リリースバージョンを比較し、新しいバージョンが利用可能な場合に自動的にダウンロード・展開・更新を行います。

**業務上の目的・背景**：PowerShell版のUpdate.ps1と同等の機能をPythonで提供します。Pythonが利用可能な環境では、PowerShellよりもクロスプラットフォームに近い実行環境を提供できます。BeautifulSoup、requests、tqdm等の外部ライブラリを使用し、HTMLパース、HTTPリクエスト、進捗表示などの機能を実装しています。

**バッチの実行タイミング**：ユーザーが更新を確認したい時に手動で実行します。StaxRipの起動前または終了後に実行することが推奨されます。

**主要な処理内容**：
1. 現在インストールされているStaxRipのバージョンを取得（Win32 API使用）
2. GitHubリリースページから最新バージョン情報をスクレイピング
3. バージョン比較と更新要否の判定
4. 必要に応じてStaxRipプロセスの終了（psutil使用）
5. 7-Zipのダウンロード（SourceForgeから）
6. 最新リリースアーカイブのダウンロードと展開（進捗バー表示付き）
7. 一時ファイルのクリーンアップ
8. StaxRipの起動

**前後の処理との関連**：独立した更新スクリプトです。Update.ps1の代替として使用できます。

**影響範囲**：StaxRipインストールディレクトリ全体が更新されます。

## バッチ種別

更新処理 / ダウンロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ユーザー任意） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python環境 | Python 3.x がインストールされていること |
| 必要ライブラリ | beautifulsoup4, html5lib, requests, tqdm, psutil, pywin32 |
| インターネット接続 | GitHubへのアクセスが可能であること |
| Windows環境 | win32apiを使用するためWindows限定 |
| StaxRip.exeの存在 | 更新対象のStaxRipがインストールされていること |

### 実行可否判定

- ローカルバージョンがリモートバージョン以上の場合、ダウンロードはスキップされます

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| StaxRip.exe | 実行ファイル | 現在のバージョン情報取得元（Win32 API） |
| GitHub | Web/HTML | 最新リリース情報取得元（スクレイピング） |
| SourceForge | Web | 7-Zipダウンロード元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| StaxRipインストールディレクトリ | ファイル群 | 更新されたStaxRip |
| コンソール | テキスト | 進捗・状態メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 一時ファイル | {version}.x64.7z（更新後削除） |
| 7-Zipディレクトリ | ./7z/（更新後削除） |

## 処理フロー

### 処理シーケンス

```
1. バージョン取得
   └─ Win32 APIでStaxRip.exeのバージョンを取得
2. 最新バージョン確認
   └─ BeautifulSoupでGitHubリリースページをパース
3. バージョン比較
   └─ ローカルとリモートのバージョンを文字列比較
4. 更新要否判定
   └─ 最新版の場合はメッセージ表示して終了
5. プロセス終了
   └─ psutilでStaxRipプロセスを終了
6. 7-Zipダウンロード
   └─ SourceForgeからダウンロード、ZIP展開
7. StaxRipダウンロード
   └─ tqdmで進捗表示しながらダウンロード
8. アーカイブ展開
   └─ 7za.exeでx64.7zを展開
9. クリーンアップ
   └─ 一時ファイルとディレクトリを削除
10. StaxRip起動
    └─ os.systemで起動
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[ローカルバージョン取得]
    B --> C[GitHubから最新バージョン取得]
    C --> D{バージョン比較}
    D -->|ローカル >= リモート| E[最新版メッセージ表示]
    E --> F[終了]
    D -->|ローカル < リモート| G[StaxRipプロセス終了]
    G --> H[7-Zipダウンロード]
    H --> I[StaxRipダウンロード]
    I --> J[アーカイブ展開]
    J --> K[クリーンアップ]
    K --> L[StaxRip起動]
    L --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RequestException | GitHub/SourceForgeにアクセスできない | ネットワーク接続を確認 |
| - | ImportError | 必要ライブラリがインストールされていない | pip installで依存ライブラリをインストール |
| - | Win32APIエラー | バージョン情報取得に失敗 | StaxRip.exeが正しい場所に存在するか確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

RequestExceptionをキャッチしてエラーログを出力します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の更新 |
| 目標処理時間 | ネットワーク速度に依存（数分〜十数分） |
| メモリ使用量上限 | 最小限 |

## 排他制御

psutilでStaxRipプロセスを終了させてから更新を行うため、排他制御は実質的に行われます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| バージョン情報 | 比較時 | Local Build / Release Build |
| ダウンロード進捗 | ダウンロード中 | tqdmによる進捗バー |
| 処理状況 | 処理中 | "Downloading 7z" / "Downloading StaxRip"等 |
| 完了メッセージ | 最新版時 | "Your Already Running the Latest Release" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理成功/失敗 | 失敗時 | コンソール出力 |

## 備考

- 本スクリプトはLegacyフォルダに配置されており、将来的に廃止される可能性があります
- 依存ライブラリ：
  - beautifulsoup4: HTMLパース
  - html5lib: HTML5パーサー
  - requests: HTTPリクエスト
  - tqdm: 進捗バー表示
  - psutil: プロセス管理
  - pywin32: Win32 API（バージョン取得）
- TqdmUpToクラス: tqdmを拡張してurllib.request.urlretrieveと連携
- simple_get関数: requestsを使用したシンプルなHTTPゲット
- BeautifulSoupでHTMLをパースしてリリース情報を抽出
- os.systemで7za.exeを呼び出してアーカイブを展開
- shutil.rmtreeで7zディレクトリを削除
- proc.kill()でStaxRipプロセスを強制終了
- PowerShell版（Update.ps1）と同等の機能を提供しますが、実装の詳細は異なります
- GitHubリリースURL: https://github.com/Revan654/staxrip/releases/latest
