---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：1-Build.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な時間の根拠なし
  2. **CI/CDパイプライン対応**：ソースコードからは直接確認できない
  3. **排他制御の推奨事項**：暗黙的な仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Build.ps1` 行1-64（スクリプト全体）
- E-02: `Source/Build.ps1` 行1-10（変数定義部分）
- E-03: `Source/Build.ps1` 行35-52（非ASCII文字チェック部分）
- E-04: `Source/Build.ps1` 行56-57（MSBuildによるビルド実行）
- E-05: `Source/Build.ps1` 行61-63（バージョン情報取得・表示）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行2

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソリューションファイルをReleaseモードでビルドする | E-04 | ○ |
| C-02 | x64プラットフォームでビルドする | E-04 | ○ |
| C-03 | 非ASCII文字チェックを実行する | E-03 | ○ |
| C-04 | Apps、.vb、.mdファイルを除外してチェック | E-03 | ○ |
| C-05 | MSBuild.exeを使用してビルドする | E-02, E-04 | ○ |
| C-06 | ビルド成功後にバージョン情報を表示する | E-05 | ○ |
| C-07 | FileVersionInfoを取得する | E-05 | ○ |
| C-08 | 緑色でバージョン情報を表示する | E-05 | ○ |
| C-09 | ビルド失敗時に例外をスローする | E-04 | ○ |
| C-10 | 非ASCII検出時に例外をスローする | E-03 | ○ |
| C-11 | binディレクトリに成果物を出力する | E-02 | ○ |
| C-12 | $excludeBinPatternsは定義されているが使用されない | E-01 | ○ |
| C-13 | コマンドライン引数は受け付けない | E-01 | ○ |
| C-14 | 目標処理時間は数分程度 | **根拠なし** | △ |
| C-15 | 本スクリプトはRelease.ps1、BuildAndPack.ps1と共通の変数定義を持つ | E-01, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：プロジェクト規模やビルド環境に依存するため、ソースコードからは特定できません
  - 候補：実行ログの分析 / ベンチマーク測定 / 開発チームへのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本スクリプトは標準的なビルドスクリプトであり、破壊的な操作は含まれていません
- 1: 中リスク - MSBuildの失敗時のエラーハンドリングは$LastExitCodeのみで、詳細なエラー情報は提供されません

## 6) レビュアーチェックリスト（最小）
- [ ] 非ASCII文字チェックの除外対象（Apps、.vb、.md）が適切か確認
- [ ] MSBuildのパスが環境に応じて正しく設定されるか確認
- [ ] バージョン情報の表示形式が期待通りか確認
