---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-Release.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な時間の根拠なし
  2. **出力先ディレクトリの存在前提**：環境依存の可能性
  3. **FileBuildPart分岐の意図**：同じ処理のため意図不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Release.ps1` 行1-101（スクリプト全体）
- E-02: `Source/Release.ps1` 行1-31（変数定義・除外パターン）
- E-03: `Source/Release.ps1` 行35-52（非ASCII文字チェック部分）
- E-04: `Source/Release.ps1` 行56-57（MSBuildによるビルド実行）
- E-05: `Source/Release.ps1` 行61-69（バージョン情報取得・ディレクトリ名決定）
- E-06: `Source/Release.ps1` 行73-87（ファイルコピー処理）
- E-07: `Source/Release.ps1` 行91-96（7-Zipアーカイブ作成）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行3

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソリューションファイルをReleaseモードでビルドする | E-04 | ○ |
| C-02 | x64プラットフォームでビルドする | E-04 | ○ |
| C-03 | 非ASCII文字チェックを実行する | E-03 | ○ |
| C-04 | MSBuild.exeを使用してビルドする | E-02, E-04 | ○ |
| C-05 | 出力先はA:\StaxRip-Releases | E-02 | ○ |
| C-06 | バージョン情報からターゲットディレクトリ名を決定 | E-05 | ○ |
| C-07 | 既存ターゲットディレクトリを削除する | E-06 | ○ |
| C-08 | 除外パターンに基づいてファイルをフィルタリング | E-02, E-06 | ○ |
| C-09 | フィルタリング後のファイルをコピー | E-06 | ○ |
| C-10 | 7-Zipで圧縮する | E-07 | ○ |
| C-11 | LZMA2アルゴリズムを使用 | E-07 | ○ |
| C-12 | 辞書サイズ1024MBを使用 | E-07 | ○ |
| C-13 | 最高圧縮レベル（-mx9）を使用 | E-07 | ○ |
| C-14 | 3スレッドを使用（-mmt3） | E-07 | ○ |
| C-15 | 除外パターンにSettingsフォルダが含まれる | E-02 | ○ |
| C-16 | 除外パターンにログファイルが含まれる | E-02 | ○ |
| C-17 | 除外パターンにPDBファイルが含まれる | E-02 | ○ |
| C-18 | 処理完了時に"Successfully finished"を表示 | E-01 | ○ |
| C-19 | FileBuildPartで分岐するが同じ処理を実行 | E-05 | ○ |
| C-20 | 目標処理時間は数分〜十数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：プロジェクト規模、ビルド環境、圧縮対象サイズに依存するため特定できません
  - 候補：実行ログの分析 / ベンチマーク測定 / 開発チームへのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なリリーススクリプトであり、意図した通りに動作します
- 1: 中リスク - 出力先ディレクトリ（A:\StaxRip-Releases）がハードコードされており、環境によっては存在しない可能性があります
- 1: 中リスク - FileBuildPartの分岐が同じ処理を実行しており、意図が不明確です

## 6) レビュアーチェックリスト（最小）
- [ ] 出力先ディレクトリ（A:\StaxRip-Releases）が環境に存在するか確認
- [ ] 除外パターンが要件を満たしているか確認
- [ ] 圧縮設定（辞書サイズ1024MB）がメモリ要件として適切か確認
- [ ] FileBuildPartの分岐の意図を確認（現在は同じ処理）
