---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-BuildAndPack.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **業務上の目的・背景**：推測に基づく部分あり
  2. **FileBuildPart分岐の意図**：同じ処理のため意図不明
  3. **出力先ディレクトリの存在**：環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/BuildAndPack.ps1` 行1-85（スクリプト全体）
- E-02: `Source/BuildAndPack.ps1` 行1-31（変数定義部分）
- E-03: `Source/BuildAndPack.ps1` 行35-52（非ASCII文字チェック部分）
- E-04: `Source/BuildAndPack.ps1` 行56-57（MSBuildによるビルド実行）
- E-05: `Source/BuildAndPack.ps1` 行61-69（バージョン情報取得）
- E-06: `Source/BuildAndPack.ps1` 行73-80（アーカイブ作成処理）
- E-07: `Source/BuildAndPack.ps1` 行77（PDBパス生成）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行4

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソリューションファイルをReleaseモードでビルドする | E-04 | ○ |
| C-02 | x64プラットフォームでビルドする | E-04 | ○ |
| C-03 | 非ASCII文字チェックを実行する | E-03 | ○ |
| C-04 | EXEとPDBのみをアーカイブに含める | E-06 | ○ |
| C-05 | 出力ファイル名に"-EXE"サフィックスが付く | E-05 | ○ |
| C-06 | System.IO.Path.ChangeExtensionでPDBパスを生成 | E-07 | ○ |
| C-07 | 7-Zipで圧縮する | E-06 | ○ |
| C-08 | LZMA2アルゴリズムを使用 | E-06 | ○ |
| C-09 | 辞書サイズ1024MBを使用 | E-06 | ○ |
| C-10 | 最高圧縮レベル（-mx9）を使用 | E-06 | ○ |
| C-11 | 既存アーカイブを削除してから作成 | E-06 | ○ |
| C-12 | 処理完了時に"Successfully finished"を表示 | E-01 | ○ |
| C-13 | Release.ps1と同じ圧縮オプションを使用 | E-06 | ○ |
| C-14 | ファイルコピー処理がない（Release.ps1との違い） | E-01 | ○ |
| C-15 | FileBuildPartで分岐するが同じ処理を実行 | E-05 | ○ |
| C-16 | 中間リリースやホットフィックス用途 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 業務上の目的・用途：ソースコードからは直接確認できず、ファイル名（"-EXE"サフィックス）と内容（EXE+PDBのみ）からの推測です
  - 候補：開発チームへのヒアリング / プロジェクトドキュメント / Gitコミット履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なビルド・パッケージングスクリプト
- 1: 中リスク - FileBuildPartの分岐が同じ処理を実行しており、意図が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] EXEとPDBのみの配布が要件を満たしているか確認
- [ ] 出力先ディレクトリ（A:\StaxRip-Releases）が環境に存在するか確認
- [ ] "-EXE"サフィックスでRelease.ps1の出力と区別できているか確認
- [ ] PDBファイルの配布がセキュリティポリシーに反しないか確認
