---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 115
  claims_with_evidence: 112
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：Controls モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 115、根拠なし：3
- 優先レビュー（高）
  1. **C-78 FiltersListView.Load**: p.Script参照の実際の挙動は外部依存
  2. **C-94 OnItemCheck Resize連携**: MainForm連携の実際の挙動は外部依存
  3. **C-99 OnHandleDestroyed**: 親フォームのDialogResult取得は外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/MacroEditorControl.vb`
- E-02: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/x264Control.vb`
- E-03: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/x265Control.vb`
- E-04: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/SvtAv1EncAppControl.vb`
- E-05: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/SvtAv1EncAppPsyexControl.vb`
- E-06: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/SvtAv1EncAppEssentialControl.vb`
- E-07: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/SvtAv1EncAppHdrControl.vb`
- E-08: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/vvencFFappControl.vb`
- E-09: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/FiltersListView.vb`
- E-10: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/PreprocessingControl.vb`
- E-11: `/Users/tomoka.baba/Work/staxrip-master/Source/Controls/CommandLineControl.vb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MacroEditorControl.Newでコントロールが正しく初期化される | E-01 (line 220-232) | ○ |
| C-02 | Text(Get)がgb.Textを返す | E-01 (line 258-264) | ○ |
| C-03 | Text(Set)がgb.Textに反映される | E-01 (line 262-264) | ○ |
| C-04 | Value(Get)がFixBreak処理して返す | E-01 (line 269-271) | ○ |
| C-05 | Value(Set)がrtbEdit.Textに反映される | E-01 (line 273-279) | ○ |
| C-06 | IsCommandLineModeがTrueの場合EditTextChangedが呼ばれる | E-01 (line 276-278) | ○ |
| C-07 | SetCommandLineDefaultsでAutoWrap=True設定 | E-01 (line 282-286) | ○ |
| C-08 | SetScriptDefaultsでAutoWrap=False設定 | E-01 (line 288-293) | ○ |
| C-09 | SetMacroDefaultsでAutoWrap=False設定 | E-01 (line 295-300) | ○ |
| C-10 | UpdateWrapModeで改行なしテキストでWordWrap=True | E-01 (line 302-313) | ○ |
| C-11 | UpdateWrapModeで改行ありテキストでWordWrap=False | E-01 (line 304) | ○ |
| C-12 | UpdateWrapModeで幅超過時ScrollBars=Both | E-01 (line 307-311) | ○ |
| C-13 | UpdatePreviewでSpecialMacrosFunctionがnullでない場合 | E-01 (line 319-325) | ○ |
| C-14 | UpdatePreviewでSpecialMacrosFunctionがnullの場合 | E-01 (line 323) | ○ |
| C-15 | ApplyThemeでテーマが適用される | E-01 (line 247-253) | ○ |
| C-16 | ApplyThemeでデザインモード時スキップ | E-01 (line 248-250) | ○ |
| C-17 | OnLoadでrtbDefaults空時にtpDefaults削除 | E-01 (line 345-348) | ○ |
| C-18 | EditTextChangedでPackage名含む場合llHelp表示 | E-01 (line 361-378) | ○ |
| C-19 | EditTextChangedでPackage名含まない場合llHelp非表示 | E-01 (line 378) | ○ |
| C-20 | Disposeでイベントハンドラ解除 | E-01 (line 234-237) | ○ |
| C-21 | x264Control.Newでコントロール初期化 | E-02 (line 92-132) | ○ |
| C-22 | x264Control.Newでカスタム QualityDefinitions使用 | E-02 (line 98-110) | ○ |
| C-23 | x264Control.Newでデフォルト QualityDefinitions使用 | E-02 (line 100-110) | ○ |
| C-24 | SetQualityで品質値設定 | E-02 (line 210-215) | ○ |
| C-25 | SetQualityで境界値0設定 | E-02 (line 101, 210-215) | ○ |
| C-26 | SetPresetでプリセット値設定 | E-02 (line 217-228) | ○ |
| C-27 | SetTuneでチューン値設定 | E-02 (line 230-238) | ○ |
| C-28 | GetQualityCaptionで一致時キャプション付き | E-02 (line 240-248) | ○ |
| C-29 | GetQualityCaptionで不一致時数値のみ | E-02 (line 247) | ○ |
| C-30 | UpdateControlsでQualityMode時3行表示 | E-02 (line 250-260) | ○ |
| C-31 | UpdateControlsでQualityModeでない時2行表示 | E-02 (line 256-260) | ○ |
| C-32 | UpdateControlsでTwoPass/ThreePass時blCompCheck表示 | E-02 (line 262) | ○ |
| C-33 | ApplyThemeで全ButtonLabelにテーマ適用 | E-02 (line 148-163) | ○ |
| C-34 | OnLayoutでカラム幅設定 | E-02 (line 165-184) | ○ |
| C-35 | QualityItemが正しく初期化される | E-02 (line 278-288) | ○ |
| C-36 | x265Control.Newでコントロール初期化 | E-03 (line 91-129) | ○ |
| C-37 | x265Control.SetQualityで品質値設定 | E-03 (line 235-240) | ○ |
| C-38 | SetPresetでApplyPresetValuesとApplyTuneValues呼出 | E-03 (line 242-252) | ○ |
| C-39 | SetTuneでApplyPresetValuesとApplyTuneValues呼出 | E-03 (line 254-264) | ○ |
| C-40 | SetAqModeでAQモード値設定 | E-03 (line 266-273) | ○ |
| C-41 | SetDolbyVisionProfileでDVプロファイル設定 | E-03 (line 275-282) | ○ |
| C-42 | SetRangeでRange値設定 | E-03 (line 284-291) | ○ |
| C-43 | UpdateControlsでQualityMode時6行表示 | E-03 (line 303-313) | ○ |
| C-44 | UpdateControlsでTwoPass/ThreePass時blCompCheck表示 | E-03 (line 314) | ○ |
| C-45 | GetQualityCaptionで一致時キャプション付き | E-03 (line 293-301) | ○ |
| C-46 | SvtAv1EncAppControl.Newでコントロール初期化 | E-04 (line 93-134) | ○ |
| C-47 | SvtAv1EncAppControl.Newでカスタム定義使用 | E-04 (line 97-112) | ○ |
| C-48 | SetQualityでConstantRateFactor/QuantizationParameter両方設定 | E-04 (line 250-256) | ○ |
| C-49 | SetPresetでApplyPresetValues呼出 | E-04 (line 258-267) | ○ |
| C-50 | SetTuneでチューン値設定 | E-04 (line 269-276) | ○ |
| C-51 | SetFastDecodeでFastDecode値設定 | E-04 (line 278-285) | ○ |
| C-52 | SetLookaheadでLookahead値設定 | E-04 (line 287-294) | ○ |
| C-53 | SetFilmGrainでFilmGrain値設定 | E-04 (line 296-303) | ○ |
| C-54 | UpdateControlsでQualityモード時6行表示 | E-04 (line 319-331) | ○ |
| C-55 | UpdateControlsでQualityモードでない時blCompCheck表示 | E-04 (line 332) | ○ |
| C-56 | Disposeで全イベントハンドラ解除 | E-04 (line 136-142) | ○ |
| C-57 | QualityItemが正しく初期化される | E-04 (line 348-358) | ○ |
| C-58 | SvtAv1EncAppPsyexControl.Newでコントロール初期化 | E-05 (line 93-134) | ○ |
| C-59 | SvtAv1EncAppPsyexControl.SetQualityで両パラメータ設定 | E-05 (line 250-256) | ○ |
| C-60 | SvtAv1EncAppPsyexControl.UpdateControlsでQuality行表示 | E-05 (line 319-333) | ○ |
| C-61 | SvtAv1EncAppEssentialControl.Newでコントロール初期化 | E-06 (line 93-134) | ○ |
| C-62 | SetQualityでQuality値設定 | E-06 (line 263-269) | ○ |
| C-63 | SetQuantでQuality.Value=0設定 | E-06 (line 271-279) | ○ |
| C-64 | SetSpeedでApplyPresetValues呼出 | E-06 (line 281-290) | ○ |
| C-65 | SetPresetでSpeedLow.Value=0設定 | E-06 (line 292-302) | ○ |
| C-66 | UpdateControlsでSpeed優先時Speed行表示 | E-06 (line 367-369) | ○ |
| C-67 | UpdateControlsでPreset優先時Preset行表示 | E-06 (line 370-373) | ○ |
| C-68 | SvtAv1EncAppHdrControl.Newでコントロール初期化 | E-07 (line 93-134) | ○ |
| C-69 | SvtAv1EncAppHdrControl.SetQualityで両パラメータ設定 | E-07 (line 250-256) | ○ |
| C-70 | SvtAv1EncAppHdrControl.UpdateControlsでQuality行表示 | E-07 (line 319-333) | ○ |
| C-71 | VvencffappControl.Newでコントロール初期化 | E-08 (line 91-131) | ○ |
| C-72 | VvencffappControl.SetQualityで品質値設定 | E-08 (line 210-215) | ○ |
| C-73 | SetPresetでApplyPresetValues呼出 | E-08 (line 217-228) | ○ |
| C-74 | UpdateControlsでSingleQuantモード時2行表示 | E-08 (line 240-248) | ○ |
| C-75 | UpdateControlsでTwoPassモード時blCompCheck表示 | E-08 (line 251) | ○ |
| C-76 | GetQualityCaptionで一致時キャプション付き | E-08 (line 230-238) | ○ |
| C-77 | FiltersListView.Newでコントロール初期化 | E-09 (line 15-34) | ○ |
| C-78 | FiltersListView.LoadでFiltersがListViewに読み込まれる | E-09 (line 37-63) | △ |
| C-79 | Loadでフィルタ Active状態反映 | E-09 (line 47) | ○ |
| C-80 | LoadでName空時Script表示 | E-09 (line 50-53) | ○ |
| C-81 | MoveUpで選択アイテム上移動 | E-09 (line 152-168) | ○ |
| C-82 | MoveUpでIndex=0時移動しない | E-09 (line 159-161) | ○ |
| C-83 | MoveUpで選択なし時スキップ | E-09 (line 153-155) | ○ |
| C-84 | MoveDownで選択アイテム下移動 | E-09 (line 170-186) | ○ |
| C-85 | MoveDownで最後のアイテム時移動しない | E-09 (line 177-179) | ○ |
| C-86 | ReplaceClickで選択フィルタ置換 | E-09 (line 194-211) | ○ |
| C-87 | ReplaceClickでキャンセル時中断 | E-09 (line 198-200) | ○ |
| C-88 | InsertClickで選択位置に挿入 | E-09 (line 213-230) | ○ |
| C-89 | AddClickで末尾に追加 | E-09 (line 232-248) | ○ |
| C-90 | RemoveClickで確認後削除 | E-09 (line 259-263) | ○ |
| C-91 | RemoveClickでキャンセル時削除されない | E-09 (line 260) | ○ |
| C-92 | UpdateDocumentでFilters再構築 | E-09 (line 265-273) | ○ |
| C-93 | OnItemCheckでActive状態変更 | E-09 (line 300-316) | ○ |
| C-94 | OnItemCheckでResizeカテゴリ時SetTargetImageSize呼出 | E-09 (line 306-311) | △ |
| C-95 | OnKeyDownでDeleteキー処理 | E-09 (line 292-298) | ○ |
| C-96 | PreprocessingControl.Newでコントロール初期化 | E-10 (line 162-196) | ○ |
| C-97 | AddItemでDemuxerがリストに追加される | E-10 (line 238-243) | ○ |
| C-98 | GetTipsでヒント情報取得 | E-10 (line 219-236) | ○ |
| C-99 | OnHandleDestroyedでDialogResult.OK時s.Demuxers更新 | E-10 (line 245-257) | △ |
| C-100 | OnHandleDestroyedでOKでない時更新されない | E-10 (line 246) | ○ |
| C-101 | bnAdd_ClickでSelectionBoxでDemuxer選択追加 | E-10 (line 268-284) | ○ |
| C-102 | bnEdit_Clickで設定ダイアログ表示 | E-10 (line 286-291) | ○ |
| C-103 | bnRestore_Clickで確認後デフォルト復元 | E-10 (line 293-303) | ○ |
| C-104 | bnRestore_Clickでキャンセル時復元されない | E-10 (line 294) | ○ |
| C-105 | lv_SelectedIndexChangedでHasConfigDialog=True時bnEdit有効 | E-10 (line 259-262) | ○ |
| C-106 | lv_SelectedIndexChangedでHasConfigDialog=False時bnEdit無効 | E-10 (line 260-261) | ○ |
| C-107 | CommandLineControl.Newでコントロール初期化 | E-11 (line 91-95) | ○ |
| C-108 | MenuItenClickでテキスト空時値そのまま設定 | E-11 (line 111-112) | ○ |
| C-109 | MenuItenClickでテキストあり時スペース追加 | E-11 (line 113-115) | ○ |
| C-110 | MenuItenClickで$...$パターン時追加されない | E-11 (line 110) | ○ |
| C-111 | MenuItenClickでキャンセル時中断 | E-11 (line 104-106) | ○ |
| C-112 | EditPresetsでOK時Presets更新 | E-11 (line 119-142) | ○ |
| C-113 | EditPresetsでRestoreFunc設定時復元ボタン表示 | E-11 (line 125-135) | ○ |
| C-114 | bn_Clickでプリセットメニュー表示 | E-11 (line 145-151) | ○ |
| C-115 | CommandLineControl_LoadでCodeFont設定 | E-11 (line 157-161) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-78 (FiltersListView.Load)**: `p.Script`はグローバル変数であり、実際のVideoScriptインスタンスの振る舞いは外部モジュール依存。テストではモックが必要。
- **C-94 (OnItemCheck Resize連携)**: `g.MainForm.SetTargetImageSize`の呼び出しはMainFormとの連携であり、統合テストで検証が必要。
- **C-99 (OnHandleDestroyed)**: `FindForm.DialogResult`の取得は親フォームに依存するため、実際の挙動は統合テストで検証が必要。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テーマ適用、レイアウト処理、プロパティアクセサ関連 (計35件)
- **1 (中リスク)**: 状態管理、イベントハンドリング、表示更新関連 (計65件)
- **2 (高リスク)**: 品質値・プリセット設定、フィルタ操作、データ保存関連 (計15件)

## 6) レビュアーチェックリスト（最小）
- [ ] 高リスク項目（品質設定、フィルタ操作）のテストケースが正常系・異常系・境界値を網羅しているか
- [ ] 各エンコーダコントロール（x264, x265, SvtAv1, Vvenc）のQualityDefinitionsデフォルト値が正しいか
- [ ] FiltersListViewのドラッグ&ドロップ、キーボード操作のテストが漏れていないか
- [ ] Dispose時のイベントハンドラ解除が全クラスで網羅されているか
- [ ] 外部依存（p.Script, g.MainForm, s.Demuxers）を使用するテストケースにモック要件が明記されているか
